/* filename: EVALUATE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <common.h>
#include <parser.h>

unsigned MemoGetSize = MEMOPOOLSIZE;
// User can change his memo pool in the range 0..FFE8 bytes

char *SEvaluate(ExprHandle handle)
{
  static char buffer[48];
  void * p;
  double d;

  if (!handle)
    SetError(350, 1, Check_if_AssignExpr_was_called);
  p = Evaluate(handle);
  if (p) {
    switch(handle->ReturnType) {
      case 'D' :
        sprintf(buffer, InternalToDate(*(D_PTR)p));
        return buffer;

      case 'C' :
        return (C_PTR)p;

      case 'M' :
        return (M_PTR)p;

      case 'F' :
      case 'N' :
        d = *(N_PTR)p;
        if (DBFError == DivideByZero) {// arithmetic underflow: Divide by 0
          memset(buffer, '*', handle->Length);
          buffer[handle->Length] = 0;
        }
        else {
          if (fabs(d)*pow(10,(double) handle->Decimals) < 1)
            sprintf(buffer, "%*lE", handle->Length, d);
          else
            sprintf(buffer, "%*.*lf", handle->Length, handle->Decimals, d);
        }
        return buffer;

      case 'L' :
        return (*(L_PTR)p ? ".T." : ".F.");
    }
  }

  return "";
}

static char _tzfar ret[STRSIZ] = { 0 };

char *iEvaluate(const char *expression) // immediate Evaluate
{
  unsigned save;
  ExprHandle  h;

  *ret = 0;
  save = MemoGetSize;
  MemoGetSize = STRSIZ; // we do not need memo pool more than STRSIZ here
  h = AssignExpr(expression);
  if (h) {
    strncpy(ret, SEvaluate(h), STRSIZ-1);
    ret[STRSIZ-1] = 0;
    DisposeExpr(&h);
  }
  MemoGetSize = save;
  return ret;
}

void SetMemoExprSizeTo(unsigned size)
{
  if (size > 0xFFE8) 
    size = 0xFFE8;
  MemoGetSize = size;
}

unsigned GetMemoExprSize(void)
{
  return MemoGetSize;
}
