/* filename: DELETNDX.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <index.h>
#ifdef NDX_TYPE

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>

extern int OrderChanged;
long RecNoForDelete;       // number of record to be deleted

static int g_len, k_len; // current group and key length

static void MarkEmpty(void *block, long *eof, long current)
{
  size_t len;
  char  *ptr;

  ptr = (char *)block + 2 * sizeof(short);
  memset(block, 0, BLOCK_SIZE);
  len = strlen(SSI_TOKEN) + 1;
  memcpy(ptr, SSI_TOKEN, len);
  *(long *)(ptr + len) = *eof;
  *eof = current;
}

static int delete_leaf_key(PIndexType p)
{ // delete a key without re-positioning
  PNode cnode, nnode;
  int   tail_len;

  cnode = p->Index;
  nnode = (PNode) ((char *)cnode + g_len);
  --p->BlockBufferPtr->num_keys;
  tail_len = (p->BlockBufferPtr->num_keys - p->currnode) * g_len;
  if (tail_len > 0)
    memmove(cnode, nnode, tail_len); // don't use memcpy
  return (tail_len > 0) ? 1 : 0;
}

static int update_branch_key(PIndexType p, void *key, long bn, long update)
{
  int   count, kn;
  PNode cnode = p->Index;

  kn = p->BlockBufferPtr->num_keys;
  for (count = 0; cnode->block_num != bn; count++)
    cnode = (PNode) ((char *)cnode + g_len);
  if (count < kn)
    memcpy(cnode->Key, key, k_len);
  if (update)
    cnode->block_num = update;
  if ((p->currblock != p->header.root) && (count == kn))
    return FALSE;
  else
    return TRUE;
}

static int get_and_update(PIndexType p, long begin, void *key, int order)
{
  long  block_num;
  PNode node;

  block_num = p->currblock;
  node = Dfind_last(p, begin, order, FALSE);
  memcpy(key, node->Key, k_len);
  GetNode(block_num, order); // restore the position
  if (p->reusable) {
    MarkEmpty(p->BlockBufferPtr, &p->header.eof, block_num);
    p->Modified = 1;
  }
  SeekAndWrite(Selected, order, block_num, p->BlockBufferPtr);
  GetNode(up_path(order), order);
  return update_branch_key(p, key, block_num, begin);
}

static int delete_branch_key(PIndexType p,void *key,long block_num,int order)
{
  PNode cnode, nnode;
  int   n, tail_len = -1;

  cnode = Bfind_key(p, key);
  n = (--p->BlockBufferPtr->num_keys); // decrement num_keys
  while(cnode->block_num != block_num) {
    cnode = (PNode) ((char *)cnode + g_len);
    if (++NoDe > n)
      NoDe = GRTRNODE;
  }
  if (NoDe >= 0) {
    nnode = (PNode)((char *)cnode + g_len);
    tail_len = (n - NoDe) * g_len;
    memmove(cnode, nnode, tail_len+sizeof(long));// ! don't use memcpy
  }
  if (!n) {
    if (p->header.root == p->currblock) {
      p->header.root = p->Index->block_num;
      p->Modified = TRUE;
      return 1; // set a break
    }
    return get_and_update(p, p->Index->block_num, key, order) ? 1 : (-1);
    // return -1 in case if we need to update the branch up
  }
  if ((tail_len != -1) || (p->header.root == p->currblock))
    return 1;
  else
    return (NoDe >= 0) ? 0 : -1;
}

int DeleteIndexNode(void *key_info, int order)
{// deletes an entry of the tree
  PIndexType p;
  PNDXBlock  block_on;
  Node       last_node;
  int        saveorder, not_last, n, branch=0, update=0;
  long       blockno, prev_blockno=0L;

#ifdef NETLOG
  WriteLog("Deleting index node");
#endif
  p = Ind[Selected][order];
  // initialize globals
  k_len = p->header.key_len;
  g_len = p->header.group_len;
  saveorder = SyncOrder;   // _Find() uses SyncOrder, so modify it
  SyncOrder = order;
  _Find(key_info);
  if (saveorder != order) {
    OrderChanged = 1;
    SyncOrder = saveorder;
  }
  if (!Found)
    return -1;  // Error: could not find the proper key
  while (!memcmp(p->Index->Key, p->KeyStorage, k_len)
    && p->Index->DBFRecNo != RecNoForDelete && !p->EOFFlag)
    FindNextRecFunc();
  if (p->Index->DBFRecNo != RecNoForDelete) {
    if (p->header.unique)
      return 0;  // this is OK
    else
      return -1; // Error: could not find the proper key
  }
  blockno =  p->currblock;
  block_on = p->BlockBufferPtr;
  while(TRUE) {
    if (update) { // branch node, update keys
      if (update_branch_key(p, last_node.Key, prev_blockno, 0L)) {
        SeekAndWrite(Selected,order,p->currblock,p->BlockBufferPtr);
        break;
      }
    }
    else { // delete key node
      if (!branch && (block_on->num_keys == 1)) { // the last key in leaf
        memcpy(&last_node, block_on->block, g_len);
        if (p->reusable) {
          MarkEmpty(block_on, &p->header.eof, p->currblock);
          p->Modified = 1;
        }
        SeekAndWrite(Selected, order, p->currblock, block_on);
        if (p->currblock == p->header.root) {// root
          p->header.root = 1L;
          p->header.eof = 2L;
          p->Modified = 1;
          break;
        }
      }
      else {
        if (branch) {
          not_last = delete_branch_key(p, last_node.Key, prev_blockno, order);
          block_on = p->BlockBufferPtr; // might be changed by delete_branch_key()
          n = block_on->num_keys;
          if (!n && p->reusable) {
            MarkEmpty(block_on, &p->header.eof, p->currblock);
            p->Modified = 1;
          }
        }
        else {
          not_last = delete_leaf_key(p);
          if (p->currblock == p->header.root) // root is a leaf node
            not_last = 1;
          n = block_on->num_keys - 1;
        }
        SeekAndWrite(Selected,order, p->currblock, block_on);
        if (not_last > 0)
          break;
        if (not_last == 0) //if not_last == -1 do not change last_node
          memcpy(&last_node, block_on->block + n * g_len, g_len);
        else
          blockno = p->currblock;
        update = 1;
      }
    }
    prev_blockno = blockno;
    blockno = up_path(order);
    GetNode(blockno, order);
    block_on = p->BlockBufferPtr;
    branch = 1;
  }// while
  if (p->Modified)
    WriteAnchorNode(Selected, order);
#ifdef NETLOG
  WriteLog("Success: the key has been deleted");
#endif
  return 0;
}
#endif // NDX_TYPE
