/* filename: DELETIDX.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <index.h>
#ifndef NDX_TYPE
#include <string.h>

long  AvailableNode = 0;

static void UpdateTree(int i)  // only called by DeleteIndexNode
{
  int        coffset; // cache offset
  Node      *cnptr;   // current cache node pointer
  IndexType *p;
  Node      *pi;

  p =  Ind[Selected][i];
  pi = p->Index;

  // first update the cache
  if (!i && Cache[Selected] && (pi->Entry <= (long) CCacheSize[Selected])) {
    coffset = CNSize[Selected]*((int)pi->Entry-1);
    cnptr = (Node *) ((char *)Cache[Selected]+coffset);
    memcpy(cnptr, pi, CNSize[Selected]);
  }
  // then update the tree
  SeekAndWrite(Selected,i,pi->Entry,pi);
}

void DeleteIndexNode(int i)
{
  Node    LocalNode;
  Node    NodeQ, NodeX, NodeY, NodeZ;
  IndexType *p;
  Node      *pi;

  p =  Ind[Selected][i];
  pi = p->Index;
  if (!p)
    return;
#ifdef NETLOG
  WriteLog("Deleting index node");
#endif
  // store the current node before doing anything
  memcpy(&LocalNode,pi,(size_t)p->NodeSize);
  // is this node the BOF or EOF? If so, we need to FIND the neighboring
  // record and update BOF/EOF counters BEFORE we delete the node. In doing
  // this, watch for the only-one-record-in-the-file condition.. this is
  // handled specially -- we reset them back to initial values (we don't need
  // to look after the no-records-in-the-file condition, since we can't edit
  // records that aren't there.
  if (RecCount() == 1L) {
    p->Anchor.FirstRec = 0;
    p->Anchor.LastRec = 0;
    p->Modified = TRUE;
    WriteAnchorNode(Selected, i);
  }
  else {
    if(pi->DBFRecNo == p->Anchor.FirstRec) { // look for the new first rec
      p->Anchor.FirstRec = FindNextRecFunc();
      pi = p->Index;
      p->Modified = TRUE;
      WriteAnchorNode(Selected,i);
    }
    if (pi->DBFRecNo == p->Anchor.LastRec) {
      p->Anchor.LastRec = FindPriorRecFunc();
      pi = p->Index;
      p->Modified = TRUE;
      WriteAnchorNode(Selected,i);
    }
  }
  // BOF/EOF are taken care of; now restore Index and do the deleting
  memcpy(&p->NodeBuffer,&LocalNode,(size_t)p->NodeSize);
  pi = p->Index = &p->NodeBuffer; // reposition Index to point to original node

  // if the node to be deleted is the root node, and the root has only one
  // subtree, then we must restructure the tree slightly, because there is no
  // previous node.  In this case, we first rearrange the tree so that the top
  // of the subtree becomes the root, and the root is moved to be a one-node
  // subtree
  if (!pi->PreviousNode && (!pi->LessNode || !pi->GrtrNode)) {
    memcpy(&NodeQ, pi,(size_t)p->NodeSize);
    if (pi->GrtrNode > 0) {
      GetNode(pi->GrtrNode,i); // the x node MUST exist
      pi = p->Index;
      memcpy(&NodeX, pi,(size_t)p->NodeSize);
    }
    else {
      GetNode(pi->LessNode,i);
      pi = p->Index;
      memcpy(&NodeX, pi,(size_t)p->NodeSize);
    }
    if (NodeX.LessNode > 0) {
      GetNode(NodeX.LessNode,i);
      pi = p->Index;
      memcpy(&NodeY, pi,(size_t)p->NodeSize);
    }
    else
      NodeY.Entry = 0; // a signal that there is no Y node
    if (NodeX.GrtrNode > 0) {
      GetNode(NodeX.GrtrNode,i);
      pi = p->Index;
      memcpy(&NodeZ, pi,(size_t)p->NodeSize);
    }
    else
      NodeZ.Entry = 0; // a signal that there is no Z node
    if (NodeQ.GrtrNode > 0) { // deal with a right hand subtree
      NodeQ.Entry = NodeX.Entry;
      NodeQ.PreviousNode = 1;
      NodeQ.LessNode = 0;
      NodeQ.GrtrNode = NodeY.Entry;
      NodeX.Entry = 1;
      NodeX.PreviousNode = 0;
      NodeX.LessNode = NodeQ.Entry;
      NodeX.GrtrNode = NodeZ.Entry; // value should not change

      NodeY.PreviousNode = NodeQ.Entry;
      NodeZ.PreviousNode = 1;
    }
    else { // deal with a left hand subtree
      NodeQ.Entry = NodeX.Entry;
      NodeQ.PreviousNode = 1;
      NodeQ.LessNode = NodeZ.Entry;
      NodeQ.GrtrNode = 0;
      NodeX.Entry = 1;
      NodeX.PreviousNode = 0;
      NodeX.LessNode = NodeY.Entry;   // value should not change
      NodeX.GrtrNode = NodeQ.Entry;

      NodeY.PreviousNode = 1;
      NodeZ.PreviousNode = NodeQ.Entry;
    }
    //  at this point, index might point to our cache (due to calls to
    // GetNode. To prevent messing up the case with the "move"s, we need to
    // repoint Index to something benign, like NodeBuffer
    p->Index = &p->NodeBuffer;
    pi = p->Index;
    memcpy(pi,&NodeQ,(size_t)p->NodeSize);
    UpdateTree(i); // updates Node Q
    memcpy(pi, &NodeX,(size_t)p->NodeSize);
    UpdateTree(i); // updates Node X
    if (NodeY.Entry > 0) {
      memcpy(pi,&NodeY,(size_t)p->NodeSize);
      UpdateTree(i); // updates Node Y, if it exist
    }
    if (NodeZ.Entry > 0) {
      memcpy(pi, &NodeZ,(size_t)p->NodeSize);
      UpdateTree(i); // updates Node Z, if it exists
    }
    GetNode(NodeQ.Entry,i); // position the tree on the same key as before
    pi = p->Index;
  }

  // if the node to be deleted is a LEAF, then we just need to "remove" the
  // node from the tree. This is done by going to the previous node and
  // setting the pointing branch to 0:
  if (!pi->GrtrNode && !pi->LessNode) { // node is a leaf..remove it
    memcpy(&NodeQ,pi,(size_t)p->NodeSize);
    GetNode(pi->PreviousNode,i);   // go to Node X
    pi = p->Index;
    if (pi->GrtrNode == NodeQ.Entry)
      pi->GrtrNode = 0;
    else {
      if (pi->LessNode == NodeQ.Entry)
        pi->LessNode = 0;
      else
        goto oops;
    }
    if (!AvailableNode)
      AvailableNode = NodeQ.Entry;
    else
      goto oops;
    UpdateTree(i); // update Node X
    return;
  }
  // if the node to be deleted has only ONE subtree. This is done by going
  // to the previous node and setting the pointing branch to that subtree
  if (!pi->GrtrNode || !pi->LessNode) { // node has exactly one subtree (leafs were handled first)
    memcpy(&NodeQ,pi,(size_t)p->NodeSize);
    GetNode(pi->GrtrNode ? pi->GrtrNode : pi->LessNode,i);
    pi = p->Index;
    // Index is now the subtree node, Node Y
    memcpy(&NodeY,pi,(size_t)p->NodeSize);
    pi->PreviousNode = NodeQ.PreviousNode;   // so Node Y points back to Node X
    UpdateTree(i);   // update Node Y
    GetNode(pi->PreviousNode,i);   // go to node X
    pi = p->Index;
    if (pi->GrtrNode == NodeQ.Entry) {
      pi->GrtrNode = NodeY.Entry;
      UpdateTree(i);   // update Node X
    }
    else
      if (pi->LessNode == NodeQ.Entry) {
        pi->LessNode = NodeY.Entry;
        UpdateTree(i);   // update Node X
      }
      else
        goto oops;
    if (!AvailableNode)
      AvailableNode = NodeQ.Entry;
    else
      goto oops;
    return;
  }
  // to get to this point, the node must have BOTH subtrees. Our job is
  // then to replace this node with the next node in key order. And there MUST
  // be a next node, since this node was NOT a leaf:
  memcpy(&NodeQ,pi,(size_t)p->NodeSize);
  if (NodeQ.DBFRecNo == FindNextRecFunc())
    goto oops;
  pi = p->Index;
  // FindNextRec also positioned Index to Node X
  // in theory, the "next" record should have a NULL lesser node pointer:
  if(pi->LessNode)
    goto oops;
  // this "next" is going to be "moved" to the node to be deleted. that
  // means that the previous node now has to point to X's greater node
  // pointer. So, find the previous node and do just that:
  memcpy(&NodeX,pi,(size_t)p->NodeSize);
  GetNode(pi->PreviousNode,i);
  pi = p->Index;
  if (pi->GrtrNode == NodeX.Entry) { // Index is now Node Y
    pi->GrtrNode = NodeX.GrtrNode;
    UpdateTree(i);
  }
  else {
    if (pi->LessNode == NodeX.Entry) {
      pi->LessNode = NodeX.GrtrNode;
      UpdateTree(i);
    }
    else
      goto oops;
  }
  // the greater subtree from X (if any), call it Z, must now have
  // its previous pointer changed to point to node Y:
  if (NodeX.GrtrNode > 0) {
    GetNode(NodeX.GrtrNode,i);
    pi = p->Index;
    pi->PreviousNode = NodeX.PreviousNode;
    UpdateTree(i);
  }
  // now go back to the node we wanted to delete in the first
  // place, and put in the X node key value and record number:
  GetNode(NodeQ.Entry,i);
  pi = p->Index;
  strcpy(pi->Key,NodeX.Key);
  pi->DBFRecNo = NodeX.DBFRecNo;
  UpdateTree(i);
  if (!AvailableNode) { // this means we now have an available node:
    AvailableNode = NodeX.Entry;
    return;
  }
oops:
  SetError(254, 3, "[DeleteIndexNode]", error_deleting_node, IndexName(i));
  assertJumper();
  return;
}
#endif // NDX_TYPE
  
