/* filename: APPNDNDX.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <index.h>
#ifdef NDX_TYPE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>

extern int OrderChanged;

static int  g_len, k_len, is_leaf;// current group and key length, leaf-flag
static long eof_1, reuse = 0L;

static long reuseBlock(PIndexType p, long b_num, long *eof, int order)
{
  PNDXBlock n;
  long ret, num;
  size_t len;

  reuse = 0L;
  lseek(p->Ndx, 0L, SEEK_END);
  num = tell(p->Ndx) / BLOCK_SIZE;
  if (*eof >= num) {
    ret = (*eof)++;
    return ret;
  }
  ret = *eof;
  GetNode(ret, order);
  n = p->BlockBufferPtr;
  if (n->num_keys || n->modified || strcmp(n->block, SSI_TOKEN)) {
    ret = *eof = num;
    ++(*eof);
  }
  else {
    len = strlen(SSI_TOKEN) + 1 + 2 * sizeof(short);
    *eof = *(long *)((char *)n + len);
    reuse = ret;
  }
  GetNode(b_num, order); // restore position
  return ret;
}

static void insert_branch_key(PIndexType p, void *key, long less, long grtr)
{
  PNode cnode, nnode;
  int   tail_len, num_keys;

  num_keys = p->BlockBufferPtr->num_keys;
  cnode = Bfind_key(p, key);
  while(cnode->block_num != less) {
    cnode = (PNode) ((char *)cnode + g_len);
    if (++NoDe >= num_keys)
      NoDe = GRTRNODE;
  }
  nnode = (PNode) ((char *)cnode + g_len);
  if (NoDe == LESSNODE)
    tail_len = num_keys * g_len;
  else
    if (NoDe == GRTRNODE)
      tail_len = 0;
    else
      tail_len = (num_keys - NoDe) * g_len;
  tail_len += sizeof(long);
  ++p->BlockBufferPtr->num_keys;
  memmove(nnode, cnode, tail_len);// overlap ! do not use memcpy
  // with memcpy, if src and dest overlap, the behavior is undefined.
  memcpy(cnode->Key, key, k_len);
  cnode->block_num = less;
  cnode->DBFRecNo = 0L;
  nnode->block_num = grtr;
}

static int insert_leaf_key(PIndexType p, void *key, long rec_no)
{ //insert a key without positioning, previous call to Find has already done it
  PNode cnode, nnode;
  int   tail_len, ret;

  cnode = p->Index;
  nnode = (PNode) ((char *)cnode + g_len);
  tail_len = (p->BlockBufferPtr->num_keys - p->currnode) * g_len;
  ret =  ++p->BlockBufferPtr->num_keys;
  memmove(nnode, cnode, tail_len);// overlap ! don't use memcpy
  // with memcpy, if src and dest overlap, the behavior is undefined.
  cnode->block_num = 0L;
  cnode->DBFRecNo = rec_no;
  memcpy(cnode->Key, key, k_len);
  return ret;
}

static void get_last_key(PIndexType p, long begin, void *key, int order)
{
  long  saveblock;
  PNode node;

  saveblock = p->currblock;
  node = Dfind_last(p, begin, order, FALSE);
  memcpy(key, node->Key, k_len);
  GetNode(saveblock, order); // restore the position
}

static int put_leaf_node(PIndexType p, PNDXBlock blockO,
PNDXBlock blockN, void *key, long rec_no)
{
  Node node;
  PNode  cnode, nnode;
  PNDXBlock cur_block, saveblock = NULL;
  int     num_keys, tail_len, ret = 0;

  num_keys = blockN->num_keys - 1;
  memcpy(node.Key, key, k_len);
  node.DBFRecNo = rec_no;
  node.block_num = 0L;
  // find the last node in blockN
  cnode = (PNode)((char *)blockN->block + g_len * num_keys);
  if ((*p->cmp)(key, cnode->Key, k_len) > 0) {//at the very end of new
    nnode = (PNode) ((char *)cnode + g_len);
    memcpy(nnode, &node, g_len);
    ret = -(++blockN->num_keys);
    return ret;
  }
  // find the last node in blockO
  num_keys = blockO->num_keys - 1;
  cnode = (PNode)((char *)blockO->block + g_len * num_keys);
  if ((*p->cmp)(key, cnode->Key, k_len) > 0) {
    saveblock = p->BlockBufferPtr;
    p->BlockBufferPtr = cur_block = blockN;
    num_keys = blockN->num_keys;
    ret = -1;
  }
  else {
    cur_block = blockO;
    cnode = (PNode) blockO->block;
    ++num_keys;
  }
  cnode = Bfind_key(p, key);
  nnode = (PNode) ((char *)cnode + g_len);
  if (NoDe == LESSNODE)
    tail_len = num_keys * g_len;
  else
    if (NoDe == GRTRNODE) {
      tail_len = 0;
      ret = cur_block->num_keys;
    }
    else {
      tail_len = (num_keys - NoDe) * g_len;
      if (NoDe)
        ret = ret ? (-NoDe-1):NoDe;
      else
        ret = -1;
    }
  ++cur_block->num_keys;
  memmove(nnode, cnode, tail_len);// overlap ! do not use memcpy
  // with memcpy, if src and dest overlap, the behavior is undefined.
  memcpy(cnode, &node, g_len);
  if (saveblock)
    p->BlockBufferPtr = saveblock; // restore position
  return (ret < 0) ? ret : ret+1;
}

static int put_node(PIndexType p, PNDXBlock blockO, PNDXBlock blockN,
PNode node, int order, long greater, void * key)
{
  PNode  cnode, nnode;
  PNDXBlock cur_block, saveblock = NULL;
  int     num_keys, tail_len, flip = 0;

  num_keys = blockN->num_keys - 1;
  // find the last node in blockN
  cnode = (PNode)((char *)blockN->block + g_len * num_keys);
  if ((*p->cmp)(node->Key, cnode->Key, k_len) > 0) {
    nnode = (PNode) ((char *)cnode + g_len);
    //
    SeekAndWrite(Selected, order, p->currblock, blockO);
    get_last_key(p, nnode->block_num, nnode->Key, order);
    // try to change this to
    //      memcpy(nnode->Key, node->key, k_len);
    *(long *)((char *)nnode + g_len ) = greater;
    ++blockN->num_keys;
    return TRUE;
  }
  num_keys = blockO->num_keys - 1;
  cnode = (PNode)((char *)blockO->block + g_len * num_keys);
  nnode = (PNode) ((char *)cnode + g_len);
  if (nnode->block_num == node->block_num) { // this happens very seldom
    node->block_num = greater;
    memcpy(node->Key, key, k_len);
    flip = 0;
  }
  if ((*p->cmp)(node->Key, cnode->Key, k_len ) > 0) {
    saveblock = p->BlockBufferPtr;
    p->BlockBufferPtr = cur_block = blockN;
    num_keys = blockN->num_keys;
  }
  else {
    cur_block = blockO;
    cnode = (PNode) blockO->block;
    ++num_keys;
  }
  cnode = Bfind_key(p, node->Key);
  while(cnode->block_num != node->block_num && flip)
  {// added 08/21/93 asleep MA
    cnode = (PNode) ((char *)cnode + g_len);
    if (++NoDe >= num_keys)
      NoDe = GRTRNODE;
  }
  nnode = (PNode) ((char *)cnode + g_len);
  if (NoDe == LESSNODE)
    tail_len = num_keys * g_len;
  else
    if (NoDe == GRTRNODE)
      tail_len = 0;
    else
      tail_len = (num_keys - NoDe) * g_len;
  ++cur_block->num_keys;
  tail_len += sizeof(long);
  memmove(nnode, cnode, tail_len);// overlap ! do not use memcpy
  // with memcpy, if src and dest overlap, the behavior is undefined.
  memcpy(cnode, node, g_len);
  if (greater && node->block_num != greater)
    nnode->block_num = greater;
  if (saveblock)
    p->BlockBufferPtr = saveblock; // restore position
  if (cur_block == blockN && !NoDe)
    return FALSE;
  else
    return TRUE;
}

static int room(PNDXBlock block, short keys_max)
{
  if (is_leaf)
    return block->num_keys < keys_max;
  else
    return (block->num_keys < keys_max && (BLOCK_SIZE -
    block->num_keys * g_len - 2*sizeof(short)) >= sizeof(long));
}

static PNDXBlock split(PIndexType p, PNDXBlock blockO, int order)
{
  PNDXBlock blockN;
  int len, is_branch;
  void * frst, * scnd;

  if (p->reusable)
    eof_1 = reuseBlock(p, p->currblock, &p->header.eof, order);
  else
    eof_1 = p->header.eof++; // make some room for a new block
  if ((blockN = malloc(BLOCK_SIZE)) == NULL)
    return NULL;
  memset(blockN, 0, BLOCK_SIZE); // do we need this ?
  blockN->num_keys = blockO->num_keys / 2;
  blockO->num_keys -= blockN->num_keys;
  len =  blockN->num_keys * g_len;
  frst = (void *)blockN->block;
  scnd = (void *)((char *)blockO->block + blockO->num_keys * g_len);
  is_branch = is_leaf ? 0 : 1;
  memmove(frst, scnd, len + is_branch * sizeof(long));// cannot use memcpy here !!!
  blockO->num_keys -= is_branch;
  return blockN;
}

static char _tzfar keyb1[101] = { 0 };
static char _tzfar keyb2[101] = { 0 };
static Node _tzfar buf_node = { 0 };

int AppendIndex(const char *inkey, int order)
{// adds an entry onto the tree
  PIndexType  p;
  PNDXBlock   blockO, blockN, root_block;
  PNode       node_ptr;
  char *      key_ptr;
  long        block, rec, new_rootNo, pos2block;
  long        old_file_block=0L, new_file_block=0L;
  int         saveorder, reposition=0;

#ifdef NETLOG
  WriteLog("Appending new record to index");
#endif
  p = Ind[Selected][order];
  k_len = p->header.key_len;    // initialize globals
  g_len = p->header.group_len;
  is_leaf = 1;
  key_ptr = (char *)inkey;
  rec = RecNo();
  saveorder = SyncOrder;   // _Find() uses SyncOrder, modify it
  SyncOrder = order;
  _Find(inkey);
  if (saveorder != order) {
    OrderChanged = 1;
    SyncOrder = saveorder;
  }
  if (Found && p->header.unique) { // exit if Found and index is unique
    RawGo(rec);
    return 0;
  }
  blockO = p->BlockBufferPtr;
  while (TRUE) {
    if (!blockO) { // create a new root block
      if (p->reusable)
        new_rootNo = reuseBlock(p, p->currblock, &p->header.eof, order);
      else
        new_rootNo = p->header.eof++; // extend header
      if (new_rootNo < 0)
        return -1; // Error, but could this ever happen ??
      // maybe only when number-of-keys overflow occurs
      if ((root_block = malloc(BLOCK_SIZE)) == NULL) {
        SetError(InsufficientMemory, 1, "[AppendIndex]" );
        return -1;
      }
      node_ptr = Dfind_last(p, old_file_block, order, FALSE);
      memcpy(root_block->block, node_ptr, g_len);
      root_block->num_keys = 1;
      node_ptr = (PNode)root_block->block;
      node_ptr->block_num = p->header.root;
      node_ptr->DBFRecNo = 0L;
      *(long *)((char *)node_ptr + g_len) = new_file_block;
      p->header.root =  new_rootNo;
      SeekAndWrite(Selected, order, new_rootNo, root_block);
      if (Cache[Selected] && order == 0 && reuse) { // update Cache
        GetNode(reuse, order);
        memcpy(p->BlockBufferPtr, root_block, BLOCK_SIZE);
        reuse = 0L;
      }
      free(root_block);
      break;
    }// new root
    is_leaf = *(long *)blockO->block ? 0 : 1;
    if (room(blockO, p->header.keys_max)) {
      if (is_leaf)
        reposition = insert_leaf_key(p, key_ptr, rec);
      else
        insert_branch_key(p, keyb1, old_file_block, new_file_block);

      // update block on disk
      SeekAndWrite(Selected, order, p->currblock, blockO);
      break;
    }
    if ((blockN = split(p, blockO, order)) == NULL) {
      SetError(InsufficientMemory, 1, "[AppendIndex]");
      return -1;
    }
    blockO->modified = TRUE;
    if (is_leaf) {
      reposition = put_leaf_node(p, blockO, blockN, key_ptr, rec);
      buf_node.block_num = 0L;// old_file_block
      if (reposition > 0)// the new key has been appended to the old block
        pos2block = p->currblock;
      else {// the new key has been appended to the new block
        pos2block = eof_1;
        reposition = -reposition;
      }
    }
    else {// we should insert previous new block here
      buf_node.DBFRecNo = 0L;
      if (buf_node.block_num == new_file_block) {
        memcpy(buf_node.Key, keyb2, k_len);
        key_ptr = keyb1;
      }
      else {
        buf_node.block_num = old_file_block;
        memcpy(buf_node.Key, keyb1, k_len);
        key_ptr = keyb2;
      }
      if (put_node(p,blockO,blockN,&buf_node,order,new_file_block,key_ptr))
        buf_node.block_num = p->currblock;// old_file_block
      else
        buf_node.block_num = eof_1;// new_file_block
    }
    old_file_block = p->currblock;
    new_file_block = eof_1;
    // update block
    if (blockO->modified) // put_node() may flush it
      SeekAndWrite(Selected, order, old_file_block, blockO);
    node_ptr = (PNode)((char *)blockO->block + g_len * (blockO->num_keys - 1));
    if (is_leaf)
      memcpy(keyb1, node_ptr->Key, k_len);
    else {
      block = *(long *) ((char *)node_ptr + g_len);
      get_last_key(p, block, keyb1, order);
    }
    // write new block on disk
    SeekAndWrite(Selected, order, new_file_block, blockN);
    if (Cache[Selected] && order == 0 && reuse) { // update Cache
      GetNode(reuse, order);
      memcpy(p->BlockBufferPtr, blockN, BLOCK_SIZE);
      reuse = 0L;
    }
    node_ptr = (PNode)((char *)blockN->block + g_len * (blockN->num_keys - 1));
    if(is_leaf)
      memcpy(keyb2, node_ptr->Key, k_len);
    else {
      block = *(long *) ((char *)node_ptr + g_len);
      get_last_key(p, block, keyb2, order);
    }
    key_ptr =  keyb2;
    rec     =  new_file_block;
    free(blockN);
    if ((block = up_path(order)) != 0) {
      GetNode(block, order);
      blockO = p->BlockBufferPtr;
    }
    else
      blockO = NULL;
  } // while(1)
  p->Modified = TRUE;
  WriteAnchorNode(Selected, order);
#ifdef NETLOG
  WriteLog("Success: new key has been appended");
#endif
  // position to the newly added record if index is primary
  if (reposition-- && !order) {
    saveorder = SyncOrder;   // _Find() uses SyncOrder
    SyncOrder = order;
    _Find(inkey);
    if (saveorder != order) {
      OrderChanged = 1;
      SyncOrder = saveorder;
    }
    while((pos2block != p->currblock)
        && (reposition != p->currnode) && !p->EOFFlag)
      FindNextRecFunc();
  }
  return 0;
}
#endif // NDX_TYPE
  
