/* filename: APPENDNK.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>
#include <sayget.h>
#include <index.h>

extern long RecNoForDelete;

void AppendNewKey(void)// update all the indexes for "Selected"
{
  char       key[101];
  int        i, len;
  PIndexType p;
  int saveZerOrder = ZerOrder[Selected];

  ZerOrder[Selected] = 0;
#ifdef NET
  IndexesChanged();
#endif
  for (i = 0; i < MaxOrder; i++) {
    p = Ind[Selected][i];
    if(p) {
#ifdef NDX_TYPE
      len = p->header.key_len;
      SyncPOrder = i; // for parser
      memcpy(key, FarKey(i), len+1);
      if ((strlen(key) == (size_t)len) || !p->kiss) {
#ifdef NET
        ReadAnchorNode(Selected, i); // read the anchor off disk
#endif
        if (AppendIndex(key, i) == -1)
          break; // error condition
      }
#else
      strcpy(key, FarKey(i));
      len = p->KeyLength;
      if (strlen(key) == (size_t) len) {
#ifdef NET
        lseek(p->Ndx, 0, SEEK_SET); // read the anchor off disk
        read(p->Ndx, &p->NodeBuffer, (size_t)p->NodeSize);
        memcpy(&p->Anchor, &p->NodeBuffer, sizeof(HeaderRecordType));
#endif
        ++p->Anchor.TotalLiveNodes;
        p->Modified = TRUE;
        AppendIndex(key, i);
        WriteAnchorNode(Selected, i);
      }
#endif
      else {
        ZerOrder[Selected] = saveZerOrder;
        SetError(BadSize,10,incorrect_key_length_returned_by_user_defined_keymaker,
        "\r\n",expected_length,SInteger(len, 3),
        "\r\n",key_equals,"[",key,"] ",IndexName(i));
        assertJumper();
      }
    }
  }
#ifdef NDX_TYPE
  if (i-- != MaxOrder) { // if error occured (i.e. AppendIndex returned -1)
     // remove keys in previous indexes
    RecNoForDelete = RecCount(); // key for the last record must be deleted
    while(i > 0)
      if ((p = Ind[Selected][--i]) != NULL) {
        len = p->header.key_len;
        SyncPOrder = i; // for parser
        memcpy(key, FarKey(i), len+1);
        if ((strlen(key) == (size_t) len) || !p->kiss) {
#ifdef NET
          ReadAnchorNode(Selected, i); // read the anchor off disk
#endif
          if (DeleteIndexNode(key, i) == -1) {
            SetError(254,3, index_file_corrupted, IndexName(i),
                        " [AppendNewKey()]");
            break;
          }
        }
        else {
          ZerOrder[Selected] = saveZerOrder;
          SetError(BadSize,10,incorrect_key_length_returned_by_user_defined_keymaker,
          "\r\n",expected_length,SInteger(len, 3),
          "\r\n",key_equals,"[",key,"] ",IndexName(i));
          assertJumper();
        }
      }
  }
#endif
  ZerOrder[Selected] = saveZerOrder;
#ifdef NET
  SyncAll = 1;
  SyncIndexProc();
  SyncAll = 0;
#endif
}
