/* filename: TZHELP.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>

#include <dbf.h>
#include <index.h>
#include <sayget.h>
#include <memo.h>
#include <pick.h>
#include <vidpop.h>
#include <help.h>
#include <edit.h>

unsigned char NoHelpExistsFG = BLACK;
unsigned char NoHelpExistsBG = LIGHTGRAY;
unsigned char NormalTextFG = BLACK;
unsigned char NormalTextBG = LIGHTGRAY;
unsigned char FrameFG = RED;
unsigned char FrameBG = LIGHTGRAY;
unsigned char TopicPickBarFG = YELLOW;
unsigned char TopicPickBarBG = BLACK;
unsigned char HelpC1 = 0;
unsigned char HelpC2 = 0;
unsigned char HelpR1 = 0;
unsigned char HelpR2 = 0;
unsigned char HelpLineStyle = 0x81;   // SingleLine + Shadow
HelpRecord *Help  = NULL;
char  _tzfar HelpHeading[81] = "";
char *HelpIndexHeading = "Help Index";
int ComplainMode  = TRUE;

static struct {
   char *Name;
   int  Typ;
   int  Len;
} x[13] = {
  {"ACTIVITY", 'N', 2 },
  {"CONTEXT",  'C', 24},
  {"ITEM",     'N', 3 },
  {"TOPIC",    'C', 16},
  {"DESC",     'C', 32},
  {"TEXT",     'M', 10},
  {"C1",       'N', 3 },
  {"R1",       'N', 3 },
  {"C2",       'N', 3 },
  {"R2",       'N', 3 },
  {"LINESTYLE",'N', 3 },
  {"HEADING",  'C', 32},
  {"ORDER",    'N', 4 }
};

static void CreateHelpFile(char *HelpFile)
{
  dbfRecord     DataBase;
  FieldArray    FieldList;
  int count;

  memset(FieldList,0,sizeof(FieldList));
  memset(&DataBase,0,sizeof(dbfRecord));
  for (count = 0; count < 13; count++) {
    strcpy(FieldList[count].Name, x[count].Name);
    FieldList[count].Typ = x[count].Typ;
    FieldList[count].Len = x[count].Len;
    FieldList[count].Dec = 0;
  }
  CreateDbf(&DataBase,HelpFile,count,FieldList);
}

static void HelpErrorMessage(const char *msg)
{
  int LCol, RCol, MCol, saveX, saveY, SaveCursor;
  ActivityType SaveActivity;
  size_t len = strlen(msg);

  LCol = (80 - (len + 4)) / 2;
  if (LCol < 0)
    LCol = 0;
  RCol = LCol + len + 4;
  MCol = LCol + 2;
  PushWindow((char)LCol, 10, (char)(RCol+2), 13);// account for shadow
  PushColors();
  SetColorTo(NoHelpExistsFG, NoHelpExistsBG, 0, 0);
  saveX = wherex();
  saveY = wherey();

  Box(LCol,10,RCol, 12,(char)(unsigned)(SingleLine+Shadow),ErrorMessageBoxHeading);
  At(MCol,11, msg);
  PopColors();
  SaveCursor = CursorVisible();
  SetCursorOff();
  SaveActivity = Activity;
  Wait("");
  Activity = SaveActivity;
  if (SaveCursor)
    SetCursorOn();
  else
    SetCursorOff();
  gotoxy(saveX,saveY);
  PopWindow();
}

static char *HelpContextKey(void) // This is the KeyMaker for ORDER = 1
{
  static char _tzfar ret[32] = ""; // 25 + 2 + 3
  sprintf(ret, "%s%2ld%3ld", Help->_CONTEXT, Help->_ACTIVITY, Help->_ITEM);
  return ret;
}

static char *HelpTopicKey(void) // This is the KeyMaker for ORDER = 2
{
  static char _tzfar ret[52] = ""; // 17 + 33
  sprintf( ret, "%s%s", Help->_TOPIC, Help->_DESC);
  return ret;
}

static void PopDownHelp(void)
{
  ExitEdit = TRUE;
}

static int SetSizeAndColors(void)
{
  int r1, r2, c1, c2;

  if (!PushMemoData())  return FALSE;
  Wrap = TRUE;
  if ((HelpR1+ HelpR2+ HelpC1 + HelpC2) > 0) {// programmer has specified help window
    SetMemoWindowTo(HelpC1,HelpR1,HelpC2,HelpR2,HelpLineStyle,HelpHeading);
    WordWrapWidth = HelpC2 - HelpC1 - 1U;
  }
  else {
    if ((Help->_R1 + Help->_R2 + Help->_C1 + Help->_C2) > 0) {// author has specified help window
      SetMemoWindowTo((unsigned char)Help->_C1,(unsigned char)Help->_R1,(unsigned char)Help->_C2,
      (unsigned char)Help->_R2,(unsigned char)Help->_LINESTYLE,Trim(Help->_HEADING));
      WordWrapWidth = (unsigned char)(Help->_C2 - Help->_C1 - 1);
    }
    else {// auto-size the help window..the largest rectangle we can use
      // that does not cover the current cursor location
      if (wherex() > 40) {
        c1 = 1;
        c2 = wherex() - 3;
      }
      else {
        c2 = 77;
        c1 = wherex() + 3;
      }

      if (wherey() > MaxAvailRows() / 2) {
        r1 = 1;
        r2 = wherey() - 3;
      }
      else {
        r2 = MaxAvailRows() - 3;
        r1 = wherey() + 3;
      }

      SetMemoWindowTo((unsigned char)c1,(unsigned char)r1,(unsigned char)c2,
      (unsigned char)r2,(unsigned char)Help->_LINESTYLE,Trim(Help->_HEADING));
      WordWrapWidth = c2 - c1 - 1;
    }
  }
  SetMemoColorTo(NormalText,NormalTextFG,NormalTextBG);
  SetMemoColorTo(EditFrame,FrameFG,FrameBG);
  return TRUE;
}

static char *Topic(int i)
{
  static char _tzfar stbuf[55] = "";

  Skip(i);
  sprintf(stbuf, "%s %s", Help->_TOPIC, Help->_DESC);
  return stbuf;
}

static void HelpByTopic(void)
{
  long i;
  PickWindowType   SavePickSpecs;
  ActivityType SaveActivity;
  static long  LastRecordPicked = 0; // must be static

  if (RecCount() == 0) {
    HelpErrorMessage(No_help_topics_have_been_created);
    return;
  }

  memmove(&SavePickSpecs,PickSpecPtr,sizeof(SavePickSpecs));

  if ((HelpR1 + HelpR2 + HelpC1 + HelpC2) > 0)// programmer has specified help window
    SetPickWindowTo(HelpC1,HelpR1,HelpC2,HelpR2,HelpLineStyle,HelpIndexHeading);
  else {
    i = RecCount() + 6L; // 5L+1L
    if (i > 24L)
      i = 24L;
    SetPickWindowTo(15,5,67,(unsigned char)i,
    (unsigned char)Help->_LINESTYLE, HelpIndexHeading);
  }

  SetPickColorTo(NormalTextFG,NormalTextBG,TopicPickBarFG,TopicPickBarBG);
  SetOrderTo(2);
  if (LastRecordPicked == 0)
    GoTop();
  else
    Go(LastRecordPicked);
  i = PickList(Topic, 1L, RecCount(), 0L);
  SetOrderTo(1);
  memmove(PickSpecPtr, &SavePickSpecs, sizeof(SavePickSpecs));

  if (i < 1L)
    return;
  LastRecordPicked = i;

  if (!SetSizeAndColors()) {
    HelpErrorMessage(Insufficient_memory_for_help);
    return;
  }

  SetEditFKey(HelpContextHotKey, PopDownHelp);
  SetEditFKey(HelpAuthoringHotKey, NULL);
  SaveActivity = Activity;
  PushMouse();
  EditMemo(&Help->_TEXT, "NOSTATUS PLAIN WRAP NOHELP");
  PopMouse();
  PopMemoData();
  Activity = SaveActivity;
}

static void AddOrReplaceHelpRecord(ActivityType mActivity,unsigned char Item,
                                   int exists, int SameMemo)
{
  int   DontSaveHelp;
  long  LineStyle;
  ActivityType SaveActivity;
  int   SaveEditResult;
  int   saveX, saveY;
  int   SelfSize, saveEscapeOn;
  char  tmp[40];
  BOOL  WantsRaised, WantsRecessed, WantsShadow, WantsExplode;

  PushColors();
  SetColorTo(NormalTextFG,NormalTextBG,NormalTextBG,NormalTextFG);
  saveX = wherex();
  saveY = wherey();
  PushWindow(16, 10, 66+2, 20+1); // account for shadow
  Box(16, 10, 66, 20, (char)(unsigned)(SingleLine+Shadow), Additional_Information);

  SelfSize = Help->_R1 + Help->_R2 + Help->_C1 + Help->_C2 == 0;
  WantsShadow = (Help->_LINESTYLE & Shadow) ? 1 : 0;
  WantsExplode = (Help->_LINESTYLE & Explode) ? 1 : 0;
  WantsRaised = (Help->_LINESTYLE & Raised) ? 1 : 0;
  WantsRecessed = (Help->_LINESTYLE & Recessed) ? 1 : 0;

  if (exists)
    LineStyle = Help->_LINESTYLE & 0x0F;
  else
    LineStyle = 1;

  SGIncWhich();

  SayGet(18,11,Topic_Prompt,Help->_TOPIC,_S,16,0);
  SayGet(18,12,Description_prompt,Help->_DESC,_S,32,0);
  SayGet(18,13,Self_Size_Prompt,&SelfSize,_L,1,0);
  SayGet(18,14,Line_Style_Prompt,&LineStyle,_LI,1,0);
  SayGet(18,15,Shadow_Prompt,&WantsShadow,_L,1,0);
  SayGet(18,16,Explode_Prompt,&WantsExplode,_L,1,0);
  SayGet(18,17,Raised_Prompt,&WantsRaised,_L, 1, 0);
  SayGet(18,18,Recessed_Prompt,&WantsRecessed,_L, 1, 0);
  SayGet(18,19,Heading_Prompt,Help->_HEADING,_S,32,0);

  SaveActivity = Activity;
  Activity = _HelpSystem;
  SaveEditResult = EditResult;
  EditResult = 0;
  saveEscapeOn = EscapeEnabled;
  EscapeEnabled = 1;

  PushMouse();
  ReadGets();
  PopMouse();

  EscapeEnabled = saveEscapeOn;
  Activity = SaveActivity;
  DontSaveHelp = SameMemo && (EditResult > 0);
  EditResult = SaveEditResult;
  SGDecWhich();

  gotoxy(saveX,saveY);
  PopWindow();
  PopColors();

  // no action necessary if DontSaveHelp == TRUE: The Memo LongInt
  // didn't change, and the user ESCaped from the "Extra Info" screen,
  // so don't save the Help - there's nothing to save.
  if (!DontSaveHelp) {
    if (SelfSize)
      Help->_R1 = Help->_R2 = Help->_C1 = Help->_C2 = 0L;
    else
      GetMemoCoordinates(&Help->_C1,&Help->_R1,&Help->_C2,&Help->_R2);

    Help->_LINESTYLE = LineStyle;
    if (WantsShadow)   Help->_LINESTYLE += Shadow;
    if (WantsExplode)  Help->_LINESTYLE += Explode;
    if (WantsRaised)   Help->_LINESTYLE += Raised;
    if (WantsRecessed) Help->_LINESTYLE += Recessed;
    strcpy(Help->_HEADING, Ltrim(Trim(Help->_HEADING)));

    if (exists) {// Replace the existing Help being edited
      if (RLock())
        Replace();
      else
        HelpErrorMessage(Cant_lock_record_in_Help_file);
      Unlock();
    }
    else {// Append the new Help the user just built.
      Help->_ACTIVITY = (long) mActivity;
      Help->_ITEM = Item;
      sprintf(tmp,"%-18s", ContextID );
      tmp[18] = 0;
      sprintf( Help->_CONTEXT, "%s%6u", tmp, ContextNo );
      if (ALock())
        Append();
      else
        HelpErrorMessage(Cant_lock_Help_file_to_add_new_record);
      Unlock();
    }
  }
}

static void ContextHelp(int Authoring)
{
  ActivityType  SaveActivity;
  unsigned char Item;
  char Key[STRSIZ], tmp[40];
  long OldHelpMemo, R1, R2, C1, C2;
  int  same_memo;

  if (!Authoring && (RecCount() == 0)) {
    if (ComplainMode)
      HelpErrorMessage(No_help_exists_for_this_subject);
    return;
  }

  switch (Activity) {
    case _Menu:
      Item = MenuChoice;
      break;
    case _DataEntry:
      Item = SGFieldIndex;// absolute field number rather than SgFieldCode
      break;
    case _Calculator:
      Item = CalculatorState;
      break;
    case _User:
      Item = SubActivity;
      break;
    default:
      Item = 0;
  }

  sprintf(tmp,"%-18s", ContextID );
  tmp[18] = '\0';
  //  18 charcter ContextID
  //   6 digit ContextNo
  //   2 digit Activity Code
  sprintf(Key, "%s%6u%2d%3d", tmp, ContextNo, (int)Activity, (int)Item);

  Find(Key);

  // 4 possibilities:
  if (!Found && !Authoring) {
    if (ComplainMode)
      HelpErrorMessage(No_help_exists_for_this_subject);
    return;
  }
  if (!SetSizeAndColors()) {// save coordinates, colors..then set them
    HelpErrorMessage(Insufficient_memory_for_help);
    return;
  }
  if (Found && !Authoring) {
    SetEditFKey(HelpContextHotKey,PopDownHelp);
    SetEditFKey(HelpAuthoringHotKey,NULL);
    SaveActivity = Activity;
    PushMouse();
    EditMemo(&Help->_TEXT,"NOSTATUS WRAP PLAIN NOHELP");
    PopMouse();
    PopMemoData();   //  RestoreSizeAndColors;
    Activity = SaveActivity;
    return;
  }

  // we MUST be authoring to get here, and we may or may not have FOUND it
  SetEditFKey(HelpContextHotKey,NULL);
  SetEditFKey(HelpAuthoringHotKey,NULL);
  SaveActivity = Activity;
  OldHelpMemo = Help->_TEXT;
  PushMouse();
  EditMemo(&Help->_TEXT,"NOSTATUS WRAP");
  PopMouse();
  GetMemoCoordinates(&C1, &R1, &C2, &R2);
  PopMemoData();   //  RestoreSizeAndColors;
  same_memo = (OldHelpMemo == Help->_TEXT &&
  C1 == Help->_C1 && R1 == Help->_R1 &&
  C2 == Help->_C2 && R2 == Help->_R2);

  if (Help->_TEXT)
    AddOrReplaceHelpRecord(SaveActivity, Item, Found, same_memo);
  Activity = SaveActivity;
}

static void HandleHelp(char c)
{
  unsigned char _far *KeyboardFlags = (unsigned char _far *)MK_FP(0x0040,0x0017);
  unsigned char saveKeyFlags;  // length must be 1 byte !!
  int  saveArea, savedBASEOrder, saveCursor;
  char saveWatchKeys[STRSIZ];

  // to get here, the help system is installed (with SetHelpTo),
  // help is enabled (with SetHelpOn), and the user has pressed
  // a help hot key (c)

  saveArea = Selected;
  Selected = HelpWorkArea;
  savedBASEOrder = dBASEOrder;
  saveCursor = CursorVisible();
  strcpy(saveWatchKeys, WatchKeys);
  WatchKeys[0] =  0;
  dBASEOrder = FALSE; // do our work in C coordinates
  HelpEnabled = FALSE;// turn off help..or we can get awfully recusive!
  // save Ins, CapLock, NumLock, ScrollLock,
  // and forcing Shift, Alt, Ctrl to be low:
  saveKeyFlags = *KeyboardFlags & 0xF0;
  if( !IgnoreNumLock )
    *KeyboardFlags = *KeyboardFlags & 0xDF; // turn off NumLock
  *KeyboardFlags = *KeyboardFlags & 0xEF;   // turn off ScrollLock

  if (c == HelpContextHotKey)
    ContextHelp(FALSE);
  else
    if (c == HelpAuthoringHotKey)
      ContextHelp(TRUE);
    else
      if (c == HelpTopicHotKey)
        HelpByTopic();

  HelpEnabled = TRUE;   // restore help on exit
  if (saveCursor)
    SetCursorOn();
  else
    SetCursorOff();

  dBASEOrder = savedBASEOrder;
  Selected = saveArea;
  *KeyboardFlags = saveKeyFlags;// restore key settings
  strcpy(WatchKeys,saveWatchKeys);
}

void SetHelpTo(const char *HelpFileName, char ContextHotKey,
               char AuthoringHotKey, char TopicHotKey)
{
  int saveArea, SaveAutoHalt;
  char IndexName1[100], IndexName2[100], HelpFile[100];
  char temp[110];

  if (!*Trim(HelpFileName)) {// an empty HelpFile name is the way to close down the help system
    saveArea = Selected;
    Selected = HelpWorkArea;
    Use("",NULL,0);
    FreePtrClear((void*) &Help);
    HelpEnabled = FALSE;
    HelpRoutines.DoHelpProc = NULL;
    Selected = saveArea;
    return;
  }
  strcpy(HelpFile, AddExt(HelpFileName, "HLP"));

  if ((Help = (HelpRecord *)malloc(sizeof(HelpRecord))) == NULL) {
    HelpErrorMessage(Insufficient_memory_to_install_help_system);
    return;
  }

  saveArea = Selected;
  Selected = HelpWorkArea;
  if (!FileExists(HelpFile))
    CreateHelpFile(HelpFile);

  Use(HelpFile, (void *)Help, sizeof(HelpRecord));

  strcpy(IndexName1, ReplaceExt(HelpFile,"HND"));
  strcpy(IndexName2, ReplaceExt(HelpFile,"TND"));
  SaveAutoHalt = AutoHalt;
  SetAutoHaltOff();
  sprintf(temp, "%s NOCACHE", IndexName1);
#ifdef NDX_TYPE
  SetIndexToCB(HelpContextKey, temp, 1);
#else
  SetIndexTo(HelpContextKey, temp, 1);
#endif
  if (DBFError == 0) {
    sprintf(temp, "%s NOCACHE", IndexName2);
#ifdef NDX_TYPE
    SetIndexToCB(HelpTopicKey, temp, 2);
#else
    SetIndexTo(HelpTopicKey, temp, 2);
#endif
  }
  AutoHalt = SaveAutoHalt;

  if (DBFError > 0) {
    SetAutoHaltOff();
    sprintf(temp, "%s EXCLUSIVE", HelpFile);
    Use(temp, Help, sizeof(HelpRecord));
    AutoHalt = SaveAutoHalt;
    if (DBFError) {
      Selected = saveArea;
      FreePtrClear((void*) &Help);
      SetError(DBFError, 4, Could_not_open, HelpFile, EXCLUSIVE_for_indexing, " [SetHelpTo]" );
      return;
    }
#ifdef NDX_TYPE
    MakeIndexCB(HelpContextKey,IndexName1);
    MakeIndexCB(HelpTopicKey,IndexName2);
#else
    MakeIndex(HelpContextKey,IndexName1);
    MakeIndex(HelpTopicKey,IndexName2);
#endif
    Use(HelpFile, Help, sizeof(HelpRecord));
    sprintf(temp, "%s NOCACHE", IndexName1);
#ifdef NDX_TYPE
    SetIndexToCB(HelpContextKey, temp, 1);
#else
    SetIndexTo(HelpContextKey, temp, 1);
#endif
    sprintf(temp, "%s NOCACHE", IndexName2);
#ifdef NDX_TYPE
    SetIndexToCB(HelpTopicKey, temp, 2);
#else
    SetIndexTo(HelpTopicKey, temp, 2);
#endif
  }
  SetOrderTo(1);
  HelpRoutines.DoHelpProc = HandleHelp;
  Selected = saveArea;
  HelpContextHotKey = ContextHotKey;
  HelpAuthoringHotKey = AuthoringHotKey;
  HelpTopicHotKey = TopicHotKey;
}

void PopUpHelp(void)
{
  HandleHelp(HelpContextHotKey);
}
