/* filename: RESIZE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>

#include <dialog.h>
#include <edit.h>

extern Scrtype *Screen, *BufPtr;

void AddScrollBars(void);
int ScrollLock(void);

void RestoreRow(unsigned char Y)
{
  int i, j, Left, Right;

  if ((Y > 0) && (Y <= MaxAvailRows())) {
    Left = ActiveBox.blox;
    Right = ActiveBox.brux;
    if (EditorShade && (Right < 79))
      ++Right;
    for (i = Left - 1; i < Right; i++)
      for (j = 0; j < 2; j++)
        (*Screen)[Y-1][i][j] = (*BufPtr)[Y-1][i][j];
  }
}

void RestoreLLShadowPiece(unsigned char n)
{
  int i, j;

  if (EditorShade && ((int)(ActiveBox.bruy + 1) <= (int)(MaxAvailRows())))
    for (i = 0; i < (int)(n); i++)
      for (j = 0; j < 2; j++)
        (*Screen)[ActiveBox.bruy + i][ActiveBox.blox+1][j] = (*BufPtr)[ActiveBox.bruy + i][ActiveBox.blox+1][j];
}

void RestoreURShadowPiece(unsigned char n)
{
  int i, j;

  if (EditorShade)
    for (i = 0; i < (int)(n); i++)
      if (ActiveBox.brux + i < 80)
        for (j = 0; j < 2; j++)
          (*Screen)[ActiveBox.bloy][ActiveBox.brux + i][j] = (*BufPtr)[ActiveBox.bloy][ActiveBox.brux + i][j];
}

void DimRow(unsigned char Y)
{
  int Right, i;

  if (EditorShade && (Y > 0) && (Y <= MaxAvailRows())) {
    Right = ActiveBox.brux + 2;
    if (Right > 80)
      Right = 80;
    for (i = ActiveBox.blox + 1; i < Right; i++)
      (*Screen)[Y-1][i][1] = ShadowColor;
  }
}

void BrightenRow(unsigned char Y)
{
  int i, j, Right;

  if (EditorShade && (Y > 0) && (Y <= MaxAvailRows())) {
    Right = ActiveBox.brux + 2;
    if (Right > 80)
      Right = 80;
    for (i = ActiveBox.blox + 1; i < Right; i++)
      for (j = 0; j < 2; j++)
        (*Screen)[Y-1][i][j] = (*BufPtr)[Y-1][i][j];
  }
}

void RestoreColumn(unsigned char X)
{
  int i, j, Top, Bottom;

  if ((X > 0) && (X < 81)) {
    Top = ActiveBox.bloy;
    Bottom = ActiveBox.bruy;
    if (EditorShade && (Bottom < (int)(MaxAvailRows())))
      ++Bottom;
    for (i = Top - 1; i < Bottom; i++)
      for (j = 0; j < 2; j++)
        (*Screen)[i][X-1][j] = (*BufPtr)[i][X-1][j];
  }
}

void DimColumn(unsigned char X)
{
  int Bottom, i;
  unsigned char XPlusOne;

  if (EditorShade && (X > 0) && (X < 81)) {
    Bottom = ActiveBox.bruy + 1;
    if (Bottom > (int)(MaxAvailRows()))
      Bottom = MaxAvailRows();
    XPlusOne = X+1;
    if (XPlusOne > 80)
      XPlusOne = 80;
    for (i = ActiveBox.bloy; i < Bottom; i++) {
      (*Screen)[i][X-1][1] = ShadowColor;
      (*Screen)[i][XPlusOne-1][1] = ShadowColor;
    }
  }
}

void BrightenColumn(unsigned char X)
{
  int i, j, Bottom;
  unsigned char XPlusOne;

  if (EditorShade && (X > 0) && (X < 81)) {
    Bottom = ActiveBox.bruy;
    if (Bottom < (int)(MaxAvailRows()))
      ++Bottom;
    XPlusOne = X+1;
    if (XPlusOne > 80)
      XPlusOne = 80;
    for (i = ActiveBox.bloy; i < Bottom; i++)
      for (j = 0; j < 2; j++) {
        (*Screen)[i][X-1][j] = (*BufPtr)[i][X-1][j];
        (*Screen)[i][XPlusOne-1][j] = (*BufPtr)[i][XPlusOne-1][j];
      }
  }
}

unsigned char ShiftStatus(void)
{
  struct REGPACK cpu;

  memset(&cpu,0,sizeof(cpu));
  cpu.r_ax = 0x12 << 8;
  intr(0x16,&cpu);
  return cpu.r_ax;
}

int LeftShiftKey(void)
{
#ifdef _MSC_VER
  return *(char *)MK_FP(0x0040,0x0017) & 0x02;
#else
  return peekb(0x0040,0x0017) & 0x02;
#endif
}

int RightShiftKey(void)
{
#ifdef _MSC_VER
  return *(char *)MK_FP(0x0040,0x0017) & 0x01;
#else
  return peekb(0x0040,0x0017) & 0x01;
#endif
}

void RefreshStatusResize(void) // just refresh mode
{
  if (!nostatus) {
    window(ActiveBox.wlox,ActiveBox.wloy-1,ActiveBox.wrux,ActiveBox.wruy);
    gotoxy(1,1);
    switch (ResizeMode) {
      case Grow:
#ifdef _MSC_VER
        _outtext(Grow_Mode_Message);
#else
        cprintf(Grow_Mode_Message);
#endif
        break;
      case Shrink:
#ifdef _MSC_VER
        _outtext(Shrink_Mode_Message);
#else
        cprintf(Shrink_Mode_Message);
#endif
        break;
      case MoveMode:
#ifdef _MSC_VER
        _outtext(Move_Mode_Message);
#else
        cprintf(Move_Mode_Message);
#endif
        break;
    }
    window(ActiveBox.wlox,ActiveBox.wloy,ActiveBox.wrux,ActiveBox.wruy);
  }
}

void ResizeWindow(void)
{
#define LA 'K'
#define RA 'M'
#define UA 'H'
#define DA 'P'

  unsigned char k;
  unsigned char SaveWindowWidth;
  int SaveClearBoxes;
  ExplodeModeType SaveExplodeMode;
#ifdef _MSC_VER
  short top,left,bottom,right;
#else
  struct text_info ti;
#endif

  if (noresize || (!EditScreenSaved))
    return;
  SaveWindowWidth = WindowWidth;
  SaveClearBoxes = ClearBoxes;
  SaveExplodeMode = ExplodeMode;
  ResizeMode = MoveMode;
  DisplayEditorStatus();
  SetCursorOff();
  if (Expl)
    ActiveBox.LineStyle &= 0xBF;
  ClearBoxes = FALSE;
  HideMouse();
  do {
    do {
      if (!kbhit()) {
        ResizeMode = MoveMode;
        if (LeftShiftKey())
          ResizeMode = Shrink;
        if (RightShiftKey())
          ResizeMode = Grow;
        RefreshStatusResize();
      }
    } while (!(kbhit() || !ScrollLock()));
    if (kbhit()) {
      k = getch();
      if ((ResizeMode == Shrink) || (ResizeMode == Grow)) {
        switch (k) {
          case '8': k = UA; break;
          case '6': k = RA; break;
          case '2': k = DA; break;
          case '4': k = LA; break;
          case '\x00': k = getch(); break;
        }
      }
      else {
        if (k == '\x00') {
          k = getch();
          ResizeMode = MoveMode;
        }
        else
          ResizeMode = NoMoveMode;
      }
    }
    else
      ResizeMode = NoMoveMode;
    switch (ResizeMode) {
      case Shrink: {
        switch (k) {
          case UA:
            if (WindowDepth > 2) { // shrink, move bottom up
              RestoreRow(ActiveBox.bruy);
              BrightenRow((unsigned char)(ActiveBox.bruy + 1));
              DimRow(ActiveBox.bruy);
              RestoreLLShadowPiece(1);
              --ActiveBox.bruy;
            }
            break;
          case DA:
            if (WindowDepth > 2) { // shrink, move top row down
              RestoreRow(ActiveBox.bloy);
              RestoreURShadowPiece(2);
              ++ActiveBox.bloy;
            }
            break;
          case LA:
            if (WindowWidth > minwid) { // shrink, move right side in
              RestoreColumn(ActiveBox.brux);
              BrightenColumn((unsigned char)(ActiveBox.brux + 1));
              DimColumn(ActiveBox.brux);
              RestoreURShadowPiece(1);
              --ActiveBox.brux;
            }
            break;
          case RA:
            if (WindowWidth > minwid) { // shrink, move left side in
              RestoreColumn(ActiveBox.blox);
              RestoreLLShadowPiece(1);
              ++ActiveBox.blox;
            }
            break;
        }
      }
        break;
      case Grow: {
        switch (k) {
          case UA:
            if (ActiveBox.bloy > 1)
              --ActiveBox.bloy;
            break;
          case DA:
            if (ActiveBox.bruy < MaxAvailRows())
              ++ActiveBox.bruy;
            break;
          case LA:
            if (ActiveBox.blox > 1)
              --ActiveBox.blox;
            break;
          case RA:
            if (ActiveBox.brux < 80)
              ++ActiveBox.brux;
            break;
        }
      }
        break;
      case MoveMode: {
        switch (k) {
          case UA:
            if (ActiveBox.bloy > 1) { // Move box up
              RestoreRow(ActiveBox.bruy);
              BrightenRow((unsigned char)(ActiveBox.bruy + 1));
              DimRow(ActiveBox.bruy);
              RestoreLLShadowPiece(2);
              --ActiveBox.bloy;
              --ActiveBox.bruy;
            }
            break;
          case DA:
            if (ActiveBox.bruy < MaxAvailRows()) {
              RestoreRow(ActiveBox.bloy);
              DimRow((unsigned char)(ActiveBox.bruy + 2));
              RestoreURShadowPiece(2);
              ++ActiveBox.bloy;
              ++ActiveBox.bruy;
            }
            break;
          case LA:
            if (ActiveBox.blox > 1) { // Move box left
              RestoreColumn(ActiveBox.brux);
              BrightenColumn((unsigned char)(ActiveBox.brux + 1));
              DimColumn(ActiveBox.brux);
              RestoreURShadowPiece(1);
              --ActiveBox.blox;
              --ActiveBox.brux;
            }
            break;
          case RA:
            if (ActiveBox.brux < 80) {  /*  Move box right  */
              RestoreColumn(ActiveBox.blox);
              DimColumn((unsigned char)(ActiveBox.brux + 2));
              RestoreLLShadowPiece(1);
              ++ActiveBox.blox;
              ++ActiveBox.brux;
            }
            break;
        }
      }
        break;
    }
    ComputeWindowCoordinates();
    copyb = 1;
    copye = WindowWidth;
    EdBox(ActiveBox.blox,ActiveBox.bloy,ActiveBox.brux,ActiveBox.bruy,ActiveBox.LineStyle,ActiveBox.Header);
    DrawScreen();
    DisableMouse();
#ifdef _MSC_VER
    _gettextwindow(&top,&left,&bottom,&right);
    _settextwindow(1,1,25,80);
#else
    gettextinfo(&ti);
    window(1,1,80,25);
#endif
    AddScrollBars();
#ifdef _MSC_VER
    _settextwindow(top,left,bottom,right);
#else
    window(ti.winleft,ti.wintop,ti.winright,ti.winbottom);
#endif
    DisplayEditorStatus();
    SetCursorOff();
  }  while (!(!(ScrollLock()) || (k == '\x1B')));
  ShowMouse();
  if (k == '\x1B')
    *(char *)MK_FP(0x0040,0x0017) &= 0xEF; // turn scroll lock off for the guy
  if (Expl)
    ActiveBox.LineStyle = ActiveBox.LineStyle | 0x40;
  if (MemoIn)
    MemoBox = ActiveBox;
  else
    EditBox = ActiveBox;
  DisplayEditorStatus();
  ClearBoxes = SaveClearBoxes;
  ExplodeMode = SaveExplodeMode;
  PushMouse();
  if ((WindowWidth != SaveWindowWidth) && Wrap)
    if (DialogBox(reformat_text,yes_no_buttons) == yes_no_chars[0]) {
      WordWrapWidth = WindowWidth;
      EdReformat(WindowWidth);
    }
  PopMouse();
  SetCursorOn();
}
