/* filename: QEDITOR.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <dialog.h>
#include <pick.h>
#include <sayget.h>
#include <utils.h>
#include <vidpop.h>
#include <edit.h>

int ScreenLine = 0, AutoSaveChanged = FALSE, EditColumn = 0, Zapped = FALSE;
int CurrentLine = 0, editquit = FALSE, copyb = 0, copye = 0, NeverChanged = TRUE;
char editinkey = ' ', *EditSearchString=0, *EditReplacement=0, *EditOpt;
unsigned char fselect = 0;
FILE *getfile;

static int secnum = 0, editkeynum = 0;

void AddScrollBars(void);
void EdCharacter(void);
void FuncPgDn(void);
void FuncPgUp(void);
void HandleFunc(void);
unsigned char HorizontalIndicator(void);
void LoadFile(PathStr name);
unsigned char VerticalIndicator(void);

int ScrollLock(void)
{
  return ((*(char *)MK_FP(0x0040,0x0017) & 0x10) == 0x10);
}

static void Keys(void)
{
  EventRec e;
  char ch;

  if (ScrollLock()) {
    fselect = _resize;
    HandleFunc();
    return;
  }
  fselect = _UNDEFINED;
  if((editkeynum >= 1) && (editkeynum <= 27)) {
    ch = '\x00';
    if (!KeyMap[editkeynum][ch]) {
      GetEvent(&e);
      switch (e.WhichEvent) {
        case Keyboard:
          ch = toupper(e.v.sKeyboard.Key);
          if ((ch >= 'A') && (ch <= 'a'))
            ch = (ch - 64);
          break;
        case Mouse:   ;
	  break;
      }
    }
    fselect = KeyMap[editkeynum][ch];
  }
  if( (editkeynum >= 127) && (editkeynum <= 370) )
    fselect = FKeyMAP[editkeynum-128];
  if ((fselect == _userdefined) && (UserFunction != NULL)) {
    PushColors();
    ExitEdit = FALSE;
    dBASEOrder = SaveOrder;
    UserFunction(&editkeynum);
    dBASEOrder = FALSE;
    PopColors();
    if (ExitEdit) {
      fselect = _escape;
      HandleFunc();
    }
  }
  else {
    if ( ((editkeynum - 128) >= F1) && ((editkeynum - 128) <= AF10)
    && JumpTable[editkeynum-187]) {
      PushColors();
      ExitEdit = FALSE;
      dBASEOrder = SaveOrder;
      JumpTable[editkeynum -187]();
      dBASEOrder = FALSE;
      PopColors();
      if (ExitEdit) {
        fselect = _escape;
        HandleFunc();
      }
    }
    else
      HandleFunc();
  }
}

static int GetKey(int *secnum, char *inkey)
{
  EventRec e;
  char ch;
  int i, i1, ret = FALSE;

  while (!(ScrollLock() || EventPending())) ;
  if (ScrollLock()) {
    *secnum = TRUE;
    ret = TRUE;
  }
  else {
    GetEvent(&e);
    switch (e.WhichEvent) {
      case Keyboard:
        *inkey = e.v.sKeyboard.Key;
	*secnum = (*inkey == '\x00');
        if (*secnum) {
          ch = e.v.sKeyboard.ScanCode;
          editkeynum = (unsigned char)(ch) + 128;
        }
        else {
          *secnum = (*inkey <= 27) ? TRUE : FALSE;
          editkeynum = *inkey;
        }
	ret = TRUE;
        break;
      case Mouse:
        ret = FALSE;
      switch ((char)(e.v.sMouse.TargetID)) {
        case -1: // reposition cursor
          if (editnoedit && ((CurrentLine + e.v.sMouse.WindY - wherey()) > Highestline))
            return ret;
          if ((EditColumn + e.v.sMouse.X - e.v.sMouse.WindX - wherex() + 1) < STRSIZ-1) {
	    EditColumn += (e.v.sMouse.X - e.v.sMouse.WindX - wherex() + 1);
            ScreenColumn = e.v.sMouse.X - e.v.sMouse.WindX + 1;
            CurrentLine += (e.v.sMouse.Y - e.v.sMouse.WindY - wherey() + 1);
            if (CurrentLine > Highestline) {
              i1 = Highestline + 1;
              Highestline = CurrentLine;
              for (i = i1; i <= Highestline; i++)
                MakeEdiDynString("",i);
            }
	    ScreenLine = e.v.sMouse.Y - e.v.sMouse.WindY + 1;
          }
          RefreshStatus();
          break;
        case -2:
          if (HorizontalIndicator() > e.v.sMouse.X) {
            EditColumn -= WindowWidth;
            copyb -= WindowWidth;
            if (EditColumn < 1)
	      EditColumn = 1;
          }
          else
            if (HorizontalIndicator() < e.v.sMouse.X) {
              EditColumn += WindowWidth;
              copyb += WindowWidth;
              if (EditColumn > STRSIZ-2)
                EditColumn = STRSIZ-2;
            }
	  copyb = EditColumn;
          DrawScreen();
          break;
        case -3: // pan left
          while (IsLeftButtonDown())
            CursorLeft();
          if (EventPending()) // throw away event due to
            GetEvent(&e); // release of button
          break;
	case -4: // pan right
          while (IsLeftButtonDown())
            CursorRight(TRUE);
          if (EventPending()) // throw away event due to
            GetEvent(&e); // release of button
          break;
        case -5:
          if (VerticalIndicator() > e.v.sMouse.Y) // vertical scroll bar
            FuncPgUp();
	  else
            if (VerticalIndicator() < e.v.sMouse.Y)
              FuncPgDn();
          break;
        case -6:
          while (IsLeftButtonDown())
            CursorUp();
          if (EventPending())
            GetEvent(&e);
	  break;
        case -7:
          while (IsLeftButtonDown())
            CursorDown();
          if (EventPending())
            GetEvent(&e);
          break;
      }
        break;
    }
  }
  return ret;
}

void QuickEditor(char *DateiName)
{
  char buf[STRSIZ];

  EditSearchString = (char *) malloc(sizeof(PathStr));
  EditReplacement = (char *) malloc(sizeof(PathStr));
  EditOpt = (char *) malloc(sizeof(PathStr));
  if (!(EditSearchString && EditReplacement && EditOpt)) {
    FreePtrClear((void*) &EditSearchString);
    FreePtrClear((void*) &EditReplacement);
    FreePtrClear((void*) &EditOpt);
    SetError(InsufficientMemory, 1, " [EditText]");
    return;
  }
  memset(EditSearchString,0,sizeof(PathStr));
  memset(EditReplacement,0,sizeof(PathStr));
  memset(EditOpt,0,sizeof(PathStr));

  copyb = 1;
  copye = WindowWidth;
  editquit = FALSE;

  if (!fullscreen)
    EdBox(ActiveBox.blox,ActiveBox.bloy,ActiveBox.brux,ActiveBox.bruy,ActiveBox.LineStyle,ActiveBox.Header);
  SetTextColors();
  AddScrollBars();
  window(ActiveBox.wlox,ActiveBox.wloy,ActiveBox.wrux,ActiveBox.wruy);
  clrscr();
  if (MemoIn)
    strcpy(editfilename, ".");
  else {
    strcpy(DateiName,Ltrim(Trim(DateiName)));
    if ((Pos("*",DateiName)>=0) || (Pos("?",DateiName) >= 0))
      strcpy(DateiName,PickFile(DateiName));
    else
      if (*DateiName)
        strcpy(DateiName,AddExt(DateiName,DefaultExt));
    if ((Trim(DateiName)[0])) {
      _fullpath(buf,DateiName,81);
      strcpy(editfilename, buf);
    }
    else
      strcpy(editfilename, Defaultname);
  }
  gotoxy(1,1);
  if (!MemoIn) {
    if (FileExists(editfilename))
      LoadFile(editfilename);
    else
      if (Pos(Trim(Defaultname),editfilename) >= 0) {
        getfile = fopen(editfilename,"w");
        fclose(getfile);
        if ((errno && (errno != 2)) || !*editfilename || (*editfilename == ' ')) {
          sprintf(buf, "%s%s", editfilename,Is_an_Invalid_name);
          EditDialogBox(buf);
          editquit = TRUE;
          EditorResult = 0;
          return;
        }
        else {
          remove(editfilename);
          Txtin = TRUE;
        }
      }
    GetRawName(editfilename,RawFilename);
  }
  ClearBlockMarkers();
  CurrentLine = 1;
  ScreenLine = 1;
  Home();
  DisplayEditorStatus();
  DrawScreen();
  if (Show) {
    editquit = TRUE;
    return;
  }

  EditChanged = AutoSaveChanged = Zapped = FALSE;
  NeverChanged = TRUE;

  do {
    gotoxy(ScreenColumn,ScreenLine);
    secnum = FALSE;
    if (GetKey(&secnum,&editinkey)) {
      if (secnum)
        Keys();
      else
        if (!editnoedit)
          EdCharacter();
      RefreshStatus();
    }
    if (AutoSave && !MemoIn) {
      if (AutoSaveChanged)
        ++strokes;
      if (strokes == 500) {
        if (!BwriteOK(SaveWithNoPrompt)) {
          sprintf(buf,"%s%s",Error_writing,current_file);
          EditDialogBox(buf);
        }
        strokes = 0;
      }
      AutoSaveChanged = FALSE;
    }
  } while (!editquit);

  EditorResult = 0;
  if (!NeverChanged) {
    if (EditChanged)
      EditorResult = 1;
    else {
      EditorResult = 2;
      if (Zapped)
        EditorResult = 3;
    }
  }
  FreePtrClear((void*) &EditSearchString);
  FreePtrClear((void*) &EditReplacement);
  FreePtrClear((void*) &EditOpt);
}
