/* filename: PRINTOUT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>

#include <dialog.h>
#include <sayget.h>
#include <edit.h>

static FILE *f;

int SendToPrinter(char *s)
{
  char c, tmp[STRSIZ];

  do {
    c = ' ';
    if (!PrinterReady((char)(IntegerVal(LPTNumber)))) {
      sprintf(tmp, "%s CENTERTEXT;%s", Printer_not_ready,Retry_or_Abort);
      c = DialogBox(tmp,Retry_Abort_buttons);
      if (c == 'A') {
        fclose(f);
        return FALSE;
      }
    }
    else
      fprintf(f,"%s\n",s);
  } while (!(c == ' '));
  return TRUE;
}

void PrintOut(int blocd)
{
  int i, j;
  int a, b;
  char zstring[STRSIZ], ourprinter[5];
  char Margin[STRSIZ], tmp[STRSIZ], ch;
  EventRec e;

  do {
    if (blocd)
      ch = DialogBox(WantToPrintBlock, yes_no_buttons);
    else
      ch = DialogBox(WantToPrintDoc,yes_no_buttons);
    if ((ch == yes_no_chars[1]) || (ch == '\x1B'))
      goto Exp;
  }  while (!(ch == yes_no_chars[0]));
  sprintf(ourprinter,"LPT%s",LPTNumber);
  if((f = fopen(ourprinter,"wt")) == NULL) {
    EditDialogBox(Printer_not_ready);
    return;
  }
  if (PrinterReady((char)(IntegerVal(LPTNumber)))) {
    strcpy(Margin,Space(Lmarg));
    if (!blocd) {
      a = 1;
      b = Highestline;
    }
    else {
      a = BlockStartLine;
      b = BlockEndLine;
    }
    for (j = 1; j <= TMarg; j++)
      if (!SendToPrinter(""))
        return;
    for (i = a; i <= b; i++) {
      strcpy(zstring,Linebuffer[i-1]);
      if (EventPending()) {
        GetEvent(&e);
        switch (e.WhichEvent) {
          case Keyboard:
            ch = e.v.sKeyboard.Key;
            if (ch == '\x1B') {
              ch = '\x01';
              i = b;
            }
            break;
          case Mouse:   ;
            break;
        }
      }
      sprintf(tmp, "%s%s",Margin, zstring);
      if (!SendToPrinter(tmp))
        return;
      if ((i && (i % lpp == 0)) || (i == b)) {
        if (PrinterEject)
          if (!SendToPrinter("\f"))
            return;
        fflush(f);

        if (i != b) {
          do {
            ch = DialogBox(Print_next_page, yes_no_buttons);
            if ((ch == yes_no_chars[1]) || (ch == '\x1B')) {
              fclose(f);
              goto Exp;
            }
          }  while (!(ch == yes_no_chars[0]));

          for (j = 1; j <= TMarg; j++)
            if (!SendToPrinter(""))
              return;
        }
      }
    }
  }
  else
    EditDialogBox(Printer_not_ready);
  fclose(f);
Exp:
  RemoveDialogBox();
  DisplayEditorStatus();
  DrawScreen();
}
