/* filename: HELPF.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <conio.h>
#include <errno.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <dialog.h>
#include <help.h>
#include <pick.h>
#include <sayget.h>
#include <utils.h>
#include <vidpop.h>
#include <edit.h>

static EdMenuRecord *MenuList;
static char *TextString;
static FILE *TextFile;
static unsigned char MenuWidth=' ';
static char *MenuBuf;

void SetHelpColors(void);

char *GetMenu(int a)
{
  char *p = MenuList[--a].MenuItem;

  sprintf(MenuBuf,"%*s",(MenuWidth - strlen(p)) >> 1, p);
  return MenuBuf;
}

static int GetHelpStr(void)
{
  fgets(TextString,STRSIZ-1,TextFile);
  if (!ferror(TextFile)) {
    TextString[strlen(TextString)-1]=0;
    return 0;
  }
  else {
    clearerr(TextFile);
    EditDialogBox(Could_not_read_from_the_Editor_Help_file);
    return 1;
  }
}

static int GetMemClean(void **p, int size)
{
  if((*p = malloc(size)) == NULL) {
    SetError(217, 1, " [EditText]");
    return 0;
  }
  memset(*p,0,size);
  return 1;
}

void Helpf(void)
{
  unsigned char BoxBot, BoxLeft, BoxRight, BoxRows, BoxTop;
  int FileLine;
  int i, InText, press_len, s_len;
  unsigned char MaxHelpRows;
  unsigned char MenuCol, MenuCount, MenuRow;
  unsigned char PickChoice;
  PickWindowType PickSpecs;
  unsigned char TextLength;
  unsigned char TextWidth;
  char tmp[STRSIZ], ch;
  char buf[_MAX_PATH];
#ifdef _MSC_VER
  short top,left,bottom,right;
#else
  struct text_info ti;
#endif

//  memset(TextString, 0, _MAX_PATH);
  press_len = strlen(Press);
  if (NoHelp)
    return;
  MaxHelpRows = MaxAvailRows();
  // Maximum help menu choices must not be greater than 50 because there
  // are only 50 elements in the MenyType array to hold the strings.
  if (MaxHelpRows > 50)
    MaxHelpRows = 50;

  // If there isn't enough room to open the menu choice array, bail out now
  if (!GetMemClean((void**) &MenuList, sizeof(MenuType)))
    goto aout;
  if (!GetMemClean((void**) &MenuBuf, STRSIZ))
    goto aout;
  if (!GetMemClean((void**) &TextString, STRSIZ))
    goto aout;

  // save the existing window settings
#ifdef _MSC_VER
  _gettextwindow(&top,&left,&bottom,&right);
#else
  gettextinfo(&ti);

#endif
  // find the help file on the path if necessary
  if (!FileExists(helppath)) {
    _searchenv(helppath,"PATH",buf);
    if (buf)
      strcpy(TextString,buf);
    if (*TextString)
      strcpy(helppath, TextString);
  }
  if (!FileExists(helppath)) {
    sprintf(tmp,"%s%s",Could_not_Find_The_Help_File, helppath);
    EditDialogBox(tmp);
  }
  else {
    SetCursorOff();
    if ((TextFile = fopen(helppath,"r")) == NULL) {
      sprintf(tmp, "%s %d", Could_not_open_the_Help_File, errno);
      EditDialogBox(tmp);
      goto aout;
    }
    MenuWidth = MenuCount = TextLength = TextWidth = 0;
    InText = FALSE;
    BoxRows = 0;
    FileLine = 0;
    do {
      ++FileLine;
      if(GetHelpStr())
        goto bout;
      s_len = strlen(TextString);
      if (InText) {
        if (TextString[0] == '#') {
          if (BoxRows > TextLength)
            TextLength = BoxRows;
          if (s_len > (int)TextWidth)
            TextWidth = s_len;
          InText = FALSE;
        }
        else {
          ++BoxRows;
          if (s_len > (int)TextWidth)
            TextWidth = s_len;
        }
      }
      else {
        if (*TextString == '*') {
          BoxRows = 0;
          InText = TRUE;
          if ((int)MenuCount < ((int)MaxHelpRows - 2)) {
            strcpy(MenuList[MenuCount].MenuItem, TextString + 1);
            MenuList[MenuCount].ItemLoc = FileLine;
            if (s_len > (int)MenuWidth)
              MenuWidth = s_len;
          }
          ++MenuCount;
        }
      }
    }  while (!(feof(TextFile) || ((int)MenuCount >= ((int)MaxHelpRows - 2))));
    ++TextLength; // to add the instructon line at the bottom
    // calculate the help text and help menu window coordinates
    if (TextWidth > 76)
      TextWidth = 76;
    else
      if ((int)TextWidth < (press_len + 2))
        TextWidth = press_len + 2;
    if (TextLength > (unsigned char)(MaxHelpRows - 2))
      TextLength = MaxHelpRows - 2;
    BoxTop = (MaxHelpRows - (TextLength + 2)) / 2 + 1;
    BoxBot = BoxTop + TextLength + 1;
    BoxLeft = (80 - (TextWidth + 4)) / 2 + 1;
    BoxRight = BoxLeft + TextWidth + 3;
    BoxRows = (BoxBot - BoxTop) - 1;  // total rows inside window
    if ((int)MenuCount > (int)MaxHelpRows - 2)
      MenuCount = MaxHelpRows - 2;
    MenuWidth += 4; // to aid in centering choices
    if (MenuWidth > 76)
      MenuWidth = 76;
    MenuRow = (MaxHelpRows - (MenuCount + 2)) / 2 + 1;
    MenuCol = (80 - (MenuWidth + 2)) / 2 + 1;
    if (Expl) // deal with EXPLOSE mode
      ActiveBox.LineStyle &= 0xBF;
    do {
      // Repeatedly display the menu with the choices read above,
      // until the user escapes from this menu.
      memcpy(&PickSpecs,PickSpecPtr,sizeof(PickSpecs));
      SetPickWindowTo(MenuCol,MenuRow,(unsigned char)(MenuCol+MenuWidth+1),
      (unsigned char)(MenuRow + MenuCount + 1),SingleLine + Shadow,EDITOR_HELP_MENU);
      SetPickColorTo(ActiveColors.HelpTextFG,ActiveColors.HelpTextBG,
      ActiveColors.HelpTextBG,ActiveColors.HelpTextFG);
      PickChoice = (unsigned char)PickList(GetMenu,1,MenuCount,1);

      memcpy(PickSpecPtr,&PickSpecs,sizeof(PickSpecs));
      if (!PickChoice)
        goto bout;
      // Now, read through the TextFile until we get to the line that
      // contains the * Menu Choice string.
      fclose (TextFile);
      TextFile = fopen(helppath,"r");
      for (FileLine = 1; FileLine <= MenuList[PickChoice-1].ItemLoc; FileLine++)
      {
        if (GetHelpStr())
          goto bout;
      }
      *TextString = ' ';
      // Now open up the Text Block widnow and display the text lines.
      PushWindow((unsigned char)BoxLeft,(unsigned char)BoxTop,
                 (unsigned char)(BoxRight + 2),(unsigned char)(BoxBot + 1));
      PushColors();
      SetColorTo(ActiveColors.HelpFrameFG,ActiveColors.HelpFrameBG,
      ActiveColors.FrameFG,ActiveColors.FrameBG);
      sprintf(tmp," %s ",MenuList[PickChoice-1].MenuItem);
      EdBox(BoxLeft,BoxTop,BoxRight,BoxBot,ActiveBox.LineStyle,tmp);
      PopColors();
#ifdef _MSC_VER
      _settextwindow(BoxTop+1,BoxLeft+1,BoxBot-1,BoxRight-1);
#else
      window(BoxLeft+1, BoxTop+1, BoxRight-1, BoxBot-1);
#endif
      SetHelpColors();
      clrscr();
      // Fill the box with the help text
      SetHelpColors();
      FileLine = 1; //FileLine is now the line # we're about to write
      while (!feof(TextFile) && (*TextString != '#') &&
            (FileLine <= (int)TextLength)) {
        if (GetHelpStr())
          goto bout;
        if (*TextString != '#')
#ifdef _MSC_VER
        {
          sprintf(tmp,"\r\n%s",Copy(TextString,0,BoxRight -BoxLeft -3));
          _outtext(tmp);
        }
#else
        cprintf("\r\n%s",Copy(TextString,0,BoxRight - BoxLeft - 3));
#endif
        ++FileLine;
      }
      for (i = FileLine; i <= (int)TextLength + 1; i++)
#ifdef _MSC_VER
        _outtext("\r\n");
#else
        cprintf("\r\n");
#endif
#ifdef _MSC_VER
      sprintf(tmp,"%*s",(TextWidth - press_len) >> 1, Press);
      _outtext(tmp);
#else
      cprintf("%*s",(TextWidth - press_len)>>1, Press);
#endif
      ch = getch();
      if(!ch)
        ch = getch();
      PopWindow();
    } while (PickChoice);
bout:
    fclose(TextFile);
  }
aout:
  FreePtrClear((void*) &MenuBuf);
  FreePtrClear((void*) &MenuList);
  FreePtrClear((void*) &TextString);
  if (Expl)
    ActiveBox.LineStyle |= 0x40;
  // restore the prior window settings
#ifdef _MSC_VER
  _settextwindow(top,left,bottom,right);
#else
  window(ti.winleft,ti.wintop,ti.winright,ti.winbottom);
#endif
  SetCursorOn();
}
