/* filename: GETFNTSV.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <dbf.h>
#include <sayget.h>
#include <dialog.h>
#include <edit.h>

void GetRawName(char *full, char *back)
{
  char dir[_MAX_DIR];
  char name[_MAX_FNAME];
  char ext[_MAX_EXT];
  char drive[_MAX_DRIVE];
  char tmp[STRSIZ];

  _splitpath(full,drive,dir,name,ext);
  if (!dir[0]) {
    sprintf(tmp,"%Fs%s",actdir, full);
    strcpy(full,tmp);
  }
  sprintf(back,"%s%s",name,ext);
  PadTo(back,12);
  strcpy(back,Upper(back));
}

char *GetFilenameToSave(PathStr SuggestedName, FilePromptMode PromptMode)
{
  int Ok;
  PathStr name;
  char tmp[STRSIZ];

  if (nocreate)
    EditDialogBox(File_creation_not_permitted);
  else {
    do {
      do {
        WindowEdit((PromptMode == SaveBlock) ? Save_block_to : SAVE_TO, SuggestedName);
        if (!*SuggestedName)
          return "";
        strcpy(SuggestedName, AddExt(SuggestedName,DefaultExt));
        Ok = ValidFilename(SuggestedName);
        if (!Ok) {
          sprintf(tmp,"%s%s", SuggestedName,not_a_valid_DOS_filename);
          EditDialogBox(tmp);
        }
      }  while (!(Ok));
      GetRawName(SuggestedName,name);
      Ok = (strcmp(name,Defaultname));
      sprintf(tmp,"%s%s",name,is_a_reserved_name);
      if (!Ok)
        EditDialogBox(tmp);
      else {
        Ok = (!FileExists(SuggestedName));
        sprintf(tmp,"%s%s%s. %s",File_,Upper(SuggestedName),Trim(Exists),AskOverwrite);
        if (!Ok)
          Ok = (DialogBox(tmp, yes_no_buttons) == yes_no_chars[0]);
      }
    }  while (!(Ok));
    return SuggestedName;
  }
  return "";
}
