/* filename: EDREFORM.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
  
#include <dialog.h>
#include <utils.h>
#include <edit.h>
  
static int len(int WhichLine)
{
  if (Linebuffer[WhichLine-1])
    return strlen(Linebuffer[WhichLine-1]);
  else
    return 0;
}
  
int EmptyLine(int WhichLine)
{
  int variable;
  
  if (((unsigned)WhichLine > MaxLines) || (Linebuffer[WhichLine-1] == NULL))
    variable = TRUE;
  else {
    if( !(Trim(Linebuffer[WhichLine-1]))[0])
      variable = TRUE;
    else
      variable = FALSE;
  }
  if (BlockMarked && (WhichLine > BlockEndLine))
    return TRUE;
  return variable;
}
  
static void TrimCurrentLine(void)
{
  char s[STRSIZ];
  unsigned char OriginalLength;
  int i;
  
  strcpy(s,Linebuffer[CurrentLine-1]);
  OriginalLength = strlen(s);
  strcpy(s,Trim(s));
  if (strlen(s) < OriginalLength) {
    if (!BlockMarked || (BlockMarked && (CurrentLine < BlockStartLine) && (CurrentLine > BlockEndLine)))
    {
      ForgetEdiDynString(CurrentLine);
      MakeEdiDynString(s,CurrentLine);
    }
    else {
      FuncEnd();
      for (i = 1; i <= (int)(OriginalLength - strlen(s)); i++)
        EdBackSpace();
    }
  }
}
  
void EdReformat(unsigned char Rmargin)
{
  int cc;
  int SaveInsert;
  char buf[STRSIZ];
  
  if (editnoedit || (!Wrap))
    return;
  if (EmptyLine(CurrentLine)) {
    CursorDown();
    Home();
    return;
  }
  if (AutoSave) {
    if (!BwriteOK(SaveWithNoPrompt)) {
      sprintf(buf,"%s %s",Error_writing,current_file);
      EditDialogBox(buf);
    }
    strokes = 0;
  }
  EditNoDisplay = TRUE;
  while ((len(CurrentLine) >= (int)Rmargin) && (Pos(" ",Linebuffer[CurrentLine-1]) == -1))
  {
    if (CurrentLine > Highestline) {
      CurrentLine = Highestline;
      goto exitpoint;
    }
    CursorDown();
    FuncEnd();
  }
  Wrap = FALSE;
  SaveInsert = EditInsertmode;
  EditInsertmode = TRUE;
  Home();
  while (!EmptyLine(CurrentLine)) {
    TrimCurrentLine();
    while ((len(CurrentLine) < (int)Rmargin)
      && (CurrentLine + 1 < Highestline)
      && (!(EmptyLine(CurrentLine + 1))))
    {
      if (!(len(CurrentLine + 1))
        || (len(CurrentLine) + len(CurrentLine + 1) > STRSIZ-1))
      {
        CursorDown();
        goto nextline;
      }
      FuncEnd();
      CursorRight(FALSE);
      Del();
      while ((len(CurrentLine) > 0)
        && (Linebuffer[CurrentLine-1][EditColumn-1] == ' '))
      {
        Del();
        if (!len(CurrentLine)) {
          CursorDown();
          goto nextline;
        }
      }
      TrimCurrentLine();
    }
    if (len(CurrentLine) > (int)Rmargin) {
      cc = len(CurrentLine);
      if ((Pos(" ",Linebuffer[CurrentLine-1]) == -1)
        || ((Pos(" ",Linebuffer[CurrentLine-1])+1) > (int)Rmargin))
        goto exitpoint;
      while (cc >= (int)Rmargin) {
        while ((cc > 1) && (Linebuffer[CurrentLine-1][cc-1] != ' '))
          --cc;
        while ((cc > 1) && (Linebuffer[CurrentLine-1][cc-1] == ' '))
          --cc;
      }
      ++cc;
      while ((cc < len(CurrentLine)) && (Linebuffer[CurrentLine-1][cc-1] == ' '))
        ++cc;
      --cc;
      Home();
      if ((cc <= 1)) {
        EditDialogBox(LineToolong);
        goto exitpoint;
      }
      do {
        CursorRight(FALSE);
      }  while (!(EditColumn >= cc));
      Enter();
      Del();
      CursorUp();
      FuncEnd();
    }
    nextline: if (EventPending())
      goto exitpoint;
    if ((Linebuffer[CurrentLine] != NULL)
    && (CurrentLine < Highestline)) {
      CursorDown();
      FuncEnd();
      while ((len(CurrentLine) >= (int)Rmargin) && (Pos(" ",Linebuffer[CurrentLine-1]) == -1))
      {
        if ((CurrentLine == Highestline))
          goto exitpoint;
        CursorDown();
        FuncEnd();
      }
    }
    else
      goto exitpoint;
  }
  exitpoint: EditInsertmode = SaveInsert;
  EditNoDisplay = FALSE;
  DrawScreen();
  Wrap = TRUE;
}
