/* filename: EDITTEXT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <conio.h>
#include <direct.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <dialog.h>
#include <pick.h>
#include <utils.h>
#include <edit.h>

int EditorShade=0, Expl=0, Ruler=0, EditScreenSaved=0;
int EditChanged=0, editnoedit=0, noresize=0, norestore=0;
int nostatus=0, AutoSave=0, ExitEdit=0, SaveOrder=0;
int fullscreen=0, NoHelp=0, nocreate=0, NoMouse=0;
int BakUp=0, strokes=0;
unsigned char WordWrapWidth = 79;
Scrtype *BufPtr, *Screen;
MoveModeType ResizeMode = {0};

void QuickEditor(char *DateiName);
void SetDefaultBox(void);

static char *DateiName = NULL;

void VideoInit(void)
{
  if (VideoMode() == 7)
    Screen = (Scrtype *)MK_FP(0xB000,0);
  else
    Screen = (Scrtype *)MK_FP(0xB800,0);
}

void ClearBuffer(void)
{
  int i;

  for (i = MaxLines; i >= 1; i--)
    ForgetEdiDynString(i);
}

static int Parse(char *Clause)
{
  int pos;

  pos = Pos(Clause,DateiName);
  if (pos >= 0) {
    Delete(DateiName, pos, strlen(Clause));
    return 1;
  }
  else
    return 0;
}

static int TryGetMem(void **buf, int size)
{
  if ((*buf = malloc(size)) == NULL) {
    SetError(217, 1, " [EditText]");
    return 0;
  }
  return 1;
}

void EditText(const char *TextFilename)
{
  DialogRecord *SaveDialogSpecs = NULL;
  PickWindowType *SavePickSpecs = NULL;
  unsigned char SaveX, SaveY;
#ifdef _MSC_VER
  char startdir[_MAX_DIR];
  int dirlength = _MAX_DIR;
  short top, left, bottom, right;
#else
  char startdir[MAXPATH];
  int dirlength = MAXPATH;
  struct text_info ti;
#endif
  int NoBackUp;
  int Plain;
  int iWrap, i;
  int ScreenSize=0;
  unsigned SaveMaxLines;
  long TempMaxLines;
  unsigned char a,b,c,d;

  if (!CheckRegisteredUnits("EditText",
      REGTZCOMMON+REGTZEDIT+REGTZPICK+REGTZDIALOG+REGTZSAYGET+REGTZVIDPOP))
    return;

  CurrentColors(&a,&b,&c,&d);

  ExitEdit = FALSE;
  SaveMaxLines = MaxLines;
  SaveOrder = dBASEOrder;
  dBASEOrder = FALSE;
  getcwd(startdir, dirlength);
  if (!TryGetMem((void**)&DateiName, sizeof(PathStr)))
    goto bailout;
  if (!TryGetMem((void**)&SaveDialogSpecs, sizeof(DialogRecord)))
    goto bailout;
  if (!TryGetMem((void**)&SavePickSpecs, sizeof(PickWindowType)))
    goto bailout;
  strcpy(DateiName, TextFilename);
  memcpy(SaveDialogSpecs,DialogSpecPtr,sizeof(DialogRecord));
  memcpy(SavePickSpecs,PickSpecPtr,sizeof(PickWindowType));
  SetDialogWindowTo(STRSIZ-1,MaxAvailRows()/2,DoubleLine+Shadow+Raised,"");
  SetPickWindowTo(5,5,19,20,SingleLine + Shadow,"");

  EditorResult = 1;
  VideoInit();
  ActiveColors = MemoIn ? MemoColors : EditColors;
  SetDialogColorTo(ActiveColors.DialogFrameFG,ActiveColors.DialogFrameBG,ActiveColors.DialogTextFG,ActiveColors.DialogTextBG);
  SetPickColorTo(ActiveColors.PickTextFG,ActiveColors.PickTextBG,ActiveColors.PickBarFG,ActiveColors.PickBarBG);
  ResizeMode = NoMoveMode;
  sprintf(DateiName," %s",Upper(Trim(Ltrim(DateiName))));
  fullscreen = Parse(" FULLSCREEN");
  NoBackUp = Parse(" NOBACKUP");
  AutoSave = Parse(" AUTOSAVE");
  editnoedit = Parse(" NOEDIT");
  nostatus = Parse(" NOSTATUS");
  noresize = Parse(" NORESIZE");
  norestore = Parse(" NORESTORE");
  nocreate = Parse(" NOCREATE");
  Ruler = Parse(" RULER");
  Show = Parse(" SHOW");
  Plain = Parse(" PLAIN");
  NoHelp = Parse(" NOHELP");
  BakUp = !NoBackUp;
  Ruler = (Ruler && !fullscreen);

  if (Show)
    SetCursorOff();
  if (fullscreen) {
    SetDefaultBox();
    if (MemoIn)
      MemoBox = ActiveBox;
    else
      EditBox = ActiveBox;
  }
  if (MemoIn) {
    ActiveBox = MemoBox;
    ActiveColors = MemoColors;
  }
  else {
    ActiveBox = EditBox;
    ActiveColors = EditColors;
  }
  NoMouse = fullscreen; // no linestyle means no mouse support
  ComputeWindowCoordinates();
  iWrap = Pos(" WRAP=",DateiName);
  if (iWrap >= 0) {
    Wrap = TRUE;
    WordWrapWidth = WindowWidth;
    i = minwid = iWrap + 6;
    while (DateiName[minwid] >= '0' && DateiName[minwid] <= '9')
      ++minwid;
    if ((int)minwid > i)
      WordWrapWidth = atoi(Copy(DateiName,i, minwid - i));
    Delete(DateiName, iWrap, minwid - iWrap);
  }
  if (Plain) {
    editnoedit = TRUE;
    nocreate = TRUE;
  }
  minwid = editnoedit ? 4 : 12;
  strokes = 0;
  if (!*DateiName)
    strcpy(editfilename, Defaultname);
  EditorShade = (ActiveBox.LineStyle & Shadow) ? TRUE : FALSE;
  Expl = (ActiveBox.LineStyle & Explode) ? TRUE : FALSE;
  ScreenSize = 160 * MaxAvailRows();
  if (coreleft() >(unsigned long) (ScreenSize + ReservedMemory)) {
    if (!TryGetMem((void**)&BufPtr, ScreenSize))
      goto bailout;
    else {
      memcpy(BufPtr,Screen,ScreenSize);
      EditScreenSaved = TRUE;
    }
  }
  else
    EditScreenSaved = FALSE;
  if (!Txtin) {
    if (coreleft() < (unsigned long)((MaxLines<<2) + 10000))
      (unsigned long)TempMaxLines = (coreleft() - 10000) >> 2;
    else
      TempMaxLines = MaxLines;
    if (((TempMaxLines < 25) && (SaveMaxLines > 24)) || (TempMaxLines < 1)) {
      EditDialogBox(Nomemory);
      goto bailout;
    }
    MaxLines = (unsigned)TempMaxLines;
    if (!TryGetMem((void**)&Linebuffer, MaxLines<<2))
      goto bailout;
    memset(Linebuffer, 0, MaxLines<<2);
    ClearBuffer();
    Txtin = TRUE;
  }
  EditChanged = FALSE;
#ifdef _MSC_VER
  _gettextwindow(&top,&left,&bottom,&right);
#else
  gettextinfo(&ti);
#endif
  SaveY = wherey();
  SaveX = wherex();

  QuickEditor(DateiName);

#ifdef _MSC_VER
  _settextwindow(top,left,bottom,right);
#else
  window(ti.winleft,ti.wintop,ti.winright,ti.winbottom);
#endif
  gotoxy(SaveX,SaveY);

bailout:
  SetColorTo(a,b,c,d);
  if (!MemoIn) {
    ClearBuffer();
    FreePtrClear((void*)&Linebuffer);
    Txtin = FALSE;
  }
  FreePtrClear((void*)&DateiName);
  DisableMouse();
  MaxLines = SaveMaxLines;
  if (EditScreenSaved) {
    if (!norestore)
      memcpy(Screen,BufPtr,ScreenSize); // will generate snow on CGA systems
    FreePtrClear((void*)&BufPtr);
  }
  dBASEOrder = SaveOrder;
  chdir(startdir);
  if (SaveDialogSpecs) {
    memcpy(DialogSpecPtr, SaveDialogSpecs,sizeof(DialogRecord));
    FreePtrClear((void*)&SaveDialogSpecs);
  }
  if (SavePickSpecs) {
    memcpy(PickSpecPtr, SavePickSpecs,sizeof(PickWindowType));
    FreePtrClear((void*)&SavePickSpecs);
  }
}
