/* filename: BLOCKS.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
  
#include <dialog.h>
#include <utils.h>
#include <edit.h>
  
void InsertLine(void);
  
extern char *MemoLineTails;
  
void GetBlockEdgeStrings(void)
{
  BlockMarked = FALSE;
  if ((BlockStartLine == BlockEndLine) &&
    (BlockStartColumn==BlockEndColumn))
    ClearBlockMarkers();
  if (!BlockStartLine || !BlockEndLine ||
    (BlockEndLine < BlockStartLine) ||
    ((BlockStartLine == BlockEndLine) &&
    (BlockEndColumn <= BlockStartColumn)))
    return;
  BlockMarked = TRUE;
  if (BlockEndColumn == STRSIZ-1)
    *BlockTail=0;
  else
    strcpy(BlockTail,Copy(Linebuffer[BlockEndLine-1],0,BlockEndLine-1));
  if (BlockStartLine == BlockEndLine)
    strcpy(BlockHead,Copy(Linebuffer[BlockStartLine-1],BlockStartColumn-1,BlockEndColumn - BlockStartColumn));
  else
    strcpy(BlockHead,Copy(Linebuffer[BlockStartLine-1],BlockStartColumn-1,STRSIZ-1));
}
  
void ClearBlockMarkers(void)
{
  BlockEndLine = 0;
  BlockStartLine = 0;
  BlockMarked = FALSE;
  BlockStartColumn = 0;
  BlockEndColumn = 0;
  BlockHead[0] = 0;
  BlockTail[0] = 0;
  BlockStream = TRUE;
}
  
void MarkBlockBegin(void)
{
  BlockStartLine = CurrentLine;
  BlockStartColumn = EditColumn;
  if (BlockEndLine >= BlockStartLine) {
    GetBlockEdgeStrings();
    DisplayEditorStatus();
    DrawScreen();
  }
}
  
void MarkBlockEnd(void)
{
  BlockEndLine = CurrentLine;
  BlockEndColumn = EditColumn;
  
  if ((BlockEndColumn == 1) && (CurrentLine > 1)) {
    BlockEndColumn = STRSIZ-1;
    --BlockEndLine;
    strcpy(BlockTail,Linebuffer[BlockEndLine-1]);
    BlockStream = FALSE;
  }
  else
    BlockStream = TRUE;
  GetBlockEdgeStrings();
  DisplayEditorStatus();
  DrawScreen();
}
  
void DeleteBlock(unsigned char key)
{
  char fhalf[STRSIZ];
  char buf[STRSIZ], buf1[STRSIZ];
  unsigned int X;
  int dave;
  int i;
  
  SetChangedFlags();
  if (BlockEndColumn >= strlen(Linebuffer[BlockEndLine-1])
    && (BlockStartLine < BlockEndLine) && (BlockStartColumn == 1))
    dave = TRUE;
  else
    dave = FALSE;
  if ((BlockStartLine == BlockEndLine)) {
    strcpy(fhalf,Linebuffer[BlockStartLine-1]);
    CurrentLine = BlockStartLine;
    if ((unsigned)(BlockEndColumn - BlockStartColumn + 1) == strlen(fhalf)) {
      dave = TRUE;
      goto delli;
    }
    else {
      Delete(fhalf,BlockStartColumn-1,BlockEndColumn-BlockStartColumn);
      MakeEdiDynString(fhalf,BlockStartLine);
      goto ex;
    }
  }
  strcpy(buf,Copy(Linebuffer[BlockStartLine-1],0,BlockStartColumn-1));
  strcpy(buf1,Copy(Linebuffer[BlockEndLine-1],BlockEndColumn - 1,STRSIZ-1));
  sprintf(fhalf,"%s%s",buf,buf1);
  if (strlen(fhalf) > STRSIZ-2) {
    EditDialogBox(LineToolong);
    DisplayEditorStatus();
    return;
  }
  BlockDiff = BlockEndLine - BlockStartLine + 1;
  for (X = (unsigned)BlockStartLine; X <= (unsigned)BlockEndLine; X++)
    if ((Linebuffer[X-1] != NULL))
      ForgetEdiDynString(X);
  for (X = (unsigned)BlockEndLine; X < (unsigned)Highestline; X++)
    Linebuffer[X - BlockDiff] = Linebuffer[X];
  if(MemoIn)
    memmove(&MemoLineTails[BlockEndLine-BlockDiff],
    &MemoLineTails[BlockEndLine-1],sizeof(char)*(Highestline-BlockEndLine+1));
  Highestline = Highestline - BlockDiff;
  for (i = Highestline; i < (int)(MaxLines); i++)
    Linebuffer[i] = NULL;
  if(MemoIn)
    memset(&MemoLineTails[Highestline],0,MaxLines-Highestline);
  if (Highestline < 1) {
    MakeEdiDynString("",1);
    Highestline = 1;
  }
  CurrentLine = BlockStartLine;
  InsertLine();
  ForgetEdiDynString(CurrentLine);
  MakeEdiDynString(fhalf,CurrentLine);
  
delli:
  if ((CurrentLine - ScreenLine < 1))
    ScreenLine = BlockStartLine;
  if (dave) {
    DeleteLine();
    ++BlockDiff;
  }
ex:
  if (key == 1) {
    if ((CurrentLine - ScreenLine < 1))
      ScreenLine = BlockStartLine;
    Home();
    for (i = 1; i <= (int)(BlockStartColumn - 1); i++)
      CursorRight(FALSE);
    ClearBlockMarkers();
    DisplayEditorStatus();
    DrawScreen();
  }
}
