/* filename: DIALGBOX.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <sayget.h>
#include <utils.h>
#include <dialog.h>
#include <vidpop.h>
#ifdef _MSC_VER
#include <graph.h>
#endif

#define MAX_AVAIL_COLS  80

extern int ReadKeySecPass; // a flag

int StayOnUntilRemoved   = FALSE;
int FancyButtons = 0;
char DialogNewLine = ';';
unsigned char  DialogCol = 0; // Column and row where a dialog box actually appears
unsigned char  DialogRow = 0; // meaningless except when dialog is active

typedef enum {  ARightArrow,ALeftArrow,ASpace,Enter,ESC,
Trigger,Tabulation,ShiftTab,Nothing } Keys;

static char * msgptr;

static int   Row, Col, num, MaxLen, Centered, DialogTimeOut;
static char  c;
static char  _tzfar Buttons[MAX_AVAIL_COLS+1] = "";
static char  _tzfar TriggerString[17] = "";
static int   ButtonNo, TimeOutFlag;
static int   MaxLenFormatCharsCounter, FormatCharsCounter;
static long  TimeOutTicks;

static struct ButtonList {
  int     Col, Width;
  char    Trigger;
} _tzfar ButtonList[16] = {{ 0, 0, 0 }};

static char * OneButton(char * Temp)
{
  char   tmp[6], *ps;
  static char _tzfar onebutton[MAX_AVAIL_COLS + 1] = "";
  struct ButtonList  *pbl;

  if (!*Temp)
    return "";
  ps = strchr(Temp, ' ');
  if (ps)
    *ps = 0;
  sprintf(onebutton, FancyButtons ? "  %s  " : "  %s ", Temp);
  pbl = &ButtonList[ButtonNo];
  pbl->Col = Col;
  pbl->Width = strlen(onebutton);
  pbl->Trigger = UpCase(Temp[0]);
  *tmp = pbl->Trigger;
  tmp[1] = 0;
  if (*TriggerString)
    strcat (TriggerString, tmp);
  else
    strcpy (TriggerString, tmp);
  // add button to mouse target list
  Col += pbl->Width;
  if (ps)
    strcpy(Temp, ++ps);
  else
    *Temp = 0;
  ++ButtonNo;

  return onebutton;
}

static char * FormatButtons(int maxlen)
{
  char Temp[STRSIZ], NextButton[STRSIZ];
  int i;

  // rebuild the buttons string with the appropriate spaces
  strcpy(Temp, Ltrim(Trim(Buttons)) );
  while ((i = PosOf(1,"  ",Temp)) >= 0)
    Delete(Temp, i, 1);
  memset(&ButtonList,0,sizeof(ButtonList));
  *Buttons = *TriggerString = 0;
  ButtonNo = 0;
  Col = 1;
  do {
    strcpy(Temp, Ltrim(Temp));
    strcpy(NextButton, OneButton(Temp));
    strcat(Buttons, NextButton);
  } while (*NextButton);
  Buttons[maxlen] = 0;
  return Buttons;
}

static void PaintUnpaintHalfShadow(int col, int row, int i , int flag)
{
  char  b[STRSIZ];
  int   j, k, w;

  k = ButtonList[i].Col;
  w = ButtonList[i].Width;
  strcpy(b, &Buttons[k] );
  PushColors();
  SetColorTo( (unsigned char) (flag ? _Dialogue.ButtonSFG : _Dialogue.ButtonFG),
    (unsigned char) (flag ? _Dialogue.ButtonSBG : _Dialogue.ButtonBG), 0, 0);
  b[w - (FancyButtons ? 2 : 1)] = 0;
  At(col+k-1, row, b);
  if (FancyButtons) {
    SetColorTo(BLACK, _Dialogue.MessageBG, 0, 0);
    for (j = (flag ? 0 : 1); j < w-2 + (flag ? 0 : 1); j++)
      At(k+col+j - (flag ? 0 : 1), row+1, (flag ? "\xDF" : " "));
    At(k+col+w-3, row, (flag ? "\xDC" : " "));
  }
  PopColors();
}

static void PaintButtons(int col, int row)
{
  int i, cc, ccc;
  char b[STRSIZ];

  PushColors();
  SetColorTo(_Dialogue.ButtonFG, _Dialogue.ButtonBG, 0, 0);
  for (i = 0; i < ButtonNo; i++) {
    cc = ButtonList[i].Col;
    ccc = col + cc - 1;
    strcpy(b, &Buttons[cc]);
    b[ButtonList[i].Width - (FancyButtons ? 2 : 1)] = 0;
    At(ccc, row, b);
    AddTarget(ccc, row, ccc+ButtonList[i].Width-3, row,i+1,LeftButtonReleased | LeftButtonDown);
  }
  PopColors();
}

static Keys GetKey(char * c, int *OldI, int col, int row, int i )
{
  EventRec     e;
  ActivityType save;
  int flag;

  save = Activity;
  Activity = _Dialog;
  while( !(flag = EventPending()) && ((*BiosTimerTicks < TimeOutTicks) || !TimeOutFlag) );
  if (!flag)
    return ESC;
  else
    if (TimeOutFlag)
      TimeOutTicks = *BiosTimerTicks + 18 * DialogTimeOut;
  GetEvent(&e); // new way..sees keypresses and mouse clicks
  Activity = save;
    switch (e.WhichEvent) {
        case Mouse:
        if (e.v.sMouse.ButtonMask == LeftButtonReleased) {
          *c = UpCase(TriggerString[e.v.sMouse.TargetID-1]);
          return Trigger;
        }
        else {
          if (e.v.sMouse.TargetID == ReservedID)
            return ESC;
          else {
            PaintUnpaintHalfShadow(col, row, *OldI, FALSE);
            i = e.v.sMouse.TargetID-1;
            PaintUnpaintHalfShadow(col, row, i, TRUE);
            *OldI = i;
          }
        }
        break;
      case Keyboard:
      switch (e.v.sKeyboard.Key) {
        case ' ':    return ASpace;
        case '\r':   return Enter;
        case '\x1B': return ESC;
        case '\t':   return Tabulation;
        case '\x0':
        switch(e.v.sKeyboard.ScanCode) {
          case 'M':   return ARightArrow;
          case 'K':   return ALeftArrow;
          case '\xF': return ShiftTab;
          default:    return Nothing;
        }
        default:
          if (strchr(TriggerString,UpCase(e.v.sKeyboard.Key))) {
            *c = UpCase(e.v.sKeyboard.Key);
            return Trigger;
          }
      }
        break;
    }
  return Nothing;
}

static char GetButton(int col, int row)
{
  int  i, OldI;
  Keys Key;
  int  savecur;
  char c;

  i = 0;
  savecur = CursorVisible();
  SetCursorOff();
  EnableMouse();
  while (1) {
    PaintUnpaintHalfShadow(col,row, i, TRUE);
    OldI = i;
    do {
      Key = GetKey(&c, &OldI, col, row, i);
    } while(Key == Nothing);

    switch (Key) {
      case ARightArrow:
      case Tabulation:
      case ASpace:    ++i; break;

      case ALeftArrow:
      case ShiftTab:  --i; break;

      case Enter:
      case Trigger:
      case ESC:
        DisableMouse();
        if (savecur)
          SetCursorOn();
        switch (Key) {
          case Enter:   return ButtonList[i].Trigger;
          case Trigger: return c;
          case ESC:     return '\x1B';
        }
        break;
    }
    if (i < 0)
      i = ButtonNo-1;
    if (i >= ButtonNo)
      i = 0;
    PaintUnpaintHalfShadow(col,row, OldI, FALSE);
  }
}

static char * Line(unsigned char which)
{
  static char  _tzfar ttmp[2 * MAX_AVAIL_COLS] = "";
  char        *beginptr;
  int          pos, changed = 0;
  char nl[2] = { 0,0 };

  *nl = DialogNewLine;
  pos = PosOf(which, nl, msgptr);
  beginptr = &msgptr[pos+1];
  if ((pos = PosOf(which + 1, nl, msgptr)) >= 0) {
    msgptr[pos] = 0;
    changed = 1;
  }
  strcpy(ttmp, beginptr);
  if (changed)
    msgptr[pos] = *nl;
  return ttmp;
}

static int FilteredLength(char * s)
{
  int  i, counter = 0;
  int  linelen = (int)strlen(s);

  for (i = 0; i < linelen; i++)
    if ((s[i]<1) || (s[i]>6))
      ++counter;
  FormatCharsCounter = linelen - counter;
  return counter;
}

static int TabLength(int i)
{
  if (Centered || (num == 1))
    return ((MaxLen - FilteredLength(Line((unsigned char)i))) / 2);
  else
    return 0;
}

static void AtSpecialAttributes(int col, int row, char * s)
{
  int i, j, len, counter;
  static int pushes;
  unsigned char sf, sb, gf, gb, c1, c2;
  char tmpstr[2];

  *(int*) tmpstr = 0x0020; // " "
  len = (int) strlen(s);
  if (Centered) {   // adjust centering
    counter = 0;
    for (i = 0; i < len; i++)
      if((s[i]>0) && (s[i]<7))
        ++counter;
    if (counter > 0) {
      counter = MaxLenFormatCharsCounter - counter;
      if (!(counter%2) && counter)
        --counter;
    }
    col += counter/2;
  }
  for (i = 0; i < len; i++) {
    CurrentColors(&sf,&sb,&gf,&gb);
    switch (s[i]) {
      case 6: // EndFrame
        for (j = 0; j < pushes; j++)
          PopColors();
        pushes = 0;
        break;
      case 1: // Bright
      case 2: // Dim
      case 3: // Highlight
      case 4: // Flash
      case 5: // Reverse
        ++pushes;
        PushColors();
        switch (s[i]) {
          case 1: // Bright
            c1 = (unsigned char)(sf | 8);
            c2 = sb;
            break;
          case 2: // Dim
            c1 = (unsigned char)(sf & 7);
            c2 = sb;
            break;
          case 3: // Highlight
            c1 = (unsigned char)(SelectedColor & 0x0F);
            c2 = (unsigned char)((SelectedColor & 0xF0) >> 4);
            break;
          case 4: // Flash
            c1 = (unsigned char)(sf | BLINK);
            c2 = sb;
            break;
          case 5: // Reverse
            c1 = sb;
            c2 = sf;
            break;
        }
        SetColorTo(c1, c2, gf, gb);
        break;
      default:
        tmpstr[0] = s[i];
        At(col, row, tmpstr);
        ++col;
    }
  }
}

static unsigned char NRows(void)
{ // add 3 rows: 1 for the buttons, separated on each side by a row
  return num + (*Buttons ? 3 : 0);
}

static char *wrap_string(char *ptr, int max_len, char *save)
{
  char *last_space = ptr;
  int i;

  for(i = 0; i < max_len && *ptr; ++i,ptr++)
    if (isspace(*ptr))
      last_space = ptr;
  if (!isspace(*last_space))
    last_space = ptr;
  *save = *last_space;
  *last_space = 0;
  return last_space;
}

static char *tab2space(char *in)
{ // get rid of TABs by changing them with SPACEs
  // replace "\n\r" or "\n" with DialogNewLine symbol
  char *beg, *end;

  for(beg = end = in; *end; end++, beg++) {
    if (*end == '\t')
      *beg = ' ';
    else
      if (*end == '\n')
        *beg = DialogNewLine;
      else
        if (*end == '\r')
          beg--;
        else
          *beg = *end;
  }
  *beg = 0;
  return in;
}

char DialogBox(char * msg, char * PermissableReturnChars)
{
  int     saveOrder, r2;
  int     oldrow, oldcol, i, j, pos1, pos2;
  ActivityType saveActivity;
  int     saveX, saveY;
  long    ScrollTicks;
  char    tmpchar[2] = {0,0};
  int     mlen;
  char    Pak[MAX_AVAIL_COLS+1];
  char    S[101];
  int     KPressed, max_rows, max_cols;
  char    *cptr1, *cptr2, *cptr3, *cptr4;
  char    nl[2] = {0,0};
  unsigned int  msglen;
#ifdef _MSC_VER
  short wc1,wr1,wr2,wc2;
#else
  struct  text_info ti; // Save the user's window & cursor coordinates
#endif

  if (!CheckRegisteredUnits("DialogBox",REGTZCOMMON+REGTZVIDPOP+REGTZSAYGET+REGTZDIALOG))
    return 0;

  oldcol = DialogCol = _Dialogue.c1;
  oldrow = DialogRow = _Dialogue.r1;
  max_rows = MaxAvailRows();
  max_cols = MAX_AVAIL_COLS;
  *nl = DialogNewLine;
  if (!StayOnUntilRemoved) {
    DontTouchCursor = TRUE;
    RemoveDialogBox();
    DontTouchCursor = FALSE;
  }
  // normally when looking for clauses we uppercase Message. For
  // Country=Germany, however, UPPER will expand the length of the string
  // by 1 for each '\xE1' char found (since it converts "\xE1" to "SS"). So,
  // a safer way is to Lower case the message and test on that..gbr 6/12/92
  msglen = strlen(msg) + max_rows + 1;
  if ((cptr1 = malloc(msglen)) == NULL)
    goto NOMEM;
  strcpy(cptr1, msg);
  LowerString(cptr1);
  pos1 = PosOf(1, " centertext", cptr1);
  Centered = (pos1 >= 0) ? TRUE : FALSE;
  pos2 = PosOf(1, " timeout=", cptr1);
  if (pos2 >= 0) {
    TimeOutFlag = TRUE;
    DialogTimeOut = atoi(&cptr1[pos2+9]);
    for(i=9, j = pos2+9; isdigit(cptr1[j]); j++) ++i;
  }
  else
    TimeOutFlag = FALSE;
  if ((cptr2 = malloc(msglen)) == NULL) {
    free(cptr1);
    goto NOMEM;
  }
  strcpy(cptr2, msg);
  if (pos1 >= 0) {
    if (pos2 > pos1) {
      Delete(cptr2, pos2, i); // ?? is the length of " timeout=..."
      Delete(cptr2, pos1, 11); // 11 is the length of " centertext"
    }
    else {
      Delete(cptr2, pos1, 11);
      if (pos2 >= 0)
        Delete(cptr2, pos2, i);
    }
  }
  else
    if (pos2 >= 0)
      Delete(cptr2, pos2, i);
  if (!*cptr2) {
    free(cptr1);
    free(cptr2);
    return 0;
  }
  *cptr1 = DialogNewLine;
  *(cptr1 + 1) = 0;
  *Buttons = 0;
  if (*PermissableReturnChars != *StayOn &&
    *PermissableReturnChars != *StayOnNoCursor)// if StayOn do not paint buttons MA
    if ((i=PosOf(1,"buttons=",Lower(PermissableReturnChars))) >= 0) {
      *(int*) Buttons = 0x0020; // " "
      memcpy(&Buttons[1], &PermissableReturnChars[i+8], MAX_AVAIL_COLS);
      Buttons[MAX_AVAIL_COLS] = 0;
      FormatButtons(max_cols-4);   // format with appropriate spacing
    }
  j = max_rows - 3 - (*Buttons ? 3 : 0);
  tab2space(cptr2); // TAB->SPACE; '\n'or "\n\r"->';'
  for(i = 0, num = 1, cptr4 = cptr3 = cptr2; *cptr3; cptr3++, i++) {
    if (*cptr3 == DialogNewLine || i>max_cols - 4) {
      if (i > max_cols - 4) {// wrap strings if too long
        cptr3 = wrap_string(cptr4, max_cols - 4, &tmpchar[0]);
        strcat(cptr1, cptr4);
        strcat(cptr1, nl);
      }
      else {
        *cptr3 = 0;
        *tmpchar = DialogNewLine;
        strcat(cptr1, cptr4);
      }
      *cptr3 = *tmpchar;
      cptr4 = cptr3;
      if (num > j) {
        *cptr3 = 0;
        break;
      }
      num++;  // line number counter
      i = 0;
    }
  }
  strcat(cptr1, cptr4);
  strcat(cptr1, nl);
  free(cptr2);
  msgptr = cptr1;
  // cptr2, cptr3, cptr4 are not used any more
  // cptr1  points to a modified message string
  saveOrder = dBASEOrder;
  dBASEOrder = FALSE;
  // parse out multiple lines
  MaxLen = 0;
  MaxLenFormatCharsCounter = 0;
  MaxLen = strlen(Buttons);
  msglen = strlen(_Dialogue.Header);
  if (msglen > 2) {
    msglen -= 2;
    if (MaxLen < (int)msglen)
      MaxLen = (int)msglen;
  }
  for (i = 1; i <= num; i++)
    if ((mlen = FilteredLength(Line((unsigned char)i))) > MaxLen) {
      MaxLen = mlen;
      MaxLenFormatCharsCounter = FormatCharsCounter;
    }
  mlen = (int)strlen(press_any_key);
  if ((strcmp(PermissableReturnChars,PressAnyKey) >= 0) && (strcmp(PermissableReturnChars,BlinkPressAnyKey) <= 0)) // ?????????????????????????
    if (mlen > MaxLen) {
      MaxLen = mlen;
      MaxLenFormatCharsCounter = 0;
    }
  if (DialogCol >= 255)// 255 is a special signal to center the box horizontally
    DialogCol = (max_cols - 4 - MaxLen)/2 + 1;// this mystical formula was figured out one night by max et al
  else
    for (;DialogCol + MaxLen + 3 > max_cols; DialogCol--) ;
  Col = DialogCol + 2;
  if (DialogRow >= 255) // 255 is a special signal to center the box vertically
    DialogRow = (max_rows - (NRows() + 2)) / 2 + 1;//  was nrows-4 rsm
  r2 = DialogRow + NRows() + 1;
  // would the box run over the bottom of the screen?
  if (r2 > (int)max_rows) {
    DialogRow += (max_rows - r2);
    r2 = max_rows; // we don't check if the box is so big it won't even fit on the screen
  }
  Row = DialogRow;
  _Dialogue.c1 = DialogCol;
  _Dialogue.r1 = DialogRow;
  if (saveOrder) {
    DialogRow--;
    DialogCol--;
  }
  PushColors();
  SetColorTo(_Dialogue.BoxFG,_Dialogue.BoxBG,BLACK,BLACK);
  if (*PermissableReturnChars != *StayOn && *PermissableReturnChars != *StayOnNoCursor)
    PushMouse();// if StayOn do not touch the mouse MA
  pos1 = Col+MaxLen+3;
  pos2 = r2 + 1;
  if (pos1 > max_cols)
    pos1 = max_cols;
  if (pos2 > max_rows)
    pos2 = max_rows;
  PushWindow((char)(Col-2), (char)(_Dialogue.r1), (char)pos1, (char)pos2);
  HideMouse();
  Box(Col-2, _Dialogue.r1, Col+MaxLen+1, r2, (char)_Dialogue.LineStyle,_Dialogue.Header);
  ShowMouse();
  // for dialog boxes that just wait for a key (not buttons), and the mouse
  // is there, we want to paint a "spot" for the mouse to click on
  if (MouseDriverPresent && (!Buttons[0])
    && !((PermissableReturnChars[0]==StayOn[0])||(PermissableReturnChars[0]==StayOnNoCursor[0])))
    AddTarget(1, 1, max_cols, max_rows,1,LeftButtonReleased | CenterButtonReleased | RightButtonReleased);
  saveX = wherex();
  saveY = wherey();
  SaveCursor(&CursorVariable);
  SetCursorOff();
  // Save window
#ifdef _MSC_VER
  _gettextwindow(&wr1, &wc1, &wr2, &wc2);
  _settextwindow(1, 1, max_rows, max_cols);
#else
  gettextinfo(&ti);
  window(1, 1, max_cols, max_rows);
#endif
  // paint the interior of the box with the text colors..gbr..1/5/92
  for (i = _Dialogue.r1 + 1; i < r2; i++)
    Paint(Col - 1,i,(char)(MaxLen + 2),_Dialogue.MessageFG,_Dialogue.MessageBG);
  SetColorTo(_Dialogue.MessageFG, _Dialogue.MessageBG, BLACK, BLACK);
  for (i = 1; i <= num; i++) {
    strcpy(S, Line((unsigned char)i));
    if (strstr(cptr1, EndFrame ) == NULL)
      At(Col+TabLength(i), Row + i, S);
    else
      AtSpecialAttributes(Col+TabLength(i), Row + i, S);
  }
  if (*Buttons) {
    i = (Centered || (num == 1)) ? (MaxLen - strlen(Buttons))/2 : 0;
    PaintButtons(Col + i, Row + num + 2);
    AddTarget(1, 1, max_cols, max_rows, ReservedID, RightButtonReleased);
  }
  if (*PermissableReturnChars == *StayOn || *PermissableReturnChars == *StayOnNoCursor) {
#ifdef _MSC_VER
    _settextwindow(wr1, wc1, wr2, wc2);
#else
    window(ti.winleft, ti.wintop, ti.winright, ti.winbottom);
#endif
    if (*PermissableReturnChars == *StayOn)
      RestoreCursor(CursorVariable);
    gotoxy(saveX,saveY);
    PopColors();
    dBASEOrder = saveOrder;
    ++WindowsOnStack;
    _Dialogue.r1 = oldrow;
    _Dialogue.c1 = oldcol;
    free(cptr1);
    //PopMouse(); // if StayOn do not touch the mouse MA
    return 0;
  }
  if (TimeOutFlag)
    TimeOutTicks = *BiosTimerTicks + 18 * DialogTimeOut;
  i = strlen(press_any_key);
  j = Col + ((MaxLen - i) >> 1);
  if ((strcmp(PermissableReturnChars,PressAnyKey) >= 0) && (strcmp(PermissableReturnChars,BlinkPressAnyKey) <= 0)) {
    At(j, r2, press_any_key);
    if (*PermissableReturnChars == *BlinkPressAnyKey)
      Paint(j, r2, (char) i, (unsigned char)(_Dialogue.BoxFG|BLINK),_Dialogue.BoxBG);
  }
  ScrollTicks = *BiosTimerTicks;
  strcpy(Pak, press_any_key);
  if (!Buttons[0]) {
    EnableMouse();
    do {
      do {
        if (PermissableReturnChars[0] == ScrollPressAnyKey[0]) {
          if(*BiosTimerTicks - ScrollTicks > 2) {  // about 100 ms
            At(j, r2, Pak);
            tmpchar[0] = Pak[0];
            strcpy(Pak, Pak+1);
            strcat(Pak, tmpchar);
            ScrollTicks = *BiosTimerTicks;
          }
        }
        saveActivity = Activity;
        Activity = _Dialog;
        // KP says a key was pressed, or the mouse was clicked on the spot
        KPressed = EventPending();
        Activity = saveActivity;
      }  while (!(KPressed || (TimeOutFlag && (*BiosTimerTicks > TimeOutTicks))));
      if(KPressed) {
        if ((Event.WhichEvent == Mouse) && (Event.v.sMouse.TargetID == 1)) {
          c = ' ';
          memset(&Event, 0, sizeof(Event) );
        }
        else
          c = ReadKey();
        if (c == '\0')
          c = ReadKey() + 128;
      }
      else
        c = '\0';
    } while ((strchr(Lower(PermissableReturnChars),Lowcase(c)) == NULL)
      && *PermissableReturnChars
      && (strcmp(PermissableReturnChars,PressAnyKey) > 0)
      && (strcmp(PermissableReturnChars,BlinkPressAnyKey) > 0)
      && (!(TimeOutFlag && (*BiosTimerTicks >= TimeOutTicks))));
    DisableMouse();
  }
  else {
		i = (Centered || (num == 1)) ? (MaxLen - strlen(Buttons))/2 : 0;
    c = GetButton(Col + i,Row + num + 2);
  }
#ifdef _MSC_VER
  _settextwindow( wr1, wc1, wr2, wc2 );
#else
  window(ti.winleft, ti.wintop, ti.winright, ti.winbottom );
#endif
  RestoreCursor(CursorVariable);
  gotoxy(saveX, saveY);
  PopColors();
  PopWindow();
  PopMouse();
  dBASEOrder = saveOrder;
  _Dialogue.r1 = oldrow;
  _Dialogue.c1 = oldcol;
  free(cptr1);
  return UpCase(c);

NOMEM:
  SetError(217, 1, " [DialogBox]");
  return 0;
}   //  DialogBox
