/* filename: SETEDWTO.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <common.h>
#include <dbfedit.h>
  
#define MaxRowsSupported 66
  
char DBFEditLineChar = ' ';
  
void SetEditWindowTo( unsigned char lc, unsigned char tr, unsigned char rc,
                      unsigned char br, unsigned char _LineStyle, char *_Header)
{
  unsigned char Temp;
  
  strcpy(DbfEditBox.Header,_Header);
  DbfEditBox.LineStyle = _LineStyle;
  // DBFEdit uses dBASE coordinates but the user has a choice of coordinate systems
  if (dBASEOrder) { // reverse the order of coordinates
    Temp = lc; lc = tr; tr = Temp; Temp = rc;  rc = br; br = Temp;
    if (br > MaxRowsSupported)
      br = MaxRowsSupported;
    if (rc > 79)
      rc = 79;
    DbfEditBox.c1 = lc;
    DbfEditBox.c2 = rc;
    DbfEditBox.r1 = tr;
    DbfEditBox.r2 = br;
    Temp = DbfEditBox.LineStyle;
    if (Temp & Shadow)
      Temp -= Shadow;
    if (Temp & Explode)
      Temp -= Explode;
    if (Temp >= 1 && Temp <= 5) { // edit area needs to fit into the box that will be drawn
      ++tr; --br; ++lc; --rc;
    }
    else
      if (!*Trim(DbfEditBox.Header))
        ++tr; // no line
  }
  else { // pascal coordinates
    if (tr < 1)
      tr = 1;
    if (lc < 1)
      lc = 1;
    if (rc > 80)
      rc = 80;
    DbfEditBox.c1 = --lc;
    DbfEditBox.c2 = --rc;
    DbfEditBox.r1 = --tr;
    DbfEditBox.r2 = --br; // DbfEditBox coordinates are dBASE style
    Temp = DbfEditBox.LineStyle;
    if (Temp & Shadow)
      Temp -= Shadow;
    if (Temp & Explode)
      Temp -= Explode;
    if (Temp >= 1 && Temp <= 5) { // edit area needs to fit into the box that will be drawn
      ++tr; --br; ++lc; --rc;
    }
    else
      if (!*Trim(DbfEditBox.Header))
        ++tr; // no line
  }
  switch (Temp) {
    case 0: DBFEditLineChar = ' ';    break;
    case 1:
    case 4: DBFEditLineChar = '\xC4'; break;
    case 2:
    case 5: DBFEditLineChar = '\xCD'; break;
    case 3: DBFEditLineChar = '\xDC'; break;
  }
}
