/* filename: INITEDIT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <dbf.h>
#include <sayget.h>
#include <dbfedit.h>

int DBFEditNoScroll = 0, DBFEditPlain = 0;
DbfEditBoxType _tzfar DbfEditBox = { 0, 0, 79, 24, NoLine, NoHeader };

void ResizeEditArea(void)
{
  char Len, MaxLen;
  int  Deficit, i;

  MaxLen = DbfEditBox.c2 - DbfEditBox.c1 - 13;
  if (LeftDelimiter)
    ++MaxLen;
  if (RightDelimiter)
    ++MaxLen;
  Deficit = 0;
  for (i = 1; i <= FieldCount(); i++) {
    Len = FieldLen(i);
    if ((Len > MaxLen) && (FieldType(i) != 'C'))
      if (Len - MaxLen > Deficit)
        Deficit = Len - MaxLen;
  }
  if (Deficit > 0) { // we need to make the box wider
    DbfEditBox.c2 = DbfEditBox.c2 + Deficit;
    if (DbfEditBox.c2 > 79) { // we are in dbase coordinates here
      // we also need to move the box over to the left
      DbfEditBox.c1 = DbfEditBox.c1 - (79 - DbfEditBox.c2);
      DbfEditBox.c2 = 79;
    }
  }
}

void InitializeEdit(char *command)
{
  char buf[STRSIZ];

  *buf = 0;
  ResizeEditArea(); // widens the editbox if the box would clip dates or numbers
  Box(DbfEditBox.r1,DbfEditBox.c1,DbfEditBox.r2,DbfEditBox.c2,DbfEditBox.LineStyle,DbfEditBox.Header);
  SetCursorOn(); // make sure the cursor is on
  // Parse the command
  if(*command) {
    strcpy(buf,Upper(command));
    sprintf(buf," %s ",Ltrim(Trim(buf)));
  }
  DBFEditPlain = (strstr(buf," PLAIN ") != NULL);
  DBFEditNoScroll = (strstr(buf, " NOSCROLL ") != NULL);
  DBFEditStayOn = (strstr(buf, " STAYON ") != NULL);
}
