/* filename: EDITREC.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <conio.h>
#include <stdio.h>
#include <string.h>
#ifdef _MSC_VER
 #include <graph.h>
#endif
#include <dbf.h>
#include <vidpop.h>
#include <sayget.h>
#include <dbfedit.h>

void InitializeEdit(char *command);
void LowLevelEditRecord(void);

int DBFEditStayOn = 0;

void GetStayOn(char *command)
{
  char buf[STRSIZ];

  *buf = 0;
  if(*command) {
    strcpy(buf,Upper(command));
    sprintf(buf," %s ",Ltrim(Trim(buf)));
  }
  DBFEditStayOn = (strstr(buf, " STAYON ") != NULL);
}

void EditRecord(char *command)
{
#ifdef _MSC_VER
  struct _rccoord tp;
  short left, top, right, bottom;
#else
  int  savex, savey;
  struct text_info ti;
#endif
  int OldDbaseOrder;
  unsigned savedcursor;

  if (!*DBF())
    return;
  // note that EditRecord can happen on an empty DBF, or one that is past
  // EOF. This is ok, since editing only happens on the Turbo record, not on
  // disk. This means the user can edit and THEN decide whether to APPEND a
  // new record. Very convenient. BTW, this is not the case for EDIT (see
  // below). EDIT requires that you are positioned to a valid record since it
  // does the REPLACEing for you
  GetStayOn(command);
  if (!DBFEditStayOn)
    PushWindow(1,1,80,MaxAvailRows());
  OldDbaseOrder = dBASEOrder;
  dBASEOrder = TRUE;
  //store existing window and cursor coordinates
  SaveCursor(&savedcursor);
#ifdef _MSC_VER
  tp = _gettextposition();
  _gettextwindow(&top, &left, &bottom, &right);
#else
  savex = wherex();
  savey = wherey();
  gettextinfo(&ti);
#endif
  InitializeEdit(command);
  LowLevelEditRecord();
  // restore prior window and cursor coordinates
#ifdef _MSC_VER
  _settextwindow(top, left, bottom, right);
  _settextposition(tp.row, tp.col);
#else
  window(ti.winleft,ti.wintop,ti.winright,ti.winbottom);
  gotoxy(savex,savey);
#endif
  dBASEOrder = OldDbaseOrder;
  RestoreCursor(savedcursor);
  if (!DBFEditStayOn)
    PopWindow();
}
