;/* filename: _SEARCH.ASM
;
;: T O P A Z for C :Ŀ
;                          Version 4.5  05/16/93                              
;                                                                             
; Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
; Unauthorized distribution or disclosure of this source code or modification 
;  or removal of this notice  constitutes a breach of the license agreement.  
;
;*/
; SEARCH.ASM
; A case insensitive implementation of the Boyer-Moore algorithm
; but with no table building required.
; Richard Matzinger and Lane Ferris


; use TASM to assemble to an OBJ file.

        .MODEL LARGE
        .CODE


upper  proc near

        CMP     AL,'a'              ; compare with "a"
        JB      @@10                ; return if lower than "a"
        CMP     AL,'z'              ; compare with "z"
        JA      @@1                 ; jump if higher than "z"
        SUB     AL,'a'-'A'          ; subtract 32 from char value
        JMP     SHORT @@10          ; done

@@1:    CMP     AL,132              ; compare with ""
        JE      @@2                 ; jump if equal
        CMP     AL,148              ; compare with ""
        JE      @@3                 ; jump to replace character
        CMP     AL,129              ; compare with ""
        JE      @@4
        CMP     AL,164              ; compare with ""
        JE      @@5
        CMP     AL,130              ; compare with ""
        JE      @@6
        CMP     AL,134              ; compare with ""
        JE      @@7
        CMP     AL,135              ; compare with ""
        JE      @@8
        CMP     AL,145              ; compare with ""
        JE      @@9

        JMP     SHORT @@10          ; return with no changes

@@2:    MOV     AL,142              ; change to 
        JMP     SHORT @@10          ; return change

@@3:    MOV     AL,153              ; change to 
        JMP     SHORT @@10          ; return change

@@4:    MOV     AL,154              ; change to 
        JMP     SHORT @@10          ; return change

@@5:    MOV     AL,165              ; change to 
        JMP     SHORT @@10          ; return change

@@6:    MOV     AL,144              ; change to 
        JMP     SHORT @@10          ; return change

@@7:    MOV     AL,143              ; change to 
        JMP     SHORT @@10          ; return change

@@8:    MOV     AL,128              ; change to 
        JMP     SHORT @@10          ; return change

@@9:    MOV     AL,146              ; change to 
@@10:   RET

upper  endp


blockupper proc near
              ; CX must have length of area to convert
              ; DS:SI points to text to uppercase
              push aX ; save value in AX
              push SI
              push CX
              INC  CX

NextChar:     DEC  CX                        ; decrement char counter
              JZ   done                      ; end of string found
              MOV  AL,DS:BYTE PTR [SI]
              CALL upper
              MOV  DS:BYTE PTR [SI],AL
              INC  SI                        ; increment index into string
              JMP  SHORT NextChar
done:
              pop  CX
              pop  SI                        ; restore SI
              pop  AX                        ; restore AX
              RET

blockupper endp


Search Proc Near

  ; parameters
  ; bx = length of pattern to search for
  ; dx = offset of last byte in target data (buffer)
  ; si = offset of first byte of target data (buffer)
  ; di = offset of first byte in pattern (search string)
  ; pattern is pointed to by es and the target is pointed to by ds

  ; returns carry clear and si= matching text or carry set if no match

     DEC   BX                     ; bx = pattern length -1
     MOV   AL, es:[BX+DI]         ; get the last char in pattern
     MOV   AH,AL                  ; save the char in AH
     CLD                          ; searches count up

COMPARE:
                                  ; reached end of text yet?
     PUSH  SI                     ; save SI
     ADD   SI,BX                  ; see if SI+BX > segment size
     JNC   DOCOMP                 ; No, so check if end of buffer
     POP   SI                     ; Yes
     JMP   NOT_FOUND              ; end of segment reached, jump to exit
DOCOMP:
     CMP   SI,DX                  ; are we at end of buffer?
     POP   SI
     JA   NOT_FOUND               ; yes, jump to exit

     MOV   CX,BX                  ; put pattern length-1 in cx
     INC   CX                     ;

     MOV   AL,[BX+SI]             ;

     CALL  upper                  ; uppercase the character about to be compared
     MOV   [BX+SI],AL             ;  in target
     MOV   AL,AH

     CMP   AL, [bX+SI]            ; last char in pattern match the target?
     JNE   SHIFT                  ; no, shift pattern
     PUSH  SI                     ; save the pointers
     PUSH  DI                     ;

     CALL blockupper

     REPZ  CMPSB                  ; Compare pattern with this portion of text
                                  ; "repeat until non-match or cx=zero"
     POP   DI
     POP   SI
     JE    FOUND                  ; match found, bailout (cx was decremented
                                  ;  to zero because all characters matched)
     MOV   CX,BX                  ;
     INC   CX

SHIFT:
     PUSH  DI                     ; save the pointer to the start of the pattern
     MOV   AL,[BX+SI]             ; get non matching char

     CALL  upper                  ; uppercase it

     MOV   BX,CX                  ; setup BX for possible jmp to shift1
     REPNE SCASB                  ; non-matching char in pattern?
     JCXZ  SHIFT1                 ; no, proceed (jump if CX = 0)
;-----------------------------------------------------------------;
; Just because we now know the position of the FIRST occurance of ;
; the letter in the PATTERN does NOT mean we know the same for the;
; 1st occurance of the letter in the TEXT buffer.                 ;
;                                                             -lf ;
;-----------------------------------------------------------------;
     PUSH  BP
     MOV   BP,SP
     PUSH  CX                     ; save pattern position
     MOV   CX,BX                  ; force text uppercase like pattern
     CALL  blockupper
     PUSH  ES
     MOV   CX,DS
     MOV   ES,CX                  ;switch es:di ds:si for scasb
     XCHG  DI,SI
     PUSH  DI
     MOV   CX,BX                  ; find matching character in text
     REPNE SCASB                  ; cx will contain pos(letter,text)
     POP   DI                     ; distance from si to character
     POP   ES
     XCHG  DI,SI
     SUB   [BP-2],CX              ;differences in distances (pattern-text)
     POP   CX
     CMP   CX,0                   ; must add at least one position to si
     JG    @@20
     MOV   CX,1
     CLC
@@20:
     ADD   SI,CX                  ; yes, shift pattern (CX) chars
     POP   BP
     JMP   SHORT   SHIFT2

SHIFT1:
     ADD   SI,BX                  ; shift pattern (pattern len) chars
                                  ; may cause a carry if overflow to
                                  ;  next segment occurs

SHIFT2:
     POP   DI                     ; restore pointer to the start of the pattern
     MOV   AL,AH                  ; restore AL (last character in pattern)
     JC    NOT_FOUND              ; if segment wrap then bailout
     DEC   BX                     ; BX = pattern length -1
                                  ;   (why?, because it gets incremented)
     JMP   COMPARE                ; loop

FOUND:                            ; search successful
     INC   BX                     ; restore BX to original value
     CLC                          ; clear carry flag to indicate found
     RET

NOT_FOUND:                        ; search unsuccessful
     STC                          ; set carry flag to indicate not found
     RET

Search ENDP




; setup required for call to Search
  ; dx = offset of last byte in target string
  ; si = offset of first byte in target string
  ; bx = length of pattern string
  ; di = offset of first byte in pattern
  ; es: = ds

BLKSEARCH  PROC FAR ; pattern:DWORD, target:DWORD, Plength:WORD,TLength:WORD ; parameters from Turbo
PUBLIC  BLKSEARCH

;   uses BX,DX,SI,CX,DI,ES,DS    ; push the registers we use, for safety
    PUSH    BP
   MOV	   BP,SP
   PUSH    BX
   PUSH    DX
   PUSH    SI
   PUSH    CX
   PUSH    DI
   PUSH    ES
   PUSH    DS
  MOV  AX,0                    ; clear AX

   ; check for zero length of pattern
   MOV  BX, [BP+08h]            ; put length of pattern in BX
   CMP  BX,0                    ; check for zero length pattern block
   JE   NotInBlock              ; exit if zero length pattern block

   ; check for zero length of target
   MOV  DX, [BP+06h]            ; put length of target block into DX
   CMP  DX,0                    ; check for zero length target block
   JE   NotInBlock              ; exit if zero length target buffer

   ; uppercase the pattern (it is on the stack and not the users string)
   LDS  SI, DWORD PTR [BP+0Eh]  ; put pattern address into DS:SI
   MOV  CX, [BP+08h]            ; CX must have the length to convert
   CALL BlockUpper
   LES  DI, [BP+0Eh]            ; put pattern address into ES:DI

   ; get address of target block (it is always a copy of the users data)
   LDS  SI, [BP+0Ah]            ; put target address into DS:SI


   MOV  DX,SI                   ; put offset of target block into DX
   ADD  DX,[BP+06h]             ; DX must be offset of last byte in target
   DEC  DX                      ; correct for off by one error

   CALL Search

   MOV  AX,0                    ; clear AX
                                ; if carry is clear then SI = position
                                ;   of pattern in target
   JC   NotInBlock              ; test carry flag
   MOV  AX,SI                   ; move found address into AX
   SUB  AX, WORD PTR [BP+0Ah]   ; subtract starting address
   INC  AX                      ; add one to result

NotInBlock:                     ; return unsuccessful
   POP	 DS
   POP	 ES
   POP	 DI
   POP	 CX
   POP	 SI
   POP	 DX
   POP	 BX
   POP	 BP
   RET   0000Ch                       ; return result in AX

BlkSearch ENDP


END

