/* filename: VALDFNAM.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#ifdef _MSC_VER
#include <direct.h>
#else
#include <dir.h>
#endif
#include <io.h>
#include <string.h>
#include <dbf.h>

int ValidFilename(const char * fn)
{
  FILE *  f;
  PathStr path;
  PathStr SaveDir;
  char *  p;
  char    buf[80];

  strcpy(buf, Ltrim(Trim(fn)));
  if ((strlen(buf) > 2) && (buf[1] == ':'))
    strcpy(buf, buf+2);  // remove a drive letter w/colon if given
  if (!*buf || strchr(buf, ' '))
    return FALSE;
  if (!access(buf, 0))
    return TRUE;
  // if a path was specified, parse that out:
  strcpy(path, buf);
  if ((p = strrchr(path, '\\')) != NULL)
    *p = 0;
  // if a path was specified, test to see if the path is a valid DOS pathname:
  if (*path && strcmp(path,"\\")) {
#ifdef _MSC_VER
    _getcwd(SaveDir, 80);
#else
    getcurdir(0, SaveDir);
#endif
    if (chdir(path)) { // path doesn't exist, but could it?
      if (mkdir(path)) { // path can't be made: either it's not a valid name,
                         // or its already a file
        chdir(SaveDir);
        return FALSE;
      }
      // we could make the path just fine, but we'd better erase it!
      rmdir(path);
    }
    chdir(SaveDir);
  }
  if ((f = fopen(buf, "w")) != NULL)
    if (!fclose(f))
      if (!remove(buf))
        return TRUE;
  return FALSE;
}
