/* filename: TZPOKE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#ifdef _MSC_VER
#include <malloc.h>
#else
#include <alloc.h>
#endif
#include <string.h>
#include <stdlib.h>
#include <io.h>
#include <dbf.h>

void Poke(const char *s, int fieldnum, long RecordNum)
{
  unsigned char len;
  int offset;
  char tmp[STRSIZ];
  dbfRecord *h;
#ifdef NET
  WorkAreaType *wa;
#endif

  h = &WorkArea[Selected]->Handle;
#ifdef NET
  wa = WorkArea[Selected];
#endif

  if (bad_field_param("Poke", fieldnum, 0))
    return;
  if (h->v.strue.LinkedList) {
    SetError(InvalidLLOperation, 2,
    Operation_cannot_be_used_on_virtual_files, " [Poke]");
    return;
  }
#ifdef NET
  if (MultiUser && !wa->Exclusive && (wa->LockStatus != FileLocked)) { // ALOCK, FLOCK, RLOCK
    if ((wa->LockStatus == AppendLocked) || !IsLocked(wa->LockList, RecordNum)) {
      sprintf(tmp,"%s [Poke(%s,%d, %d)]", Record_not_locked,s,fieldnum,RecordNum);
      SetError(RecordNotLocked, 1, tmp);
      return;
    }
  }
#endif

  if ((RecordNum < 1) || (fieldnum > h->NumFields) || (RecordNum > h->NumRecs))
    return;  // generate an error here
#ifndef WINDOWS
  AdvanceRotor();
#endif
  if (!fieldnum) { // looking at deleted byte
    len = 1;
    offset = 0;
  }
  else { // some other field
    len = h->Fields[fieldnum-1].Len;
    offset = h->Fields[fieldnum-1].Off;
  }
  memcpy(tmp, Pad(s, len), len);
  lseek(h->v.dFile, h->HeadLen+(RecordNum-1)*h->RecLen+offset, SEEK_SET);
  write(h->v.dFile, tmp, len);
  DBFError = errno;
}
