/* filename: TZPEEK.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#ifdef _MSC_VER
#include <malloc.h>
#else
#include <alloc.h>
#endif
#include <string.h>
#include <stdlib.h>
#include <io.h>
#ifdef WINDOWS
#include <windows.h>
#endif
#include <dbf.h>

extern unsigned PeekCache;
extern char *PeekBuffer;

static  char _tzfar temp[STRSIZ] = { 0 };

char * Peek(int fieldnum, long recordNum)
{
  unsigned Off;
  int Len;
  int RecordInBuffer;
  static string10 PriorAlias  = "";
  static unsigned NCache  = 0, OldCacheSize = 0;
  static long StartNum  = 1;
  dbfRecord       *h;

  h = &WorkArea[Selected]->Handle;

  if (bad_field_param("Peek", fieldnum, 0))
    return "";
  if (h->v.strue.LinkedList) {
    SetError(InvalidLLOperation, 2, Operation_cannot_be_used_on_virtual_files,
    " [Peek]");
    return "";
  }
  if ((recordNum < 1) || (fieldnum > h->NumFields) || (recordNum > h->NumRecs))
    return "";
#ifndef WINDOWS
  AdvanceRotor();
#endif
  if (fieldnum == 0) { // looking at the deleted byte
    Off = 0;
    Len = 1;
  }
  else { // looking at some other field
    Off = h->Fields[fieldnum-1].Off;
    Len = h->Fields[fieldnum-1].Len;
  }
  if (strcmp(Alias(), PriorAlias) && PeekBuffer)
    FreePtrClear((void*) &PeekBuffer);
  if (!PeekCache) {
    lseek(h->v.dFile, h->HeadLen + (recordNum-1)*h->RecLen+Off, SEEK_SET);
    read(h->v.dFile, temp, (size_t) Len);
    temp[Len] = 0;
    return temp;
  }
  RecordInBuffer = (PeekBuffer &&
  (recordNum < (StartNum + NCache)) && (recordNum >= StartNum));
  if (!PeekBuffer || !RecordInBuffer) {//Read in a "chunk" of records
    if (!PeekBuffer) { // allocate PeekCache
      // allocate an integral number of records
      if (PeekCache > 0xFFE8)
        PeekCache = 0xFFE8;
      NCache = PeekCache / h->RecLen;
      PeekCache = NCache * h->RecLen;
      if (NCache == 0) {
        PeekCache = h->RecLen;
        NCache = 1;
      }
      if((PeekBuffer = (char *)malloc(PeekCache)) == NULL) {
        SetError(InsufficientMemory, 1, " [Peek]");
        return "";
      }
      OldCacheSize = PeekCache;
    }
    lseek(h->v.dFile, h->HeadLen+(recordNum-1)*h->RecLen, SEEK_SET);
    read(h->v.dFile, PeekBuffer, PeekCache);
    DBFError = errno; // RSM: why do we not SetError if a problem occurred?..gbr
    strcpy(PriorAlias, Alias());
    StartNum = recordNum;
  }
  memcpy(temp, &PeekBuffer[(unsigned) (recordNum-StartNum)*h->RecLen+Off], Len);
  temp[Len] = 0;
  return temp;
}
