/* filename: SETFILT2.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <parser.h>
#include <dbf.h>

void SetFilterToCB(int (*filterproc) (void))
{
  WorkAreaType *wa;
  if (!NotInUseError("SetFilterToCB")) {
    wa = WorkArea[Selected];
    wa->FilterFunc = filterproc;
    if (wa->FilterExprHandle) {
      if (ParserRoutines.DisposeExprProc)
        ParserRoutines.DisposeExprProc(&wa->FilterExprHandle); // Cannot call DisposeExpr directly here
      else
        SetError(254,1," [SetFilterToCB]");
    }
  }
}

void SetFilterTo(const char *expr)
{
  WorkAreaType *wa;
  int ErrorID = 0;

  if (!CheckRegisteredUnits("SetFilterTo", REGTZCOMMON+REGTZDBF+REGTZPARSER))
    return;

  if (!NotInUseError("SetFilterTo")) {
    wa = WorkArea[Selected];
    if (!expr) { // if expr is NULL, we want to turn off the filter
      DisposeExpr((ExprHandle *)(&wa->FilterExprHandle));
      wa->FilterFunc = NULL;
      return;
    }
    if (!*Trim(expr)) { // if expr is empty, we want to turn off the filter
      DisposeExpr((ExprHandle *)(&wa->FilterExprHandle));
      wa->FilterFunc = NULL;
      return;
    }

    wa->FilterExprHandle = (void *) AssignExpr(expr);
    if (wa->FilterExprHandle) { // check if AssignExpr() failed
      // we have a good expression, but it must be logical for a "while" condition
      if (((ExprHandle)(wa->FilterExprHandle))->ReturnType == 'L')
        wa->FilterFunc = NULL;
      else
        ErrorID = NotLogicalExpr;
    }
    else
      ErrorID = ErrorInDBaseExpression;

    if (ErrorID)
      SetError(ErrorID,3," [SetFilterTo(", expr, ")]");
  }
}
