/* filename: SEARCHFL.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <io.h>
#ifdef _MSC_VER
#include <malloc.h>
#else
#include <alloc.h>
#endif
#include <share.h>
#include <errno.H>
#include <string.h>
#ifdef WINDOWS
#include <windows.h>
#endif
#include <dbf.h>

extern void (* ScanRoutine)(void);

unsigned pascal BlkSearch(void far * pattern, void far * target,
  unsigned Plen, unsigned Tlen);

void SearchFile(const char * filename, const char * s, long * offset)
{
  FILE *   f;
  void *   buffer;
  int      buffersize;
  unsigned recsread;
  long     lastpos;
  unsigned found;
  char     fname[STRSIZ], sstr[STRSIZ], errmsg[STRSIZ];

  *offset = 0;
  strcpy(fname, Trim(filename));
  strcpy(sstr, Trim(s));
  if (!*sstr || !*fname)
    return;
  sprintf(errmsg, " [SearchFile(%s, %s)]", filename, sstr);
  if ((f =  _fsopen(fname, "rb", SH_DENYWR))== NULL) {
    SetError(errno, 1, errmsg);
    return;
  }
  buffersize = 0xFFE8;
  while ((buffer = malloc(buffersize)) == NULL) {
    buffersize >>= 1;
    if (buffersize < 0x1000) {
      fclose(f);
      SetError(217, 1, errmsg);
      return;
    }
  }
  do {
    do {
#ifndef WINDOWS
      AdvanceRotor();
#endif
      lastpos = ftell(f);
      recsread = fread(buffer, 1, (size_t) buffersize, f);
      found = BlkSearch(sstr, buffer, strlen(sstr), recsread);
    }  while (!((found > 0) || feof(f)));
#ifndef WINDOWS
    AdvanceRotor();
#endif
    lastpos += found;
    if (found > 0) {
      *offset = lastpos;
      if (ScanRoutine != NULL) {
        ExitSearch = FALSE;
        ScanRoutine();
        if (!ExitSearch)
          found = 0;
      }
    }
  }  while (!((found > 0) || feof(f)));
  free(buffer);
  fclose(f);
}
