/* filename: PACK.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <io.h>
#include <errno.h>
#include <ctype.h>
#ifndef _MSC_VER
#include <alloc.h>
#else
#include <malloc.h>
#endif
#include <conio.h>
#include <string.h>
#ifdef WINDOWS
#include <windows.h>
#endif
#include <dbf.h>

void SyncRelations(void);
void ExportData(void);
void FlushAfterAppend(dbfRecord * d);

#ifndef WINDOWS
static char YN[] = { "NYny" };
#endif

static char funcname[] = { " [Pack]" };

void Pack(void)
// just move records up into the slots where deleted records are
// and truncate the bottom of the file
{
  char *Pbuffer;
  long counter = 0, fread_offset, fwrite_offset;
  char control_z = '\x1A';
  long goodrecs = 0;
  int SaveFlushEnabled, deleted, lastloop;
  unsigned bufsize, r_count, w_count, w_size, bytesread, count;
  char * r_ptr, * w_ptr;
  void (* SaveSyncPointer)(void);
#ifndef WINDOWS
  char SaveX, SaveY;
  char answer;
#else
  char s[50];
#endif
  WorkAreaType *wa;
  dbfRecord    *r;

  wa = WorkArea[Selected];
  r = &wa->Handle;
  DBFError = 0;
  if (NotInUseError(funcname))
    return;
  if (!r->NumRecs)
    return;
#ifndef WINDOWS
  SaveX = wherex();
  SaveY = wherey();
#endif

#ifdef NET
  if (!wa->Exclusive) { // access denied
    SetError(5, 3, File_must_be_open_exclusive, r->FileName, funcname);
    return;
  }
#endif
  if (SafetyOn) { // ask for confirmation
#ifdef WINDOWS
    sprintf(s, "PACK %s", r->FileName);
    if (WDialogBox(s,"",MB_OKCANCEL | MB_ICONQUESTION) == IDCANCEL)
      return;
#else
    printf("\nPack %s%s", r->FileName, question_y_n);
    do {
      answer = getch();
    }  while (!(strchr(YN,  answer) && (answer != 0)));
    if (toupper(answer) == 'N')
      return;
#endif
  }
  if (r->v.strue.LinkedList) {
    r->v.strue.Action = doPackLL;
    LLRoutines(r);
    return;
  }
#ifndef WINDOWS
  if (TalkEnabled) {
    gotoxy(SaveX,SaveY);
    printf(percent_complete);
  }
#endif
  SaveFlushEnabled = FlushEnabled;
  FlushEnabled = FALSE; //  True makes pack operation horribly slow
  SaveSyncPointer = wa->SyncProc;
  wa->SyncProc = NULL;

  r_count = 0xFFE8 / r->RecLen; // get the max normalized bufsize
  bufsize = r_count * r->RecLen;
  while ((Pbuffer = (char *) malloc(bufsize)) == NULL) {
    bufsize -= 4000U;
    r_count = bufsize / r->RecLen; // normalize the size
    bufsize = r_count * r->RecLen;
    if (bufsize < 4000U) {
      SetError(InsufficientMemory, 1, funcname);
      return;
    }
  }
  lastloop = FALSE;
  deleted = FALSE;
  fread_offset = fwrite_offset = r->HeadLen;
  while (lastloop == FALSE) {
    lseek(r->v.dFile, fread_offset, SEEK_SET);
    bytesread = (unsigned) read(r->v.dFile, Pbuffer, bufsize);
    if (bytesread != bufsize) { // the last chunk of DBF file ...
      r_count = bytesread/r->RecLen; // now sync the bufcount value
      lastloop = TRUE;
    }
    fread_offset += bytesread;
    w_ptr = r_ptr = Pbuffer;
    w_count = r_count;
    for (count = 0; count < r_count; ++count) {
#ifndef WINDOWS
      if (EscapeEnabled) {
        if (KeyPressed()) {
          answer = getch();
          if (answer == 0)
            answer = getch();
          if (answer == '\x1B') { // escape key pressed
            gotoxy(1, ScoreRow);
            printf("\n%s", Abort_Pack_y_n);
            do {
              answer = getch();
            }  while (!(strchr(YN,  answer) && answer));
            if (toupper(answer) == 'Y') {
              GoBottom();
              wa->SyncProc = SaveSyncPointer;
              FlushEnabled = SaveFlushEnabled;
              return;
            }
          }
        }
      }
      if (TalkEnabled) {
        gotoxy(SaveX,SaveY);
        printf("%3.0f%s", ((float) counter * count / (float) r->NumRecs) * 100.0, percent_complete);
      }
#endif
      if (*r_ptr != '*') { // check if record is deleted
        ++goodrecs; // if not deleted
        if (deleted) { // we have deleted records in the DBF file
          memcpy(w_ptr, r_ptr, r->RecLen);
          w_ptr += r->RecLen;
        }
      }
      else { // record is deleted so we remember the first one and go on to the next record
        deleted = TRUE;
        w_count--;
      }
      if (!deleted)
        w_ptr += r->RecLen;
      r_ptr += r->RecLen;
    } // now write down the chunk unless there were deleted records
    w_size = w_count * r->RecLen;
    if (w_size && deleted) {
      lseek(r->v.dFile, fwrite_offset, SEEK_SET);
      bytesread = (unsigned) write(r->v.dFile, Pbuffer, w_size);
      if (bytesread != w_size) { // the last chunk of DBF file ...
        SetError(errno, 3, Error_writing, r->FileName, funcname);
        return;
      }
    }
    fwrite_offset += w_size;
    counter++;
  }
  free(Pbuffer);
  r->dStatus = Appended; // force the header to be written during the flush to come
  FlushEnabled = SaveFlushEnabled;
#ifndef WINDOWS
  if (TalkEnabled)
    printf("\n");
#endif
  DBFError = 0; // now truncate file
  lseek(r->v.dFile, r->HeadLen+(r->RecLen * goodrecs), SEEK_SET);
  if (write(r->v.dFile, &control_z, 1) != 1)
    DBFError = 29;  // "Device write fault" message
  else
    DBFError = chsize(r->v.dFile, r->HeadLen+(r->RecLen * goodrecs)+1);
  if (DBFError) {
    wa->SyncProc = SaveSyncPointer;
    SetError(DBFError, 2, Error_packing, r->FileName);
    return;
  }
  r->NumRecs = goodrecs;
  wa->SyncProc = SaveSyncPointer;
  FlushAfterAppend(r); // write the header data to file
  if (r->NumRecs > 0) {
    GetDbfRecord(r, 1);
    if (DBFError)
      return;
    ExportData();
    r->CurRecNo = 1;
    r->EOFile = FALSE;
    r->BOFile = FALSE;
  }
  else { // if file is empty after pack
    ClearRecord();
    r->EOFile = TRUE;
    r->BOFile = TRUE;
    r->CurRecNo = 0;
  }
  if (r->HasMemo && MemoRoutines._LowLevelMemoPack) { // we need to pack the memo file
    MemoRoutines._LowLevelMemoPack();
    if (DBFError)
      return;
  }
  if (IndexPresent && IndexRoutines.IndexOpenFunc()) // reindex any open indexes for this file!
    IndexRoutines.ReindexProc();
  SyncRelations();
}
