/* filename: OPENDBF.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <dos.h>
#include <dbf.h>

extern char CustomFileID;
extern char CustomFileWithMemo;

char ValidTypes[]  = { "CNLMDF"}; // for fields
static char  _tzfar funcname[] = {" [Use/OpenDbf]"};

static void GetOneFieldDesc(FieldDescType * f, FieldRecord *Field,
int *offset, dbfRecord *d)
{
  strncpy(Field->Name, (char *) f, 10);
  Field->Name[10] = 0;
  Field->Typ = ((char *) f)[11];
  if (d->HeadProlog[0] == DB2File) {
    Field->Len = ((char *) f)[12];
    Field->Dec = ((char *) f)[15];
  }
  else {
    Field->Len = ((char *) f)[16];
    Field->Dec = ((char *) f)[17];
  }
  Field->Off = *offset;
  *offset += Field->Len;
  if (!strchr(ValidTypes, Field->Typ) || !Field->Typ)
    SetError(InvalidField, 3, Field->Name, _in_, d->FileName);
}

static void GetHeader(dbfRecord *d)
{
  typedef unsigned char FieldDescTypeII[16];

  union {
    struct Prolog { // gbr128..Prolog is a record that matches the first 32 bytes in a DBF III and IV file
      unsigned char Version;
      unsigned char LastUpdate[3]; // YYMMDD
      long      RecordCount;
      unsigned  HeaderSize;
      unsigned  RecordSize;
      unsigned  Reserved1;
      char      TransactionPending; // one byte, non-zero if transaction is pending in dBASE IV
      unsigned char Reserved2[13];
      unsigned char MDXFlags;
      unsigned char Reserved3[3];
    } Prolog; // 32 bytes in all
    struct PrologII { // matches the first 8 bytes of a DBF II file
      unsigned char Version;
      unsigned      RecordCount;
      unsigned char LastUpdate[3]; // YYMMDD
      unsigned      RecordSize;
    } PrologII; // 8 bytes in all
  } v;
  FieldArray TempFields;
  int o, i;
  unsigned FieldsLen;
  unsigned FDSize;
  struct stat st;
  char *reason;

  FieldDescType *FieldDescriptor = NULL;
  FieldDescTypeII *FieldDescriptorII = NULL;

  // gbr128..new way, read the prolog first, then allocate exactly the right
  // amount of memory for the field descriptors

  // read the 32 byte prolog
  if (read(d->v.dFile, &v.Prolog, sizeof(v.Prolog)) != sizeof(v.Prolog)) { // could we read 32 bytes?
    reason = incomplete_prolog;
    goto NOTDBF;
  }
  memcpy(d->HeadProlog, &v.Prolog, sizeof(d->HeadProlog));
  // we can read the prolog. Check the first byte for its signature. The first
  // byte must either match the Custom ID or the least 3 bits must be 2 or 3
  if ((CustomFileID && (v.Prolog.Version != (unsigned char) CustomFileID)) ||
    (CustomFileWithMemo && (v.Prolog.Version != (unsigned char) CustomFileWithMemo)) ||
    !(((v.Prolog.Version & 0x7) == 2) || ((v.Prolog.Version & 0x7) == 3))) {
    reason = invalid_version_byte;
    goto NOTDBF;
  }
  // signature is OK. At this point we must detect if we are dealing with a
  // dBASE II file. If so, the prolog is handled differently
  if (!CustomFileID && !CustomFileWithMemo &&
  ((v.Prolog.Version & 0x7) == DB2File)) { // dBASE II. Use the PrologII struct syntax
    d->NumRecs = v.PrologII.RecordCount;
    sprintf(d->LastUpdate,"%02d/%02d/%02d", v.PrologII.LastUpdate[1],
    v.PrologII.LastUpdate[2], v.PrologII.LastUpdate[0]);
    d->RecLen = v.PrologII.RecordSize; // includes the Deleted Record Flag
    d->HeadLen = 521; // fixed header length for a dBASE II file
    fstat(d->v.dFile, &st);
    if (st.st_size < d->HeadLen) {
      reason = incomplete_header;
      goto NOTDBF;
    }
    if ((d->CurRecord = (char *)malloc(d->RecLen)) == NULL)
      goto ERROR;
    memset(d->CurRecord, ' ', d->RecLen);
    d->HasMemo = FALSE; // dBASE II does not support memo fields
    lseek(d->v.dFile, sizeof(v.PrologII), SEEK_SET); // position file to start of field descriptors
    //  we have to allocate memory for 32 fields (the maximum allowed in
    // dBASE II), since we have no way of knowing how many fields there are
    // ..the terminating byte will tell us
    if ((FieldDescriptorII = malloc(32*16)) == NULL) //  dBASE II field descriptors are 16 bytes
      goto ERROR;
    if (read(d->v.dFile, FieldDescriptorII, 32*16) != 32*16) // fill the array from disk
      goto ERROR;
    o = 1; // offset of the field into the record..updated by GetOneFieldDesc
    for (i = 0; FieldDescriptorII[i][0] != 0x0D; ++i) {
      GetOneFieldDesc((FieldDescType *) FieldDescriptorII[i], &TempFields[i], &o, d);
      if (DBFError)
        goto ERROR;
    }
    free(FieldDescriptorII);
    d->NumFields = --i;
  }
  else { // dBASE III or IV file
    // set the HasMemo flag. Just look at the msb of the version byte or
    // compare with Custom ID
    if (CustomFileWithMemo)
      d->HasMemo = v.Prolog.Version == (unsigned char) CustomFileWithMemo;
    else
      d->HasMemo = (v.Prolog.Version & 0x80) ?  v.Prolog.Version : 0;
    // prolog.HeaderSize tell us how much more to read..and we can figure out
    // the number of fields, too
    FDSize = v.Prolog.HeaderSize - sizeof(v.Prolog); // field descriptor size
    i = FDSize / 32;
    // check i (i.e. d->NumFields) for good range
    if (!i) {
      reason = number_of_fields_out_of_range;
      goto NOTDBF;
    }
    d->NumFields = i;
    // fill in other fields of d
    sprintf(d->LastUpdate,"%02d/%02d/%02d", v.Prolog.LastUpdate[1],
    v.Prolog.LastUpdate[2], v.Prolog.LastUpdate[0]);
    d->NumRecs = v.Prolog.RecordCount;
    d->HeadLen = v.Prolog.HeaderSize;
    d->RecLen = v.Prolog.RecordSize; // Includes the Deleted Record Flag
    if ((d->CurRecord = (char *)malloc(d->RecLen)) == NULL)
      goto ERROR;
    memset(d->CurRecord, ' ', d->RecLen);
    // check if we have enough memory to read the field descriptor block
    if ((FieldDescriptor = malloc(FDSize)) == NULL)
      goto ERROR;
    if (read(d->v.dFile, FieldDescriptor, FDSize) != (int) FDSize)
      goto ERROR;
    // FieldDescriptors have been read in..
    o = 1; // offset within dbf record of current field
    for (i = 0; i < d->NumFields; i++) {
      GetOneFieldDesc((FieldDescType *) FieldDescriptor[i], &TempFields[i], &o, d);
      if (DBFError)
        goto ERROR;
    }
    free (FieldDescriptor);
  }
  d->dStatus = NotUpdated;
  FieldsLen = d->NumFields * sizeof(FieldRecord);
  if ((d->Fields = malloc(FieldsLen)) == NULL)
    goto ERROR;
  memcpy(d->Fields, TempFields, FieldsLen);

  return;

ERROR:
  FreePtrClear((void*) &d->CurRecord);
  FreePtrClear((void*) &FieldDescriptor);
  FreePtrClear((void*) &FieldDescriptorII);
  close(d->v.dFile);
  if (errno || DBFError)
    SetError(DBFError ? DBFError : errno, 3, Error_reading, d->FileName, funcname);
  else
    SetError(217, 2, Not_enough_memory_to_open, d->FileName);
  return;

NOTDBF:
  close(d->v.dFile);
  SetError(NotDbfFile, 4, d->FileName, is_not_a_dBASE_database,
     reason, funcname);
  return;
} // GetHeader

void OpenDbf(dbfRecord * d)
{
  struct stat st;

  if (!CheckRegisteredUnits("OpenDbf", REGTZCOMMON+REGTZDBF))
    return;

  strcpy(d->FileName, AddExt(d->FileName,"DBF"));
  d->Fmode = FileMode; // save the mode used to open this file
  if ((d->v.dFile = sopen(d->FileName, O_RDWR | O_BINARY,
        d->Fmode, S_IREAD | S_IWRITE)) == -1) {
    SetError(errno, 3, Failure_to_open, d->FileName, funcname);
    return;
  }
  else {
    GetHeader(d);
    if (DBFError)
      return;
  }
  d->HighLevel = FALSE;
  fstat(d->v.dFile, &st);
  if (AutoFixRecCount) // ignore how many records header claims, calculate them
    d->NumRecs = (st.st_size - d->HeadLen) / d->RecLen;
  if (d->NumRecs > 0) {
    d->CurRecNo = 1;
    d->BOFile = d->EOFile = FALSE;
  }
  else {
    d->CurRecNo = 0;
    d->BOFile = d->EOFile = TRUE;
  }
}
