/* filename: NETLOCK.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <dbf.h>

#ifndef _MSC_VER
#ifndef NET
#pragma argsused
#endif
#endif

unsigned LockUnlock(char mode, unsigned Handle, long offset, long size)
// generic locking/unlocking routine
{
#ifdef NET
  struct REGPACK cpu;

  if (!MultiUser)
    return 0;
  memset(&cpu, 0, sizeof(cpu)); // for Windows compatibility
  // probably should have retry stuff here instead of in Rlock and Flock
  cpu.r_ax = 0x5C00 + mode;  // 0=lock, 1=unlock
  cpu.r_bx = Handle;
  cpu.r_cx = *(&(unsigned) offset +1);
  cpu.r_dx = (unsigned) offset;
  cpu.r_si = *(&(unsigned ) size + 1);
  cpu.r_di = (unsigned) size;
  intr(0x21, &cpu);
  LockUnlockReason = 0;
  if (cpu.r_flags & 1) {
    LockUnlockReason = cpu.r_ax;
    return cpu.r_ax;
  }
  else
    return 0;
#else
  LockUnlockReason = 0;
  return 0; // single user: always successful
#endif
}
