/* filename: NETFOUND.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <dbf.h>

#ifdef NET

typedef struct RequestType {
  unsigned blength;
  unsigned char sfunction;
} RequestType;

BOOL NetworkFound(void)
{
  unsigned char LocalDeviceName[16];
  char NetName[128];
  long NovellID;
  int NetFound;
  RequestType request;
  struct reply {
    unsigned len;
    unsigned char access;
    long id;
  } reply;
  struct REGPACK cpu;
#ifdef _MSC_VER
  void _far * ptr;
#endif

  memset(&cpu, 0, sizeof(cpu));  // for Windows compatibility
  memset(&reply, 0, sizeof(reply));
  memset(&request, 0, sizeof(request));

  cpu.r_ax = 0xE301;
#ifdef _MSC_VER
  ptr = (void _far *) &request;
  cpu.r_ds = FP_SEG((void _far *) ptr);
  cpu.r_si = FP_OFF((void _far *) ptr);
  ptr = (void _far *) &reply;
  cpu.r_es = FP_SEG((void _far *) ptr);
  cpu.r_di = FP_OFF((void _far *) ptr);
#else
  cpu.r_ds = FP_SEG((void far *) &request);
  cpu.r_si = FP_OFF((void far *) &request);
  cpu.r_es = FP_SEG((void far *) &reply);
  cpu.r_di = FP_OFF((void far *) &reply);
#endif
  reply.len = 5; // buffer length = 5 bytes
  request.blength = 1; // buffer length = 1 byte
  request.sfunction = 0x46; // novell sub-function number
  intr(0x21, &cpu);

  NovellID = reply.id;
  // call successful
  // user object id
  // -1 if not logged on to network
  NetFound =  (((cpu.r_ax & 0xff) == 0) && reply.id &&
  (reply.id != -1) && !reply.access); // user security access level
  if (!NetFound && (NovellID > - 1)) {
    if (((_osmajor >= 0x03) && (_osminor >= 0x0A)) || // DOS 3.10 or greater
    (_osmajor >= 0x04)) {
      memset(&cpu, 0, sizeof(cpu)); // for Windows compatibility
      cpu.r_ax = 0x5F02;
      cpu.r_bx = 0;
#ifdef _MSC_VER
      ptr = (void _far *) &NetName;
      cpu.r_es = FP_SEG((void _far *) ptr);
      cpu.r_di = FP_OFF((void _far *) ptr);
      ptr = (void _far *) &LocalDeviceName;
      cpu.r_ds = FP_SEG((void _far *) ptr);
      cpu.r_si = FP_OFF((void _far *) ptr);
#else
      cpu.r_ds = (unsigned) FP_SEG((char far *) &LocalDeviceName); // 16 bytes
      cpu.r_si = (unsigned) FP_OFF((void far *) &LocalDeviceName);
      cpu.r_es = (unsigned) FP_SEG((void far *) &NetName);  // 128 bytes
      cpu.r_di = (unsigned) FP_OFF((void far *) &NetName);
#endif
      intr(0x21, &cpu);
      if (!((cpu.r_flags & 1) && (cpu.r_ax == 1)))
        return TRUE;
    }
  }
  return NetFound;
}

#else

BOOL NetworkFound(void)
{
  return FALSE;
}

#endif
