/* filename: GOTOP.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <dbf.h>

#define ON      TRUE
#define OFF     FALSE

void SyncRelations(void);
void ExportData(void);
int ValidRec(void);

void GoTop(void)
{
  long rec;
  int indexisopen;
  dbfRecord *r;

  r = &WorkArea[Selected]->Handle;
  DBFError = 0;
  if (NotInUseError("GoTop"))
    return;
  if (!r->NumRecs)
    return; // no error reported
  rec = 1;
  if (IndexPresent) {
    indexisopen = IndexRoutines.IndexOpenFunc();
    if (indexisopen) {
#ifdef NET
      IndexRoutines.SetReadSemaphoreProc(ON);
#endif
      rec = IndexRoutines.FindFirstRecFunc();
    }
  }
  else
    indexisopen = FALSE;
  GetDbfRecord(r, rec);
  if (!DBFError) // move data to users record structure
    ExportData();
  else
    return;
  while (!ValidRec() && !r->EOFile && !DBFError) {
    if (indexisopen) {
      rec = IndexRoutines.FindNextRecFunc();
      if (IndexRoutines.IEofFunc())
        rec = r->NumRecs+1;
    }
    else
      ++rec;
    if (rec <= r->NumRecs) {
      GetDbfRecord(r, rec);
      if (!DBFError)
        ExportData(); // move data to users record structure
    }
    else { // there are no valid records, so go to reccount+1
      ClearRecord();
      r->CurRecNo = r->NumRecs+1;
      r->EOFile = TRUE;
      if (indexisopen)
        IndexRoutines.SyncIndexProc();
    }
  }
  if (indexisopen) {
    IndexRoutines.StoreCurrentKeys();
#ifdef NET
    IndexRoutines.SetReadSemaphoreProc(OFF);
#endif
  }
  SyncRelations();
}
