/* filename: GOBOTTOM.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <dbf.h>

#define ON      TRUE
#define OFF     FALSE

void CheckActualRecCount(void);
void SyncRelations(void);
void ExportData(void);
int ValidRec(void);

void GoBottom(void)
{
  long rec;
  int tempbof;
  int indexisopen;
  dbfRecord *r;

  r = &WorkArea[Selected]->Handle;

  DBFError = 0;
  if (NotInUseError("GoBottom"))
    return;
  indexisopen = FALSE;

#ifdef NET
  CheckActualRecCount();
#endif

  if (!r->NumRecs)
    return; // no error reported
  rec = r->NumRecs;
  if (IndexPresent) {
    indexisopen = IndexRoutines.IndexOpenFunc();
    if (indexisopen) {
#ifdef NET
      IndexRoutines.SetReadSemaphoreProc(ON);
#endif
      rec = IndexRoutines.FindLastRecFunc();
    }
  }
  GetDbfRecord(r, rec);
  if (!DBFError) // move data to users record structure
    ExportData();
  else
    return;
  tempbof = FALSE;
  while (!ValidRec() && !tempbof) { // skip backwards until we got one
    if (indexisopen) {
      rec = IndexRoutines.FindPriorRecFunc();
      tempbof = IndexRoutines.IBofFunc();
    }
    else {
      tempbof = r->BOFile;
      --rec;
    }
    if ((rec > 0) && !tempbof) {
      GetDbfRecord(r, rec);
      if (!DBFError)
        ExportData(); // move data to users record structure
      tempbof = indexisopen ? IndexRoutines.IBofFunc() : r->BOFile;
    }
    else { // there are no valid records, so go to reccount+1
      tempbof = TRUE;
      ClearRecord();
      r->CurRecNo = r->NumRecs+1;
      r->EOFile = TRUE;
      if (indexisopen)
        IndexRoutines.SyncIndexProc();
    }
  }
  // store the current keys, what about if end of file and keys = blanks?
  if (indexisopen) {
    IndexRoutines.StoreCurrentKeys();
#ifdef NET
    IndexRoutines.SetReadSemaphoreProc(OFF);
#endif
  }
  SyncRelations();
}
