/* filename: GO.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <dbf.h>

#define ON  TRUE
#define OFF FALSE

void CheckActualRecCount(void);
void SyncRelations(void);
void ExportData(void);

void Go(long n) // also updates index
{
  char str[STRSIZ];
  int IndexIsOpen;
  dbfRecord   *h;

  h = &WorkArea[Selected]->Handle;
  if (NotInUseError("Go"))
    return;
  DBFError = 0;
#ifdef NET
  if (n > h->NumRecs)
    CheckActualRecCount();
#endif
  if (!h->NumRecs) {
    h->BOFile = h->EOFile = TRUE;
    ClearRecord();
    goto wrongrec;
  }
  h->BOFile = h->EOFile = FALSE;
  if ((n < 1) || (n > h->NumRecs)) {
    h->CurRecNo = h->NumRecs+1;
    h->EOFile = TRUE;
    goto wrongrec;
  }
  // determine if an index is open
  IndexIsOpen = IndexPresent ? IndexRoutines.IndexOpenFunc() : FALSE;

#ifdef NET
  if (IndexIsOpen)
    IndexRoutines.SetReadSemaphoreProc(ON);
#endif

  GetDbfRecord(h, n);
  if (!DBFError) {
    ExportData(); // move data to users record structure
    if (IndexIsOpen) {
      IndexRoutines.SyncIndexProc();
      IndexRoutines.StoreCurrentKeys();
#ifdef NET
      IndexRoutines.SetReadSemaphoreProc(OFF);
#endif
    }
  }
  if (DBFError && AutoHalt)
    OnErrorHalt();
  SyncRelations();
  return;

wrongrec:
  sprintf(str, "%s %ld database %s%s\" [Go]", Invalid_record_number, n, Database_quote, DBF());
  SetError(OutOfRange, 1, str);
  return;
}
