/* filename: DRVISREM.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#define __MSC
#include <dos.h>
#ifdef _MSC_VER
#include <direct.h>
#else
#include <dir.h>
#endif
#include <dbf.h>

static char fname[] = { " [DriveIsRemote]" };

BOOL DriveIsRemote(unsigned char  Drive)
{
  char x[20];
  char dir[80];
  struct REGPACK cpu;

  if ((Drive <= 26) && (Drive > 0))
    sprintf(x, "drive number %d", Drive );
  else {
    if (isalpha(Drive)) {
      sprintf(x, "drive %c:", Drive );
      Drive = toupper(Drive) - 'A' + 1;
    }
    else {
      if ((Drive == 0) || (Drive == ' ')) {
        strcpy(x,"current drive");
#ifdef _MSC_VER
        _getcwd(dir, 80);
#else
        getcwd(dir, 80);
#endif
        Drive = dir[0] - 'A' + 1;
      }
      else {
        itoa(Drive, x, 10);
        SetError(15, 3, "Invalid parameter: ", x, fname);
        return FALSE;
      }
    }
  }
  memset(&cpu, 0, sizeof(cpu)); // for Windows compatibility
  cpu.r_ax = 0x4409;
  cpu.r_bx = Drive;
  intr(0x21, &cpu);
  if (cpu.r_flags & 1) {
    SetError(cpu.r_ax, 3, "Error determining location of device: ", x, fname);
    return FALSE;
  }
  else
    return (cpu.r_dx & 0x1000) ? 1 : 0; // is remote if bit 12 is set
}
