/* filename: DISPSTAT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef WINDOWS

#include <stdio.h>
#ifdef _MSC_VER
#include <malloc.h>
#include <graph.h>
#else
#include <alloc.h>
#endif
#include <dos.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <share.h>
#include <parser.h>
#include <dbf.h>
#include <index.h>
#include <tzprint.h>

#define F1   ';'
#define F10  'D'
#define SF1  'T'
#define SF10 ']'
#define AF1  'h'
#define AF10 'q'
#define CF1  '^'
#define CF10 'g'

unsigned VideoSegment(void);

static unsigned char counter;
static unsigned char TotalScreenRows;
static int ESCPressed;
static char strON[] = { "ON " };
static char strOFF[] = { "OFF" };

static void CheckForPause(void)
{
#ifdef _MSC_VER
  struct _rccoord tp;
#endif
  EventRec e;

  ++counter;
  if (ConsoleOn && (counter > TotalScreenRows)) {
    printf(Press_any_key_to_continue);
    GetEvent(&e);
    if (e.WhichEvent == Mouse)
      ESCPressed = (e.v.sMouse.ButtonMask == RightButtonDown);
    else
      ESCPressed = (e.v.sKeyboard.Key == 0x1B);
    while (KeyPressed()) // clear keyboard buffer
      ReadKey();
    counter = 0;
#ifdef _MSC_VER
    tp = _gettextposition();
    _clearscreen(_GCLEARSCREEN);
    _settextposition((short) 1, tp.col);
#else
    gotoxy(1, wherey());
    clreol();
#endif
  }
}

static int PauseAndEsc(void)
{
  CheckForPause();
  return ESCPressed ? TRUE : FALSE;
}

static char * HotKey(char c, char *buf)
{
  register char t, *s;

  buf[0] = c;
  buf[1] = 0;
  if ((c >= F1) && (c <= F10)) {
    s = "F%d";
    t = F1;
  }
  if ((c >= SF1) && (c <= SF10)) {
    s = "Shift F%d";
    t = SF1;
  }
  if ((c >= AF1) && (c <= AF10)) {
    s = "Alt F%d";
    t = AF1;
  }
  if ((c >= CF1) && (c <= CF10)) {
    s = "Ctrl F%d";
    t = CF1;
  }
  sprintf(buf, s, c - t + 1);
  return buf;
}

static int WriteLnToAlt_Check(char *s)
{
  WriteToAlt("%s\n", s);
  return PauseAndEsc();
}

static int WriteToAltEmpty_Check(void)
{
  return WriteLnToAlt_Check("");
}

void DisplayStatus(void)
{
  int i;
  char j;
  char saveselected;
  char * SaveDisplay, *p;
  char TotalOpenFiles;
  int SaveConsoleOn;
#ifdef _MSC_VER
  struct _rccoord tp;
  short left, top, right, bottom;
#else
  char SaveX, SaveY;
  struct text_info wn;
#endif
  WorkAreaType *wa;
  dbfRecord    *r;
  char buf[20];
  long    seg;
#ifndef NDX_TYPE
  char SampleKey[101] = { 0 };
  char *(*fptr)(void);
#endif

  ESCPressed = FALSE;
  SaveDisplay = NULL;
  SaveConsoleOn = ConsoleOn;
  if (!PrintOn && !AlternateOn)
    ConsoleOn = TRUE;
  if (ConsoleOn) { // save the display first.
    seg = VideoSegment();
    if ((SaveDisplay = malloc(4000)) != NULL) {
      for (i=0; i < 4000; i++)
        SaveDisplay[i] = * (char *) MK_FP(seg, i);
#ifdef _MSC_VER
      tp = _gettextposition();
#else
      SaveX = wherex();
      SaveY = wherey();
#endif
      ClrScr();
    }
  }
  saveselected = Selected;
  counter = 0;
#ifndef _MSC_VER
  gettextinfo(&wn);
  TotalScreenRows = wn.winbottom - wn.wintop - 2;
#else
  _gettextwindow( &top, &left, &bottom, &right );
  TotalScreenRows = bottom - top - 2;
#endif
  TotalOpenFiles = 0;

  PushMouse();
  AddTarget(1, 1, 80, MaxAvailRows(), ReservedID, RightButtonDown);
  AddTarget(1, 1, 80, MaxAvailRows(), ReservedID, LeftButtonDown);
  EnableMouse();

  for (i = 0; i < MaxWorkAreas; i++) {
    if (saveselected == i) {
      WriteToAlt( "%s%d\n", Currently_selected_database, saveselected+1);
      if (PauseAndEsc())
        goto done;
    }
    if (WorkArea[i]) {
      wa = WorkArea[i];
      r = &wa->Handle;
      Select((unsigned char) (i+1));
      WriteToAlt("%s%2d%s%s\n", Workarea_number, i+1, Database_in_use, r->FileName);
      if (PauseAndEsc())
        goto done;
      WriteToAlt( "   Alias: %10s%s%ld of %ld", wa->Alias, Record_number, RecNo(), RecCount());
      if (dEOF()) {
        if (WriteLnToAlt_Check((RecCount() > 0) ? " (Past End of File)" : " (Empty File)"))
          goto done;
      }
      else
        if (WriteToAltEmpty_Check())
          goto done;
      if (!r->v.strue.LinkedList) {
        WriteToAlt( "   DOS File Handle: %d   File Access Mode: ", r->v.dFile);
        switch (r->Fmode) {
          case SH_DENYRW: p = " [Read/Write (non-sharable)]"; break;
          case SH_DENYNO: p = " [Read/Write (sharable)]"; break;
          default:        p = " [UNKNOWN]";
        }
        if (WriteLnToAlt_Check(p))
          goto done;
        ++TotalOpenFiles;
      }
      else {
        WriteToAlt( "   Linked List ");
        switch (r->v.strue.DataLoc) {
          case Heap: p = "on the Heap";  break;
          case Ems:  p = "in EMS (Expanded) memory"; break;
          case Ext:  p = "in Extended memory"; break;
          default:   p = "";
        }
        if (WriteLnToAlt_Check(p))
          goto done;
      }
      // hey, what about memo files?
      if (r->HasMemo) {
        ++TotalOpenFiles;
        WriteToAlt("   Memo file: ");
        if (WriteLnToAlt_Check(ReplaceExt(r->FileName,"DBT")))
          goto done;
      }
      // if index active then display the filename of the index
      if (IndexPresent) {
        if (IndexRoutines.IndexOpenFunc()) {
          if (r->Fmode >= 0x40)
            ++TotalOpenFiles; // count semaphore file if file is open sharable
          for (j = 0; j < MaxOrder; j++)
            if (strlen(IndexRoutines.IndexNameProc(j)) > 0) {
              ++TotalOpenFiles;
              WriteToAlt("%s%0d: %s\n", Index_number, j +1,
              IndexRoutines.IndexNameProc(j));
              if (PauseAndEsc())
                goto done;
              WriteToAlt("   Index Key Expression: ");
#ifdef NDX_TYPE
              WriteToAlt("\"%s\"\n", (Ind[i][j])->parser ?
              (Ind[i][j])->header.expression : "Key Maker Function");
              if (PauseAndEsc())
                goto done;
#else
              fptr = IndexRoutines.KeyMakerFunc(j);
              if (fptr)
                strcpy(SampleKey, fptr());
              WriteToAlt("%s%d%s\"%s\"\n",Key_length, strlen(SampleKey), Sample_key, SampleKey);
              if (PauseAndEsc())
                goto done;
              WriteToAlt(SortOrder);
              if (IndexRoutines.SortOrderFlag(j))
                p = " ASCENDING";
              else
                p = " DESCENDING";
              if (WriteLnToAlt_Check(p))
                goto done;
              if (IndexRoutines.SoundexFlag(j)) {
                if (WriteLnToAlt_Check(Soundex_Index))
                  goto done;
              }
#endif
            }
        }
      }
      if (wa->FilterFunc)
        if (WriteLnToAlt_Check(Filter_procedure_active))
          goto done;
      if (wa->FilterExprHandle) {
        WriteToAlt("%s: \"%s\"\n", Filter_procedure_active,
        ((ExprHandle)(wa->FilterExprHandle))->Expression );
        if (PauseAndEsc())
          goto done;
      }
      if (wa->WhileFunc) {
        if (WriteLnToAlt_Check(While_procedure_active))
          goto done;
      }
      if (wa->WhileExprHandle) {
        WriteToAlt("%s: \"%s\"\n", While_procedure_active,
        ((ExprHandle)(wa->WhileExprHandle))->Expression );
        if (PauseAndEsc())
          goto done;
      }
      if (wa->SyncProc)
        if (WriteLnToAlt_Check(Database_is_related_to_one_or_more_child_databases))
          goto done;
#ifdef NET
      if (wa->Exclusive)
        if (WriteLnToAlt_Check(Database_open_for_exclusive_use))
          goto done;
      WriteToAlt("   ");
      switch (wa->LockStatus) {
        case NotLocked: p = No_Locks_Active; break;
        case FileLocked: p = File_Locked; break;
        case AppendLocked: p = Append_Locked; break;
        case RecordLocked:
          WriteToAlt("%d", wa->LockCount);
          p = Locked_Records;
          break;
      }
      if (WriteLnToAlt_Check(p))
        goto done;
#endif
      if (WriteToAltEmpty_Check())
        goto done;
    }
  }
  if (HelpEnabled) {
    if (WriteLnToAlt_Check("Help is active:"))
      goto done;
    WriteToAlt("  Help file: %d\n", WorkArea[HelpWorkArea]->Handle.FileName);
    WriteToAlt("  Hot Key       : %s\n",HotKey(HelpContextHotKey, buf));
    WriteToAlt("  Authoring Key : %s\n",HotKey(HelpAuthoringHotKey, buf));
    WriteToAlt("  Topic Key     : %s\n",HotKey(HelpTopicHotKey, buf));
    if (PauseAndEsc())
      goto done;
  }
  Select((unsigned char) (saveselected+1));
  if (WriteToAltEmpty_Check())
    goto done;
  WriteToAlt("Memory Available = %lu\n", coreleft());
  if (PauseAndEsc())
    goto done;
  WriteToAlt("Console= %s  Talk   = %s  Deleted= %s\n",
  (SaveConsoleOn ? strON : strOFF), (TalkEnabled ? strON : strOFF),
  (IgnoreDel ? strON : strOFF));
  if (PauseAndEsc())
    goto done;
  WriteToAlt( "Safety = %s  Flush  = %s  Print  = %s\n",
  (SafetyOn ? strON : strOFF), (FlushEnabled ? strON : strOFF), (PrintOn ? strON : strOFF));
  if (PauseAndEsc())
    goto done;
  WriteToAlt("Alternate = %s", (AlternateOn ? strON : strOFF));
  if (AlternateOpen) {
    WriteToAlt("  Alternate file = %s", AlternateName);
    ++TotalOpenFiles;
  }
  if (WriteToAltEmpty_Check())
    goto done;
  WriteToAlt("Total DBF, DBT, NDX (or IND), @S@ and Alternate files open = %d\n",TotalOpenFiles);
  counter = 254;
  CheckForPause();

done:
  DisableMouse();
  PopMouse();
  Select((unsigned char) (saveselected+1));
  if (SaveDisplay) { // restore the display
    for (i=0; i < 4000; i++)
      *(char*) MK_FP(seg, i)  = SaveDisplay[i];
    free(SaveDisplay);
#ifdef _MSC_VER
    _settextposition(tp.row, tp.col);
#else
    gotoxy(SaveX,SaveY);
#endif
  }
  ConsoleOn = SaveConsoleOn;
}
#endif
