/* filename: DBF4LOW4.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sayget.h>
#include <dbf.h>

static char *BooleanNY[2] = {"N","Y"};

int bad_field_param(const char *funcname, int fieldno, int flag)
{
  char str[STRSIZ];

  if (NotInUseError(funcname))
    return 1;

  if ((fieldno > WorkArea[Selected]->Handle.NumFields) || (fieldno < flag)) {
    sprintf(str, "%s [%s(%d)]", Invalid_field_number, funcname, fieldno);
    SetError(InvalidParameter, 1, str);
    return 1;
  }
  else
    return 0;
}

char FieldType(int i)
{
  if (bad_field_param("FieldType", i, 1))
    return ' ';
  else
    return WorkArea[Selected]->Handle.Fields[i-1].Typ;
}

unsigned char FieldLen(int i)
{
  if (bad_field_param("FieldLen", i, 1))
    return 0;
  if (WorkArea[Selected]->Handle.Fields[i-1].Typ == 'D')
    return CenturyOn ? 10 : 8;
  else
    return WorkArea[Selected]->Handle.Fields[i-1].Len;
}

char FieldDec(int i)
{
  if (bad_field_param("FieldDec", i, 1))
    return 0;
  else
    return WorkArea[Selected]->Handle.Fields[i-1].Dec;
}

void * FieldAddress(int i)
{
  void * address, *lastaddress;
  int x;
  WorkAreaType *wa;
  dbfRecord    *r;
  FieldRecord  *f;

  wa = WorkArea[Selected];
  r = &wa->Handle;
  if (bad_field_param("FieldAddr", i, 0))
    return NULL;
  if (i == 0)
    return wa->UserRec;
  address = wa->UserRec;
  ++((int *) address);   // advance the pointer
  for (x = 0; x < i; ++x) {
    lastaddress = address;
    f = &r->Fields[x];
    switch (f->Typ) {
      case 'C':     // character field -- convert to string
        (char *) address += (f->Len+1);
        break;
      case 'D':     // date field -- convert from 8 chars to string[10]
        (char *) address += 11;
        break;
      case 'L':
        ++((int *) address);
        break;
      case 'M':
        ++((long *) address);
        break;
      case 'N':
      case 'F':
        if (f->Dec > 0)   // convert to a real
          ++((double *) address);
        else   // no decimals, so it must be an int
          ++((long *) address);
        break;
    }
  }
  return lastaddress;
}

char * SField(int i) // returns a formatted string of the data,
                     // ready to display used by Browse for field displays
{
  void * p;
  static char temp[25];

  p = FieldAddress(i);
  switch (FieldType(i)) {
    case 'C':
    case 'D':
      return (char *)p;
    case 'L':
      return (*((char *) p)) ? BooleanNY[1] : BooleanNY[0];
    case 'N':
    case 'F':
      if (FieldDec(i)) {
        sprintf(temp,"%*.*lf",FieldLen(i),FieldDec(i), *((double *) p));
        // if the decimal symbol is not '.', then replace it
        if (DecimalSymbol != '.')
          *(strchr(temp, '.')) = DecimalSymbol;
      }
      else
        sprintf(temp,"%*ld",FieldLen(i),*((long *) p));
      return temp;
    case 'M':
      return (*((long *) p)) ? "MEMO" : "memo";
  }
  return NULL;
}

BOOL Deleted(void)
{
  if (NotInUseError("Deleted()"))
    return 0;
  return *((char *) WorkArea[Selected]->UserRec);
}

char *Field(int i)
{
  char str[STRSIZ];

  if (!NotInUseError("Field()")) {
    if (i <= WorkArea[Selected]->Handle.NumFields)
      return WorkArea[Selected]->Handle.Fields[i-1].Name;
    sprintf(str, "%s [Field(%d)]", Invalid_field_number, i);
    SetError(InvalidParameter, 1, str);
  }
  return "";
}

int FieldNo(const char * fieldname)
{
  int nf, i;
  dbfRecord *r;
  char tmp[20];

  if (!NotInUseError("FieldNo()")) {
    strncpy(tmp, Trim(fieldname), 19);
    tmp[19] = 0;
    UpperCase(tmp);
    r =  &WorkArea[Selected]->Handle;
    nf = r->NumFields;
    for (i = 0; i < nf; ++i)
      if (!strcmp(r->Fields[i].Name, tmp))
        return i+1;
  }
  return 0;
}

int FieldCount(void)
{
  if (NotInUseError("FieldCount()"))
    return 0;
  else
    return WorkArea[Selected]->Handle.NumFields;
}
