/* filename: DBF4LOW2.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <dos.h>
#include <io.h>
#include <dbf.h>

extern char ValidTypes[];

void UpdateHeader(dbfRecord * d)
{
  struct dosdate_t t;
  char *hp;

  hp = d->HeadProlog;

  _dos_getdate(&t); // get system date
  if (hp[0] == DB2File) {
    hp[5] = t.year - 1900;
    hp[3] = t.month;
    hp[4] = t.day;
    * (unsigned *) (hp+1) = (unsigned) d->NumRecs;
  }
  else {
    hp[1] = t.year - 1900;
    hp[2] = t.month;
    hp[3] = t.day;
    * (long *) (hp+4) = d->NumRecs;
  }
  lseek(d->v.dFile, 0L, SEEK_SET); // go to top of file where header is
  if (write(d->v.dFile, hp, 8) != 8)
    DBFError = errno;
  if (AutoHalt && DBFError)
    OnErrorHalt();
}

void CloseDbf(dbfRecord * d)
{
  char TFilename[STRSIZ];
  char EofMark  = 0x1A;
  int temp;

  DBFError = 0;
  if (d->v.strue.LinkedList) {
    d->v.strue.Action = doCloseLL;
    LLRoutines(d);
  }
  else {
    strcpy(TFilename, d->FileName);
    if ((d->dStatus == Updated) || (d->dStatus == Appended)) {
      UpdateHeader(d);
      if ((DBFError == 0) && (d->dStatus == Appended)) { // goto end of file
        lseek(d->v.dFile, d->HeadLen+d->NumRecs*d->RecLen, SEEK_SET);
        if (write(d->v.dFile, &EofMark, 1) != 1) // just the deleted flag
          DBFError = errno;
      }
    } // attempt to close the file regardless of any errors that might have occured
    temp = close(d->v.dFile);
    if (!DBFError)
      DBFError = temp;
    d->dStatus = NotOpen;
    FreePtrClear((void*) &d->CurRecord); // free memory even if an error has occured
    FreePtrClear((void*) &d->Fields);
    if (DBFError)
      SetError(DBFError,6,File_colon," ",d->FileName," [CloseDbf(", TFilename, ")]");
  }
}
