/* filename: DBF4LOW1.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <CTYPE.H>
#include <io.h>
#include <dos.h>
#include <dbf.h>

void UpdateHeader(dbfRecord * d);

#ifndef WINDOWS

static int *BIOSTimerTicks = (int *) MK_FP(0x0040,0x006C);
static char Rotor  = 0;
static char RotorSymbol[4]  = {'\x10', '\x1F', '\x11', '\x1E'};
static int LastTick  = 0;

void SetRotorSymbols(char s1, char s2, char s3, char s4)
{
  RotorSymbol[0] = s1;
  RotorSymbol[1] = s2;
  RotorSymbol[2] = s3;
  RotorSymbol[3] = s4;
}

void AdvanceRotor(void)
{
  if (RotorEnabled) {
    if (*(int*) BIOSTimerTicks == *(int*) &LastTick)
      return; // don't turn faster than 5 rps (300 rpm)
    Rotor &= 0x03;
    *RotorPointer = RotorSymbol[Rotor++];
    LastTick = *BIOSTimerTicks;
  }
}
#endif

#ifndef _MSC_VER
#pragma argsused
#endif
void FlushFile(int handle)
{
#ifndef WINDOWS
  union REGS inregs;

  if (FlushEnabled) {
    inregs.h.ah = 0x68;
    inregs.x.bx = handle;
    intdos(&inregs, &inregs);
  }
#endif
}

void GetDbfRecord(dbfRecord  *d, long RecNum)
{
  char str[STRSIZ];

  if ((unsigned long) RecNum > (unsigned long) d->NumRecs) {
    sprintf(str, "%s%ld (%s) [GetDbfRecord]", Invalid_record_number, RecNum,
      d->FileName);
    SetError(OutOfRange, 1, str);
    return;
  }
#ifndef WINDOWS
  AdvanceRotor();
  if (ProgressPtr) // if PROGRESS is set on, then call the progress routine in DIALOG
    ProgressPtr();
#endif
  d->EOFile = FALSE;
  d->BOFile = FALSE;
  if (d->v.strue.LinkedList) {
    d->v.strue.Action = doGetLL;
    d->v.strue.TargetRecNo = RecNum;
    LLRoutines(d);
    return;
  }
  lseek(d->v.dFile, d->HeadLen+(RecNum-1)*d->RecLen, SEEK_SET);
  if ((unsigned) read(d->v.dFile, d->CurRecord, d->RecLen) != d->RecLen) {
    DBFError = PartialRead;
    d->EOFile = TRUE;
  }
  else
    d->CurRecNo = RecNum; // keep track of number of last record read
  // if the file is encrypted, call the decryption function
  if (d->DecryptProc)
    d->DecryptProc(d->CurRecord+1, d->RecLen-1); // leave Deleted flag as is
}

void FlushAfterAppend(dbfRecord * d)
{
  char EofMark  = 0x1A;

  DBFError = 0; // FlushAfterAppend
  if ((d->dStatus == Updated) || (d->dStatus == Appended)) {
    UpdateHeader(d);
    if ((!DBFError) && (d->dStatus == Appended)) { // goto end of file
      lseek(d->v.dFile, d->HeadLen+(d->NumRecs*d->RecLen), SEEK_SET);
      DBFError = !(write(d->v.dFile, &EofMark, 1) == 1); // Write EOF marker
    }
  }
  d->dStatus = NotUpdated;
  if (!DBFError)
    FlushFile(d->v.dFile); // flush dos buffers to disk
}

void PutDbfRecord(dbfRecord * d, long RecNum)
{
  int appending;

  if ((RecNum > d->NumRecs)) {
    RecNum = d->NumRecs + 1; // append this record
    appending = TRUE;
  }
  else
    appending = FALSE;
#ifndef WINDOWS
  AdvanceRotor();
#endif
  if (d->v.strue.LinkedList) {
    d->v.strue.Action = doPutLL;
    d->v.strue.TargetRecNo = RecNum;
    LLRoutines(d);
    return;
  }
  if (d->EncryptProc)
    d->EncryptProc(d->CurRecord+1, d->RecLen-1); // leave Deleted flag as is
  lseek(d->v.dFile, d->HeadLen+((RecNum-1)*d->RecLen), SEEK_SET);
  if ((unsigned) write(d->v.dFile, d->CurRecord, d->RecLen) != d->RecLen)
    DBFError = errno;
  if (appending) { // header and EOF mark will be written upon close
    d->NumRecs = d->CurRecNo = RecNum; // keep track of current record number
    d->dStatus = Appended;
    if (FlushEnabled)
      FlushAfterAppend(d); // make sure header is updated
  }
  else { // only write header (no EOF mark) to disk upon close
    if (d->dStatus != Appended) // don't wipe out appended status flag
      d->dStatus = Updated;
    if (!DBFError && FlushEnabled)
      FlushFile(d->v.dFile);
  }
  if (d->DecryptProc)
    d->DecryptProc(d->CurRecord+1, d->RecLen-1); // leave Deleted flag as is
  if (DBFError)
    SetError(DBFError, 4, File_colon, " ", d->FileName,
    " [Replace/Append/PutDbfRecord]");
}


// now only replaces the deleted flag, future version will write individual fields
#ifdef _MSC_VER
#else
#pragma argsused // FieldNo is used for future release
#endif
void PutDbfField(dbfRecord * d, long RecNum, char FieldNo)
{
  int appending;

  if (RecNum > d->NumRecs) {
    RecNum = d->CurRecNo = ++d->NumRecs;
    appending = TRUE;
  }
  else
    appending = FALSE;
  DBFError = 0;
  lseek(d->v.dFile, d->HeadLen+((RecNum-1)*d->RecLen), SEEK_SET);
  if (write(d->v.dFile, d->CurRecord, 1) != 1)
    DBFError = errno;
  else
    if (FlushEnabled)
      FlushFile(d->v.dFile);

  if (appending) // header and EOF mark will be written upon close
    d->dStatus = Appended;
  else // only write header (no EOF mark) to disk upon close
    if (d->dStatus != Appended) // don't wipe out appended status flag
      d->dStatus = Updated;
  if (DBFError)
    SetError(DBFError, 4, File_colon, " ", d->FileName,
    " [DeleteRec/RecallRec]");
}

void AppendDbf(dbfRecord * d)
{
  PutDbfRecord(d, d->NumRecs + 1);
}
