/* filename: CREATDBF.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <dos.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <share.h>
#include <io.h>
#include <dbf.h>

extern int FileMode;
extern char ValidTypes[80];
extern char CustomFileID;
extern char CustomFileWithMemo;
extern int CreateMemoType;

#define MEMOBLOCKSIZE 512

static char far funcname[] = { " [CreateDbf]" };

static void MakeHeader(char* Header, dbfRecord * d, FieldRecord * f)
{
  char * FD;
  FieldRecord *lf;
  int i;

  Header[d->HeadLen] = 0x0D;
  ++d->HeadLen;
  *((int*)(Header+8)) = d->HeadLen;
  d->RecLen = 1; // deleted flag constitutes byte number zero
  for (i = 0; i < d->NumFields; i++) {
    lf = &f[i];
    FD = Header + ((i+1)<<5);
    // make sure field name is upper case
    strupr(lf->Name);
    memcpy(FD, lf->Name, 10);
    FD[10] = 0;
    // make sure TYPe is upper case
    lf->Typ = toupper(lf->Typ);
    FD[11] = lf->Typ;

    switch (lf->Typ) { // make sure of standard sizes
      case 'L': lf->Len =  1; break;
      case 'M': lf->Len = 10; break;
      case 'D': lf->Len =  8; break;
      case 'C':
      case 'N':
        if (lf->Len == 0)
          DBFError = InvalidField;
    }
    FD[16] = lf->Len;
    if ((lf->Typ != 'N') && (lf->Typ != 'F'))
      lf->Dec = 0;
    FD[17] = lf->Dec;
    d->RecLen += lf->Len; // calculate new record length
    if (!strchr(ValidTypes, lf->Typ) || !lf->Typ)
      DBFError = InvalidField;
    if (lf->Typ == 'M')
      d->HasMemo = CustomFileID ? CustomFileWithMemo : CreateMemoType;
    if (DBFError)
      break;
  }
  if (CustomFileID) {
    *Header = d->HasMemo ? d->HasMemo : CustomFileID;
  }
  else
    *Header = d->HasMemo ? d->HasMemo : DB4File;
  *((int*)(Header+10)) = d->RecLen;
}

void CreateDbf(dbfRecord * d, const char * NewName, int fieldcount,
               FieldRecord * Structure)
{
  struct {
    long next_free_block;
    long size_cur_block;
    char filename[9];
    char reserved_1;
    int  version;
    int  block_size;
    char encrypt;
    char reserved_2;
  } memo_header;

  char * Header = NULL;
  char const *ptr;
  int    i;
  char   memobuffer[MEMOBLOCKSIZE+1];
  FILE * Memofile;
  char   Memofilename[80];
  char   dir[80], memoshortname[20], ext[10];
  struct dosdate_t t;

  _dos_getdate(&t); // get system date

  memset(d, 0, sizeof(dbfRecord));

  d->NumFields = fieldcount;
  d->HeadLen = (fieldcount + 1) << 5; // ie *32
  if ((Header = malloc(d->HeadLen+1)) == NULL)
    goto nomem;
  memset(Header, 0, d->HeadLen+1);

  DBFError = 0;
  MakeHeader(Header, d, Structure);
  strcpy(d->FileName, AddExt(NewName,"DBF"));
  if (DBFError) {
    SetError(DBFError, 2, d->FileName, funcname);
    return;
  }
  if ((d->v.dFile = sopen(d->FileName, O_RDWR | O_BINARY | O_TRUNC | O_CREAT,
  FileMode, S_IREAD | S_IWRITE)) != -1) {
    if (write(d->v.dFile, Header, d->HeadLen+1) != (d->HeadLen+1))
      DBFError = errno;
  }
  else
    DBFError = errno;
  if (DBFError) {
    ptr = NewName;
    goto bailout;
  }
  else {
    d->dStatus = Appended; // force an EOF mark to be written to disk
    d->NumRecs = 0;
    memcpy(d->HeadProlog, Header, sizeof(d->HeadProlog));
    sprintf(d->LastUpdate,  "%02d/%02d/%02d", t.month, t.day, t.year -
    ((t.year > 1999) ? 2000 : 1900));
    if ((d->CurRecord = (char *)malloc(d->RecLen)) == NULL)
      goto nomem;
    memset(d->CurRecord, ' ', d->RecLen);
    i = d->NumFields * sizeof(FieldRecord);
    if ((d->Fields = (FieldRecord *)malloc(i)) == NULL)
      goto nomem;
    memcpy(d->Fields, Structure, i);
    CloseDbf(d);
    // now let's deal with memo if any
    if (d->HasMemo) {
      ptr = Memofilename;
      strcpy(Memofilename, ReplaceExt(d->FileName,"DBT"));
      FSplit(Memofilename, dir, memoshortname, ext);
      if ((Memofile = _fsopen(Memofilename, "wb+", FileMode)) == NULL) {
        goto bailout;
      }
    }
    if (d->HasMemo == DB4WithDB3Memo) {
      memset(memobuffer, 0, sizeof(memobuffer));
      *memobuffer = 1; // one 512 byte block in file by default
      memobuffer[MEMOBLOCKSIZE] = 0x1A; // end block with ^z character
      if (fwrite(memobuffer, sizeof(memobuffer), 1, Memofile) != 1)
        goto close_bailout;
    }
    if (d->HasMemo == DB4WithDB4Memo) {
      memset(&memo_header, 0, sizeof(memo_header));
      strcpy(memo_header.filename, memoshortname);
      memo_header.next_free_block = 1;
      memo_header.version = 0x102;
      memo_header.block_size = MEMOBLOCKSIZE;
      if (fwrite(&memo_header, sizeof(memo_header), 1, Memofile) != 1)
        goto close_bailout;
    }
    if (d->HasMemo)
      fclose(Memofile);
    errno = 0;
  }
  FreePtrClear((void*) &Header);
  return;

close_bailout:
  fclose(Memofile);

bailout:
  FreePtrClear((void*) &Header);
  SetError(DBFError, 3, Error_writing, ptr, funcname);
  return;

nomem:
  SetError(217, 3, Not_enough_memory_to_create, NewName, funcname);
  return;
}
