/* filename: COPYFILE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <io.h>
#ifdef _MSC_VER
#include <sys\types.h>
#include <sys\utime.h>
#include <malloc.h>
#else
#include <alloc.h>
#endif
#include <fcntl.h>
#include <sys\stat.h>
#include <share.h>
#include <errno.H>
#ifdef WINDOWS
#include <windows.h>
#endif
#include <dbf.h>

#define MinimumBufferSize 4096

void CopyFile(const char * source, const char * dest)
{
  void   *Buffer;
  FILE   *s, *d;
  size_t BufferSize, count;
#ifdef _MSC_VER
  struct _stat ft;
#else
  struct ftime ft;
#endif
  char fname[STRSIZ];

  DBFError = 0;
  sprintf(fname, " [CopyFile(%s,%s)]", source, dest);
  BufferSize = 0xFFE8;
  while ((Buffer = malloc(BufferSize)) == NULL) {
    BufferSize -= MinimumBufferSize/2;
    if (BufferSize < MinimumBufferSize) {
      SetError(217, 3, Minimum_free_memory_required, " 4096 bytes.", fname);
      return;
    }
  }
  if ((s = _fsopen(source, "rb", (FileModeOverride != -1) ? FileModeOverride : DbfFileMode))== NULL) {
    free(Buffer);
    SetError(104, 3, Error_reading, source, fname);
    return;
  }
#ifdef _MSC_VER
  _fstat(fileno(s), &ft);
#else
  getftime(fileno(s), &ft);
#endif
  if ((d =  fopen(dest, "wb"))== NULL) {
    free(Buffer);
    SetError(105, 3, Error_writing, dest, fname);
    return;
  }

  while (!feof(s)) {
    count = fread(Buffer, 1, BufferSize, s);
    DBFError = ferror(s);
    if (!DBFError) {
      fwrite(Buffer, 1, count, d);
      if (ferror(d)) {
        SetError(101, 3, Error_writing, dest, fname);
        break;
      }
    }
    else {
      SetError(errno, 3, Error_reading, source, fname);
      break;
    }
  }
  free(Buffer);
  fclose(s);
  if (!DBFError)
#ifdef _MSC_VER
    _utime(source, (struct _utimbuf *) &ft.st_atime);
#else
    setftime(fileno(d), &ft);
#endif
  fclose(d);
  errno = 0;
}
