/* filename: COPY2SDF.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#ifdef WINDOWS
#include <windows.h>
#endif
#include <sayget.h>
#include <dbf.h>

#define no_Quote NULL
#define C_STR    0
#define P_STR    1

void CheckHiBitChars(char * s, char * overflow);

static char *Buffer;
static int   BufferIndex;

char   MergeID = 0;
void (* UsersCleanUpProc)(void) = NULL;

static void StuffBuffer(const char * s, int str_type)
{
  int l;

  if (s) {
    l = str_type ? s[0] : strlen(s);
    if (l)
      if (l < (4096 - BufferIndex)) {
        if (str_type) // Pascal-like string, may contain zeroes inside
          memcpy(&Buffer[BufferIndex], s + 1, l);
        else
          strcpy(&Buffer[BufferIndex], s);
        BufferIndex += l;
      }
  }
}

static int AdjustedSize(void)
{
  unsigned i;
  int total = 0;

  for (i = 1; i <= (unsigned) FieldCount(); i++) {
    switch (FieldType((char) i)) {
      case 'D':
        total += 3;
        break;
      case 'M':
        total -= 6;
        break;
    }
  }
  return total;
}

int AskToOverwrite(const char *_fn)
{
#ifndef WINDOWS
  char YN[] = { "NYny" };
  char    Answer;
#else
  char s[81];
#endif

  if (SafetyOn && FileExists(_fn)) { //  ask for confirmation
#ifdef WINDOWS
    sprintf(s, "%s%s", Overwrite_file, _fn);
    if (WDialogBox(s, "", MB_OKCANCEL | MB_ICONQUESTION) == IDCANCEL)
      return 0;
#else
    printf("\n%s%s%s", Overwrite_file, _fn, question_y_n);
    do {
      Answer = getch();
    }  while (!(strchr(YN, Answer) && (Answer != 0)));
    if (toupper(Answer) == 'N')
      return 0;
#endif
  }
  return 1;
}

static  unsigned char _tzfar wp51header[] = // pre-amble to field list
     { 255, 'W', 'P', 'C', 26, 0, 0, 0, 1, 10, 0, 1, 0, 0, 0, 0, 251,
       255, 0, 0, 0, 0, 0, 0, 0, 0, 222, 98, 4, 0, 4, 0, 98, 222 };
static unsigned char _tzfar wp51tail[] = // last ~,post-amble, and pagebreak
     { '~', 222, 52, 6, 0, 0, 0, 6, 0, 52, 222, 12 };
static unsigned char _tzfar wpA_MergeChars[] = { 2, 18, 10 };
static unsigned char _tzfar wpA_EORChars[] = { 2, 5, 10 };
static unsigned char _tzfar wpB_MergeChars[] = { 9, 222, 49, 4, 0, 4, 0, 49, 222, 10 };
static unsigned char _tzfar wpB_EORChars[] = { 11, 222, 52, 6, 0, 9, 0, 6, 0, 52, 222, 212 };

void CopyToSDF(const char * fn)
{
  FILE * f;
  PathStr _fn;
  unsigned RecordSize;
  char ControlZ = '\x1A';
  int Delimited = FALSE;
  int i, j;
  char s[STRSIZ], OverFlow[STRSIZ], ProcName[STRSIZ];
  unsigned  SDFRecordSize;
  WordProcessorType WP;
  dbfRecord*h;
  char *sptr;
  unsigned char CRLF[] = { 13, 10 };
  unsigned char le_MergeChars[] = { 1, '\\' };
  unsigned char def_MergeChars[] = { 1, ',' };
  unsigned char def_EORChars[] = { 2, 10, 13 };
  unsigned char def_Quote[] = { 1, '"' };
  unsigned char *pQuote = def_Quote, *pMergeChars = def_MergeChars,
  *pEORChars = def_EORChars;

  sprintf(ProcName, (MergeID ? " [CopyToMerge(%s)]" : " [CopyToSDF(%s)]"), fn);
  h = &WorkArea[Selected]->Handle;
  DBFError = 0;
  if (NotInUseError(ProcName))
    return;
  // check for the DELIMITED clause..this tells us to write a space between eachfield
  strcpy(_fn, Upper(Trim(fn)));
  sptr = strstr(_fn, "DELIMITED");
  if (sptr) {
    Delimited = TRUE;
    *sptr = 0;
  }
  strcpy(_fn, AddExt(Trim(_fn), "TXT"));

  if (AskToOverwrite(_fn) == FALSE)
    return;

  if ((f = _fsopen(_fn, "wb", DbfFileMode)) == NULL) {
    SetError(errno, 1, ProcName);
    return;
  }
  RecordSize = h->RecLen - 1; // take off 1 for the delete byte
  if (Delimited)
    SDFRecordSize = RecordSize + FieldCount() + 1 + AdjustedSize();
  if (MergeID > 0) {
    WP = (WordProcessorType)(MergeID - 1);
    pQuote = no_Quote;
    switch (WP) {
      case WordPerfectA:
        pMergeChars = wpA_MergeChars;
        pEORChars = wpA_EORChars;
        break;
      case WordPerfectB:
        pMergeChars = wpB_MergeChars;
        pEORChars = wpB_EORChars;
        break;
      case LeadingEdge:
        pMergeChars = le_MergeChars;
        break;
    }
    SDFRecordSize = RecordSize + (pQuote == NULL ? 0 : 2*FieldCount()*pQuote[0])
    + pMergeChars[0] + pEORChars[0] + AdjustedSize();
    if (WP == WordPerfectB) {// write the WP5.1 header
      if (fwrite(wp51header, sizeof(wp51header), 1, f) != 1)
        goto bailout;
      // write the field name list
      for (i = 1; i <= FieldCount(); i++) {
        sprintf(s, "%s~", Field(i));
        if (fwrite(s, strlen(s), 1, f) != 1)
          goto bailout;
      }
      if (fwrite(wp51tail, sizeof(wp51tail), 1, f) != 1)
        goto bailout;
    }
    if (WP == MSWord) { // for MSWord, write the field list, comma delimited, no quotes
      for (i = 1; i <= FieldCount(); i++) {
        strcpy(s, Field(i));
        if (i != FieldCount())
          strcat(s, ",");
        if (fwrite(s, strlen(s), 1, f) != 1)
          goto bailout;
      }
      fwrite(&CRLF, sizeof(CRLF), 1, f);
    }
  }
  if (Delimited || MergeID) { // allocate a buffer for block writing
    if ((Buffer = (char *)malloc(SDFRecordSize)) == NULL) {
      SetError(InsufficientMemory, 1, ProcName);
      fclose(f);
      return;
    }
  }
  // start at current record position in file, DON'T re-position to top
  while (!dEOF()) { // filters and while's supported
    if (!Delimited && !MergeID) {
      if (fwrite(&h->CurRecord[1], RecordSize, 1, f) != 1)
        goto bailout;
      if (fwrite(&CRLF, sizeof(CRLF), 1, f) != 1)
        goto bailout;
    }
    else { // deal with delimiter, or merge output
      BufferIndex = 0;
      if (UsersCleanUpProc)
        UsersCleanUpProc();
      for (i = 1; i <= FieldCount(); i++) {
        OverFlow[0] = 0;
        switch (FieldType(i)) {
          case 'D':
            strcpy(s, (const char *)FieldAddress(i));
            break;
          case 'M':
            strcpy(s, (*((long *) FieldAddress(i)) ? "MEMO" : "memo"));
            break;
          default:
            if (!UsersCleanUpProc) { // get the data straight from the dBASE buffer
              j = i - 1;  // do not ever remove this line
              memcpy(s, &h->CurRecord[h->Fields[j].Off], h->Fields[j].Len);
              s[h->Fields[j].Len] = 0;
              strcpy(s, Trim(s));
            }
            else { // the CleanUp proc may have modified things..get the data from the C buffer
              switch (FieldType(i)) {
                case 'C':
                  strcpy(s, Trim((const char *)FieldAddress(i)));
                  break;
                case 'N':
                  if (FieldDec(i) == 0) // longint to string
                    ltoa(*((long *) FieldAddress(i)), s, 10);
                  else // real to string
                    sprintf(s, "%*.*f", FieldLen(i), FieldDec(i), *((double *) FieldAddress(i)));
                  break;
                case 'L':
                  strcpy(s, (*((char *) FieldAddress(i))) ? "T" : "F");
                  break;
              }
            }
            if ((WP == WordPerfectA) || (WP == WordPerfectB))
              // check the string for hi bit chars..if so, they must be written
              // with special codes frames between C0s
              CheckHiBitChars(s, OverFlow);
            break;
        }
        if (MergeID == 0) {
          StuffBuffer(s, C_STR);
          StuffBuffer(" ", C_STR);
        }
        else {
          StuffBuffer((char *) pQuote, P_STR);
          StuffBuffer(s, C_STR);
          StuffBuffer(OverFlow, C_STR);
          StuffBuffer((char *) pQuote, P_STR);
          StuffBuffer((char *) pMergeChars, P_STR);
        }
      }
      if (MergeID == 0)
        --BufferIndex;
      else
        if (WP != WordPerfectB)
          BufferIndex -= pMergeChars[0];
      StuffBuffer((char *) pEORChars, P_STR);
      if (fwrite(Buffer, --BufferIndex, 1, f) != 1)
        goto bailout;
    }
    Skip(1);
  }
  if (Delimited || MergeID)
    free(Buffer);
  if (!MergeID || !((MergeID - 1) == WordPerfectA) || !((MergeID - 1) == WordPerfectB)) {
    if (fwrite(&ControlZ, 1, 1, f) != 1)
      goto bailout;
  }
  fclose(f); // we leave the dbf at eof!
  return;

bailout:
  SetError(errno, 1, ProcName);
  fclose(f);
}
  
