/* filename: CLOSEHGH.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <dbf.h>

void CheckActualRecCount(void);

void CloseHighLevel(void)
{
  WorkAreaType *wa;

  wa =  WorkArea[Selected];
  if (wa) {
    if (IndexPresent) // close any related indexes
      if (IndexRoutines.IndexOpenFunc()) // close all the indexes
        IndexRoutines.CloseSelectedProc(); // no parameter
#ifdef NET
    CheckActualRecCount(); // to make sure we write the correct value upon close
    Unlock(); // unlock any existing locks on this file first!
    FreePtrClear((void*) &wa->SwapBuffer);
#endif
    if ((wa->Handle.HasMemo) && (MemoRoutines._CloseMemoFile != NULL))
      MemoRoutines._CloseMemoFile();

    if(!wa->Deallocate) // the file was using an "untyped" buffer
      ClearRecord();

    CloseDbf(&wa->Handle); // close currently open file

    //  if we created the userrec buffer then get rid of it
    if (wa->Deallocate)  // the file was using an "untyped" buffer
      free(wa->UserRec);

    if (ParserRoutines.DisposeExprProc) {
      if (wa->FilterExprHandle)
        ParserRoutines.DisposeExprProc(&wa->FilterExprHandle);
      if (wa->WhileExprHandle)
        ParserRoutines.DisposeExprProc(&wa->WhileExprHandle);
    }

    FreePtrClear((void*) &WorkArea[Selected]);
  }
}
