/* filename: CHCKHIBT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <dbf.h>

static unsigned char _tzfar WPHiBitTable[254] = {
  0x26, 0x1, 0x47, 0x1, 0x29, 0x1, 0x1D, 0x1, 0x1F, 0x1, 0x21, 0x1,
  0x23, 0x1, 0x27, 0x1, 0x2B, 0x1, 0x2D, 0x1, 0x2F, 0x1, 0x35, 0x1,
  0x33, 0x1, 0x37, 0x1, 0x1E, 0x1, 0x22, 0x1, 0x28, 0x1, 0x25, 0x1,
  0x24, 0x1, 0x3D, 0x1, 0x3F, 0x1, 0x41, 0x1, 0x45, 0x1, 0x49, 0x1,
  0x8B, 0x1, 0x3E, 0x1, 0x46, 0x1, 0x13, 0x4, 0x0B, 0x4, 0x0C, 0x4,
  0x0D, 0x4, 0x0E, 0x4, 0x1B, 0x1, 0x31, 0x1, 0x3B, 0x1, 0x43, 0x1,
  0x39, 0x1, 0x38, 0x1, 0x0F, 0x4, 0x10, 0x4, 0x08, 0x4, 0x10, 0x5,
  0x14, 0x6, 0x11, 0x4, 0x12, 0x4, 0x07, 0x4, 0x09, 0x4, 0x0A, 0x4,
  0x00, 0x3, 0x01, 0x3, 0x02, 0x3, 0x09, 0x3, 0x10, 0x3, 0x28, 0x3,
  0x2C, 0x3, 0x23, 0x3, 0x1F, 0x3, 0x1B, 0x3, 0x14, 0x3, 0x16, 0x3,
  0x17, 0x3, 0x24, 0x3, 0x20, 0x3, 0x0B, 0x3, 0x0D, 0x3, 0x11, 0x3,
  0x0F, 0x3, 0x0E, 0x3, 0x08, 0x3, 0x12, 0x3, 0x26, 0x3, 0x2A, 0x3,
  0x18, 0x3, 0x15, 0x3, 0x1C, 0x3, 0x1A, 0x3, 0x19, 0x3, 0x13, 0x3,
  0x1D, 0x3, 0x2D, 0x3, 0x29, 0x3, 0x2B, 0x3, 0x27, 0x3, 0x25, 0x3,
  0x21, 0x3, 0x1E, 0x3, 0x22, 0x3, 0x2E, 0x3, 0x2F, 0x3, 0x0C, 0x3,
  0x0A, 0x3, 0x03, 0x3, 0x07, 0x3, 0x04, 0x3, 0x06, 0x3, 0x05, 0x3,
  0x01, 0x8, 0x17, 0x1, 0x06, 0x8, 0x21, 0x8, 0x24, 0x8, 0x25, 0x8,
  0x19, 0x8, 0x29, 0x8, 0x2C, 0x8, 0x10, 0x8, 0x32, 0x8, 0x09, 0x8,
  0x13, 0x6, 0x2D, 0x8, 0x0B, 0x8, 0x10, 0x6, 0x0E, 0x6, 0x01, 0x6,
  0x03, 0x6, 0x02, 0x6, 0x00, 0x7, 0x01, 0x7, 0x08, 0x6, 0x0D, 0x6,
  0x24, 0x6, 0x1F, 0x6, 0x20, 0x6, 0x04, 0x7, 0x15, 0x4, 0x14, 0x4,
  0x02, 0x4
};

void CheckHiBitChars(char * s, char * overflow)
{
  char Temp[512];
  int i, TempI;
  unsigned char *p;

  TempI = 0;
  for (i = 0; s[i] != 0; i++) {
    if ((unsigned char) s[i] > 127) {
      Temp[TempI] = '\xC0';
      p = WPHiBitTable + (((unsigned char) s[i] - 128) << 1);
      Temp[TempI + 1] = *(p+1);
      Temp[TempI + 2] = *p;
      Temp[TempI + 3] = '\xC0';
      TempI += 4;
    }
    else {
      Temp[TempI] = s[i];
      TempI++;
    }
  }
  if (TempI < 256) {
    Temp[TempI] = 0;
    strcpy(s, Temp);
    overflow[0] = 0;
  }
  else {
    strncpy(s, Temp, 255);
    s[255] = 0;
    TempI -= 255;
    strncpy(overflow, Temp+255, TempI);
    overflow[TempI] = 0;
  }
}
  
