/* filename: APFRMSDF.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <string.h>
#include <stdlib.h>
#include <dbf.h>

void ExportData(void);

static char far funcname[] = { " [AppendFromSDF]" };

void AppendFromSDF(const char * fn, int (*ValidFunc)(void))
{
  FILE * f;
  char *err;
  unsigned RecordSize, CRLF;
  long NumberOfRecords, i;
  char LastByte;
  int IndexOpen, OkToAppend;
  struct stat st;
  WorkAreaType *wa;
  dbfRecord    *r;

  wa = WorkArea[Selected];
  r = &wa->Handle;
  DBFError = 0;
  if (NotInUseError(funcname))
    return; // first step..is a file open and selected?
#ifdef NET // next, check that file is opened exclusive
  if (MultiUser)
    if (!wa->Exclusive && (wa->LockStatus != FileLocked)) { // access denied
      SetError(5, 4, File_must_be_locked, to_append, r->FileName, funcname);
      return;
    }
#endif
  if ((f = _fsopen(AddExt(Trim(fn),"TXT"), "rb+", FileMode)) == NULL) {
    SetError(errno, 2, fn, funcname);
    return;
  }
  RecordSize = r->RecLen - 1; // take off 1 for the delete byte
  if (fseek(f, -1, SEEK_END))
    goto bailout;
  fread(&LastByte, 1, 1, f);
  if (fseek(f, 0, SEEK_SET))
    goto bailout;
  fstat(fileno(f), &st);
  if ((st.st_size - (LastByte == '\x1A')) % (RecordSize + 2)) {
    // take off 1 for the ^Z at the end of the file and add 2 for the cr/lf bytes
    err = bad_number_of_records_in_SDF;
    goto err216;
  }
  NumberOfRecords = (st.st_size - (LastByte == '\x1A'))/(RecordSize + 2);
  r->CurRecord[0] = 32; // set deleted byte to a space
  IndexOpen = IndexPresent ? IndexRoutines.IndexOpenFunc() : FALSE;
  for (i = 0; i < NumberOfRecords; i++) {
    fread(&r->CurRecord[1], RecordSize, 1, f);
    fread(&CRLF, 2, 1, f); // go past the cr/lf
    if ((CRLF != 0x0A0D) && (CRLF != 0x0D0A)) {
      err = SDF_bad_format;
      goto err216;
    }
    if (IndexOpen) {
      ExportData(); // move from currecord to pascal record
      OkToAppend = ValidFunc ? ValidFunc() : TRUE;
      if (OkToAppend)
        Append();
    }
    else {
      if (!ValidFunc)
        OkToAppend = TRUE;
      else {
        ExportData();
        OkToAppend = ValidFunc();
      }
      if (OkToAppend)
        AppendDbf(r);
    }
  }
  fclose(f);
  Skip(0);
  return;

bailout:
  fclose(f);
  SetError(errno, 3, Error_reading, fn, funcname);
  return;

err216:
  fclose(f);
  SetError(216, 2, err, funcname);
  return;
}
