/* filename: SETMOUSE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef WINDOWS
#include <stdio.h>
#include <stdlib.h>
#include <common.h>
#include <dos.h>
  
unsigned int PreviousEventMask  = 0;
void (_far * PreviousHandler)(void)  = NULL;
  
void SetMouseHandlerTo(void (_far *p)(void))
{
  struct REGPACK cpu;
  void (_far *handler)();
  static int FirstCall = TRUE;
  
  if (MouseDriverPresent) {
    if (!p) {
      if (FirstCall)
        return;
      handler = PreviousHandler;
      cpu.r_cx = PreviousEventMask;
    }
    else {
      handler = p;
      cpu.r_cx = 0x7F;
    }
    // install OUR handler, save the other guy's
    cpu.r_ax = 0x0014;
    cpu.r_es = (unsigned)(((unsigned long)handler>>16) & 0xFFFF);
    cpu.r_dx = (unsigned)(0xFFFF & (unsigned long)handler);
    intr(0x33, &cpu);
    PreviousEventMask = cpu.r_cx;
    PreviousHandler = MK_FP(cpu.r_es, cpu.r_dx);
    FirstCall = FALSE;
  }
}
#endif
