/* filename: SETERROR.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <common.h>

long TopazRegisterFlags = 0L;

static char _tzfar unitname[17][9] = {
  "COMMON","VIDPOP","SAYGET","CLOCK","TIMEDATE","INDEX","DBF","CALC",
   "SAVER","BROWSE","DIALOG","PICK","EDIT","VFILES","MEMO","PRINTCOM",
   "PARSER"
};

void SetError(int error, int NumberOfStrings, ...)
{
  int i;
  char *p;
  va_list args;

  *ErrorMessage = 0;
  va_start(args, NumberOfStrings); // get variable arg pointer
  for (i = 0; i < NumberOfStrings; i++) {
    p = va_arg(args, char *);
    if (i)
      strcat(ErrorMessage, p);
    else
      strcpy(ErrorMessage, p); // format into buf with variable args
  }
  va_end(args); // finish the arglist
  DBFError = error;
  if (AutoHalt)
    OnErrorHalt();
}

BOOL CheckRegisteredUnits(const char *funcname, long flagswanted)
{
  int i, noinithdr = 0;
  char buf[400], buf1[60];
  long tmp, mask = 1L;

  tmp = flagswanted & TopazRegisterFlags;
  if (tmp == flagswanted) // all necessary units are registered...
    return 1;
  sprintf(buf, "Detected missing initialization code for %s()\n"
      "Main module requires:", funcname);
  for (i = 0; i < 17; ++i) {
    if ((flagswanted & mask)  && !(tmp & mask)) {
      if (i) {
        sprintf(buf1, "\n   #include <%s.h>", (char far*) unitname[i]);
        strcat(buf, buf1);
      }
      else // the guy did not include the init.h file in the main unit...
        noinithdr = 1;
    }
    mask <<= 1;
  }
  if (noinithdr) {
    strcat(buf, "\n   #include <init.h>");
#if (defined (WINDOWS) && defined (__BORLANDC__)) || defined (_MSC_VER)
    strcat(buf, "\n   InitTopaz();");
#endif
  }
  SetError(31, 1, buf);
  return 0;
}
