/* filename: REGS.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <msc.h>

#ifdef _MSC_VER
#include <dos.h>
#include <string.h>
#include <graph.h>
#include <time.h>
#include <conio.h>

struct WSREGS {
  union  REGS  regs;  // Word registers and carry flag of 8088
  struct SREGS sregs; // Segment registers of 8088
};

union REGUNION {
  struct REGPACK regpack;
  struct WSREGS wsregs;
};

void intr(int intno, struct REGPACK *preg)
{
  union REGUNION * r;

  r = (union REGUNION *)preg;
  int86x(intno, &(r->wsregs.regs), &(r->wsregs.regs), &(r->wsregs.sregs));

  return;
}

#ifndef WINDOWS

void gotoxy( int col, int row )
{
  _settextposition( (short)(row), (short)(col) );
}

int wherex(void)
{
  unsigned vpage;
  struct REGPACK cpu;
  short left, top, right, bottom;

  _gettextwindow(&top, &left, &bottom, &right);
  memset(&cpu,0,sizeof(cpu));
  cpu.r_ax = 0x0f00;
  intr(0x10, &cpu);
  vpage = cpu.r_bx; // in fact video page = vpage >> 8
  memset(&cpu,0,sizeof(cpu));
  cpu.r_ax = 0x0300;
  cpu.r_bx = vpage;
  intr(0x10, &cpu);
  return (cpu.r_dx & 0xFF) + 2 - left;
}

int wherey(void)
{
  unsigned vpage;
  struct REGPACK cpu;
  short left, top, right, bottom;

  _gettextwindow(&top, &left, &bottom, &right);
  memset(&cpu,0,sizeof(cpu));
  cpu.r_ax = 0x0f00;
  intr(0x10, &cpu);
  vpage = cpu.r_bx; // in fact video page = vpage >> 8
  memset(&cpu,0,sizeof(cpu));
  cpu.r_ax = 0x0300;
  cpu.r_bx = vpage;
  intr(0x10, &cpu);
  return (cpu.r_dx >> 8) + 2 - top;
}

#endif

void delay( clock_t wait )
{
  clock_t goal;

  goal = wait + clock();
  while(goal > clock())
    ;
}

#endif
