;/* filename: FASTWR.ASM
;
;: T O P A Z for C :Ŀ
;                          Version 4.5  05/16/93                              
;                                                                             
; Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
; Unauthorized distribution or disclosure of this source code or modification 
;  or removal of this notice  constitutes a breach of the license agreement.  
;
;*/

;       FASTWR.ASM
;       Fast screen writing and associated routines
;       By Brian Foley
;       Last update  : 09/20/92
;	command line : tasm /mx /zi tasrwr.asm

        .MODEL  LARGE

	.DATA

        EXTRN   _BaseOfScreen       : WORD
        EXTRN   _MouseDriverPresent : WORD
        EXTRN   _MouseIsVisible     : WORD
        EXTRN   _WaitForRetrace     : WORD

        .CODE

        PUBLIC  _FastWrite
        PUBLIC  _ChangeAttribute
        PUBLIC  _MoveScreenData
        PUBLIC  _EgaInstalled
        PUBLIC  _CurrentVideoMode

;****************************************************** CalcOffset

;Calculates offset in video memory corresponding to Row,Column
;On entry, CH has Row, BX has Column (both 1-based)
;On exit, ES:DI points to proper address in video memory, AX = 0

CalcOffset      PROC NEAR

        XOR     AX,AX                   ;AX = 0
        MOV     CL,AL                   ;CL = 0
        DEC     CH                      ;Row (in CH) to 0..24 range
        SHR     CX,1                    ;CX = Row * 128
        MOV     DI,CX                   ;Store in DI
        SHR     DI,1                    ;DI = Row * 64
        SHR     DI,1                    ;DI = Row * 32
        ADD     DI,CX                   ;DI = (Row * 160)
        DEC     BX                      ;Col (in BX) to 0..79 range
        SHL     BX,1                    ;Account for attribute bytes
        ADD     DI,BX                   ;DI = (Row * 160) + (Col * 2)
        MOV     ES,_BaseOfScreen        ;ES:DI points to _BaseOfScreen:Row,Col
        RET                             ;Return

CalcOffset      ENDP

HideMouse       PROC NEAR               ; save mouse visibility, hide mouse gbr
        PUSH    AX                      ; save AX, we will use it
        MOV     AX, _MouseDriverPresent ; if mouse driver there?
        CMP     AX,0                    ; set the zero flag
        JZ      DONE1                   ; driver not there
        MOV     AX, _MouseIsVisible     ; is the mouse cursor showing?
        CMP     AX,0                    ; set the zero flag
        JZ      DONE1                   ; mouse is already hidden
        MOV     AX, 2                   ; function 2 = Hide mouse
        INT     33H                     ; call mouse driver
DONE1:  POP     AX
        RET
HideMouse       ENDP

ShowMouse       PROC NEAR               ; restore mouse visibility, is appropriate gbr
        PUSH    AX                      ; save AX, we will use it
        MOV     AX, _MouseDriverPresent ; if mouse driver there?
        CMP     AX,0                    ; set the zero flag
        JZ      DONE2                   ; driver not there
        MOV     AX, _MouseIsVisible     ; was the mouse cursor showing?
        CMP     AX,0                    ; set the zero flag
        JZ      DONE2                   ; mouse was not showing
        MOV     AX, 1                   ; function 1 = Show mouse
        INT     33H                     ; call mouse driver
DONE2:  POP     AX
        RET
ShowMouse       ENDP

;****************************************************** FastWrite

;void FastWrite(char far *St, int Row, int Col, int Attr);

;Write St at Row,Col in Attr (video attribute) without snow

_FastWrite      PROC FAR

;equates for parameters:
FWAttr          EQU     BYTE PTR [BP+14]
FWCol           EQU     WORD PTR [BP+12]
FWRow           EQU     BYTE PTR [BP+10]
FWSt            EQU     DWORD PTR [BP+6]

;        ARG     FWSt:DWORD, FWRow:BYTE, FWCol:WORD, FWAttr:BYTE

        CALL    HideMouse               ;save mouse visibility, then hide it {gbr}
        PUSH    BP                      ;Save BP
        MOV     BP,SP                   ;Set up stack frame
        PUSH    DS                      ;Save DS
        PUSH    SI                      ;Save SI
        PUSH    DI                      ;Save DI
        MOV     CH,[FWRow]              ;CH = Row
        MOV     BX,[FWCol]              ;BX = Column
        CALL    CalcOffset              ;Call routine to calculate offset
        LDS     SI,[FWSt]               ;DS:SI points to St[0]
        CLD                             ;Set direction to forward

        XOR     CX,CX                   ;Clear CX
FWNext:
        LODSB                           ;Character -> AL
        OR      AL,AL                   ;If AL == 0
        JZ      FWContinue              ;  goto FWContinue
        INC     CX                      ;else CX++
        JMP     FWNext                  ;goto FWNext
FWContinue:
        OR      CX,CX                   ;If string empty,
        JZ      FWExit                  ;Exit
        LDS     SI,FWSt                 ;DS:SI points to St[0]
        CLD                             ;Set direction to forward
        MOV     AX,_WaitForRetrace      ;Grab this before changing DS
                                        ;CX = Length; AX = _WaitForRetrace

        MOV     AH,[FWAttr]             ;AH = Attribute
        RCR     AL,1                    ;If _WaitForRetrace is False...
        JNC     FWMono                  ; use "FWMono" routine
        MOV     DX,03DAh                ;Point DX to CGA status port
FWGetNext:
        LODSB                           ;Load next character into AL
                                        ; AH already has Attr
        MOV     BX,AX                   ;Store video word in BX
        CLI                             ;No interrupts now
FWWaitNoH:
        IN      AL,DX                   ;Get 6845 status
        TEST    AL,8                    ;Vertical retrace in progress?
        JNZ     FWStore                 ;If so, go
        RCR     AL,1                    ;Else, wait for end of
        JC      FWWaitNoH               ; horizontal retrace
FWWaitH:
        IN      AL,DX                   ;Get 6845 status again
        RCR     AL,1                    ;Wait for horizontal
        JNC     FWWaitH                 ; retrace
FWStore:
        MOV     AX,BX                   ;Move word back to AX...
        STOSW                           ; and then to screen
        STI                             ;Allow interrupts!
        LOOP    FWGetNext               ;Get next character
        JMP     FWExit                  ;Done
FWMono:
        LODSB                           ;Load next character into AL
                                        ; AH already has Attr
        STOSW                           ;Move video word into place
        LOOP    FWMono                  ;Get next character
FWExit:
        POP     DI                      ;Restore DI
        POP     SI                      ;Restore SI
        POP     DS                      ;Restore DS
        MOV     SP,BP                   ;Restore SP
        POP     BP                      ;Restore BP
        CALL    ShowMouse               ;turn mouse cursor back on, if visible {gbr}
        RET                             ;Remove parameters and return

_FastWrite      ENDP

;****************************************************** ChangeAttribute

;void ChangeAttribute(int Number, int Row, int Col, int Attr);

;Change Number video attributes to Attr starting at Row,Col

_ChangeAttribute PROC FAR

;equates for parameters:
CAAttr          EQU     BYTE PTR [BP+12]
CACol           EQU     WORD PTR [BP+10]
CARow           EQU     BYTE PTR [BP+8]
CANumber        EQU     WORD PTR [BP+6]
;        ARG     CANumber:WORD, CARow:BYTE, CACol:WORD, CAAttr:BYTE

        CALL    HideMouse               ; gbr
        PUSH    BP                      ;Save BP
        MOV     BP,SP                   ;Set up stack frame
        PUSH    DI                      ;Save DI
        MOV     CH,[CARow]              ;CH = Row
        MOV     BX,[CACol]              ;BX = Column
        CALL    CalcOffset              ;Call routine to calculate offset
        INC     DI                      ;Skip character
        CLD                             ;Set direction to forward
        MOV     CX,[CANumber]           ;CX = Number to change
        JCXZ    CAExit                  ;If zero, exit
        MOV     AL,[CAAttr]             ;AL = Attribute
        CMP     _WaitForRetrace,1       ;Get wait state
        JNE     CANoWait                ;If _WaitForRetrace is False
                                        ; use CANoWait routine
        MOV     AH,AL                   ;Store attribute in AH
        MOV     DX,03DAh                ;Point DX to CGA status port
CAGetNext:
        CLI                             ;No interrupts now
CAWaitNoH:
        IN      AL,DX                   ;Get 6845 status
        TEST    AL,8                    ;Check for vert. retrace
        JNZ     CAGo                    ;In progress? Go
        RCR     AL,1                    ;Wait for end of horizontal
        JC      CAWaitNoH               ; retrace
CAWaitH:
        IN      AL,DX                   ;Get 6845 status again
        RCR     AL,1                    ;Wait for horizontal
        JNC     CAWaitH                 ; retrace
CAGo:
        MOV     AL,AH                   ;Move Attr back to AL...
        STOSB                           ; and then to screen
        STI                             ;Allow interrupts
        INC     DI                      ;Skip characters
        LOOP    CAGetNext               ;Look for next opportunity
        JMP     CAExit                  ;Done
CANoWait:
        STOSB                           ;Change the attribute
        INC     DI                      ;Skip characters
        LOOP    CANoWait                ;Get next character
CAExit:                                 ;Next instruction
        POP     DI                      ;Restore DI
        MOV     SP,BP                   ;Restore SP
        POP     BP                      ;Restore BP
        CALL    ShowMouse               ;gbr
        RET                             ;Remove parameters and return

_ChangeAttribute ENDP

;****************************************************** MoveScreenData

;void MoveScreenData(void far *Source, void far *Dest, int Length);

;Move Length words from Source  to Dest without snow

_MoveScreenData PROC FAR

;equates for parameters:
MFLength        EQU     WORD PTR [BP+14]
MFDest          EQU     DWORD PTR [BP+10]
MFSource        EQU     DWORD PTR [BP+6]

;        ARG     MFSource:DWORD, MFDest:DWORD, MFLength:WORD

        CALL    HideMouse               ; gbr
        PUSH    BP                      ;Save BP
        MOV     BP,SP                   ;Set up stack frame
        PUSH    DS                      ;Save DS
        PUSH    SI                      ;Save SI
        PUSH    DI                      ;Save DI
        MOV     AX,_WaitForRetrace      ;Grab before changing DS
        LES     DI,[MFDest]             ;ES:DI points to Dest
        LDS     SI,[MFSource]           ;DS:SI points to Source
        MOV     CX,[MFLength]           ;CX = Length
        CLD                             ;Set direction to forward
        RCR     AL,1                    ;Check _WaitForRetrace
        JNC     MFNoWait                ;False? Use MFNoWait routine
        MOV     DX,03DAh                ;Point DX to CGA status port
MFNext:
;        CLI                             ;No interrupts now
MFWaitNoH:
        IN      AL,DX                   ;Get 6845 status
        TEST    AL,8                    ;Check for vertical retrace
        JNZ     MFGo                    ;In progress? go
        RCR     AL,1                    ;Wait for end of horizontal
        JC      MFWaitNoH               ; retrace
MFWaitH:
        IN      AL,DX                   ;Get 6845 status again
        RCR     AL,1                    ;Wait for horizontal
        JNC     MFWaitH                 ; retrace
MFGo:
        LODSW                           ;Load next word into AX
;        STI                             ;Allow interrupts
        STOSW                           ;Store  word in Dest
        LOOP    MFNext                  ;Get next word
        JMP     MFExit                  ;All Done
MFNoWait:
        REP     MOVSW                   ;That's it!
MFExit:
        POP     DI                      ;Restore DI
        POP     SI                      ;Restore SI
        POP     DS                      ;Restore DS
        MOV     SP,BP                   ;Restore SP
        POP     BP                      ;Restore BP
        CALL    ShowMouse               ; gbr
        RET                             ;Remove parameters and return

_MoveScreenData ENDP

;****************************************************** EgaInstalled

;int EgaInstalled(void);

;Returns true (AX = 1) if EGA is installed, else false (AX = 0)

_EgaInstalled   PROC FAR

        push	bx
	push	cx
	MOV     AX,1200h
        MOV     BX,10h
        MOV     CX,0FFFFh               ;Initialize CX
        INT     10h                     ;Call BIOS
        XOR     AX,AX                   ;Assume false
        CMP     CX,0FFFFh               ;Has CX changed?
        JE      EIDone                  ;No? Done
        INC     AX                      ;Yes, AX = True
EIDone:
        OR      AX,AX                   ;Set zero flag
	pop	cx
	pop	bx
        RET                             ;Return

_EgaInstalled   ENDP

;****************************************************** CurrentVideoMode

;int CurrentVideoMode(void);

;Returns current video mode in AX

_CurrentVideoMode PROC FAR

       MOV      AH,0Fh                  ;Get video mode function
       INT      10h                     ;Call BIOS
       XOR      AH,AH                   ;Clear AH, AL has video mode
       RET                              ;Return

_CurrentVideoMode ENDP

        END