/* filename: ENMOUSE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef WINDOWS
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dos.h>
#include <common.h>
  
int MouseEnabled = FALSE;
static unsigned char SaveMouseX=0, SaveMouseY=0;

static void ShowMousePointer(int on)
{
  struct REGPACK cpu;
  static int Counter = -1;
  
  if (MouseDriverPresent) {
    cpu.r_ax = on ? 1 : 2;
    intr(0x33, &cpu);
    if (on)
      ++Counter;
    else
      --Counter;
    if (Counter > 0)
      Counter = 0;
    MouseIsVisible = Counter ? 0 : 1;
  }
}

void EnableMouse(void)
{
  TargetListPtr p;
  
  if (MouseDriverPresent && !MouseEnabled && MouseTargetList) {
    memset(&Event, 0, sizeof(Event));
    if (AutoMousePlacement) {
      p = MouseTargetList;
      while (p->NextPtr)
        p = p->NextPtr;
      GetMouseXY(&SaveMouseX,&SaveMouseY);
      SetMouseXY((unsigned char)((p->x1 + p->x2)/2),(unsigned char)((p->y1 + p->y2)/2));
    }
    ShowMousePointer(TRUE);
    SetMouseHandlerTo(MouseCallBack);
    MouseEnabled = TRUE;
  }
}

void DisableMouse(void)
{
  TargetListPtr p;
  
  if (MouseDriverPresent && MouseEnabled) {
    ShowMousePointer(FALSE);
    SetMouseHandlerTo(NULL);
    while (MouseTargetList) {
      p = MouseTargetList->NextPtr;
      free(MouseTargetList);
      MouseTargetList = p;
    }
    MouseEnabled = FALSE;
    if (AutoMousePlacement)
      SetMouseXY(SaveMouseX, SaveMouseY);
    LeftButtonWasDown = RightButtonWasDown = CenterButtonWasDown = FALSE;
  }
}
  
void HideMouse(void)
{
  ShowMousePointer(FALSE);
}
  
void ShowMouse(void)
{
  ShowMousePointer(TRUE);
}
#endif
