/* filename: CLCGETKE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <math.h>
#include <string.h>
#include <sayget.h>
#include <calc.h>
  
char CalcDigit = 0;
  
CommandKeys CalcGetKey(void)
{
  static char SecondChar = '\xFF';
  char c;
  EventRec e;
  
  c = '\xFF';
  if(SecondChar == '\xFF') {
    memset(&e, 0, sizeof(e));
    do {
    }  while (!(EventPending() || CalcScrollLock()));
    if (CalcScrollLock())
      return MoveCmd;
    GetEvent(&e);
  }
  else {
    e.WhichEvent = Keyboard;
    e.v.sKeyboard.Key = SecondChar;
    SecondChar = '\xFF';
  }
  switch (e.WhichEvent) {
    case Mouse:
    switch(e.v.sMouse.TargetID) {
      case ZeroDigitTarget: c = '0'; break;
      case OneDigitTarget:
      case TwoDigitTarget:
      case ThreeDigitTarget:
      case FourDigitTarget:
      case FiveDigitTarget:
      case SixDigitTarget:
      case SevenDigitTarget:
      case EightDigitTarget:
      case NineDigitTarget: c = (char)(abs(e.v.sMouse.TargetID)+48); break;
      case ClearAllTarget:   c = 'C'; break;
      case ClearEntryTarget: c = 'E'; break;
      case BackSpaceTarget:  c = '\x8'; break;
      case DivisionTarget:   c = '/'; break;
      case ChangeSignTarget: c = '\\'; break;
      case ImportTarget:     c = 'I'; break;
      case MultiplyTarget:   c = '*'; break;
      case EnterTarget:      c = '\x0D'; break;
      case EscapeTarget:     c = '\x1b'; break;
      case MinusTarget:      c = '-'; break;
      case ScrollLockTarget: return MoveCmd;
      case DotTarget:        c = '.'; break;
      case EqualTarget:      c = '='; break;
      case PlusTarget:       c = '+'; break;
      case MemPlusTarget:    c = 'M'; SecondChar = '+'; break;
      case MemMinusTarget:   c = 'M'; SecondChar = '-'; break;
      case MemTimesTarget:   c = 'M'; SecondChar = '*'; break;
      case MemDivideTarget:  c = 'M'; SecondChar = '/'; break;
      case MemRecallTarget:  c = 'M'; SecondChar = 'R'; break;
      case MemClearTarget:   c = 'M'; SecondChar = 'C'; break;
      case MoveCalcTarget : ;
    }
      break;
    case Keyboard:
      c = UpCase(e.v.sKeyboard.Key);
      break;
  }
  switch(c) {
    case  '+':   return AddCmd;
    case  '-':   return SubtractCmd;
    case  '*':   return MultiplyCmd;
    case  '/':   return DivideCmd;
    case  '=':   return EqualsCmd;
    case  'C':   return ClearCmd;
    case  'E':   return ClearEntryCmd;
    case '\\':   return ChangeSignCmd;
    case  'M':   return MemoryCmd;
    case  'R':   return RecallCmd;
    case  'I':   return ImportCmd;
    case '\r':   return EnterCmd;
    case '\b':   return BackSpaceCmd;
    case '\x1B':   return AbandonCmd;
    case '.':  case ',':
      if (c == DecimalSymbol)
        return DecimalCmd;
    case '0': case '1': case '2':
    case '3': case '4': case '5':
    case '6': case '7': case '8':
    case '9': {
      CalcDigit = c;
      return DigitCmd;
    }
  }
  return NoCmd;
}
