/* filename: SETTOSTR.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>
#include <sayget.h>
#include <utils.h>

extern char _tzfar browse_str[STRSIZ];

static unsigned char mask(int j)
{
  unsigned char Temp;
  int           i;

  if(j > 1) {
    for(Temp = i = 1; i <= j - 1; i++)
      Temp <<= 1;
    return Temp;
  } else
    return 1;
}

char *SetToString(void *x)
{
  typedef unsigned char SetType[32];

  char AltLetters1[11]  = "QUERTYUIOP";
  char AltLetters2[10]  = "ASDFGHJKL";
  char AltLetters3[8]   = "ZXCVBNM";

  SetType *y;
  int i, j, Key;

  y = (SetType *)x;
  *browse_str = 0;

  for(i = 0; i <= 31; i++)
    for (j = 1; j <= 8; j++)
      if((unsigned char) ((*y)[i] & mask(j)) == mask(j)) {
        Key = 8 * (i - 1) + (j - 1);
        if((Key >= 0) && (Key <= 12) || (Key >= 14) && (Key <= 26))
          strcat(browse_str, fBuildStr("^%c", Key + 64));
        else
          if(Key == '\r')
            strcat(browse_str, "Enter");
          else
            if(Key == '\x1B')
              strcat(browse_str, "ESC");
            else
              if((Key >= 187) && (Key <= 196))
                strcat(browse_str, fBuildStr("F%s", SInteger(Key - 186, 0)));
              else
                if((Key >= 212) && (Key <= 221))
                  strcat(browse_str, fBuildStr("SF%s", SInteger(Key - 211, 0)));
                else
                  if((Key >= 222) && (Key <= 231))
                    strcat(browse_str, fBuildStr("CF%s", SInteger(Key - 221, 0)));
                  else
                    if((Key >= 232) && (Key <= 241))
                      strcat(browse_str, fBuildStr("AF%s", SInteger(Key - 231, 0)));
                    else
                      if((Key >= 144) && (Key <= 153))
                        strcat(browse_str, fBuildStr("ALT-%s", AltLetters1[Key - 143]));
                      else
                        if((Key >= 158) && (Key <= 166))
                          strcat(browse_str, fBuildStr("ALT-%s", AltLetters2[Key - 157]));
                        else
                          if((Key >= 172) && (Key <= 178))
                            strcat(browse_str, fBuildStr("ALT-%s", AltLetters3[Key - 171]));
                          else
                            strcat(browse_str, fBuildStr("%c", Key));
        strcat(browse_str, "/");
      }
  i = strlen(browse_str);
  if(browse_str[i - 1] == '/')
    browse_str[i - 1] = 0;

  return browse_str;
}
