/* filename: RESETFF.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <browse.h>
#include <brwsvars.h>

void ResetFirstField(int fieldnumber)
{
  int i, n, width;
  int savedBASEOrder;

  if(!br_priv.BrowseActive) {
    SetError(BrowseNotActive, 1, " [ResetFirstField]");
    return;
  }
  if((fieldnumber < 1) || (fieldnumber > FieldCount()))
    return;

  for(n = 0, i = 1; i <= br_priv.MaxFields; i++)
    if(br_priv.FMAP[i-1] == (unsigned char) fieldnumber)
      n = i;

  if(!n)
    return;

  br_priv.FirstField = n;
  width = 0;

  do {
    width += br_priv.ColumnWidth[n++] + 1;
  } while((width <= br_priv.bScreenWidth) || (n != br_priv.MaxFields));

  if(width > br_priv.bScreenWidth)
    n++;

  br_priv.LastField    = --n;
  br_priv.CurrentField = br_priv.FirstField;

  savedBASEOrder = dBASEOrder;
  dBASEOrder     = TRUE;
  PanPaintScreen();
  dBASEOrder     = savedBASEOrder;
}
